/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultNodeSet<E extends OWLLogicalEntity>
implements NodeSet<E> {
    private Set<Node<E>> nodes = new HashSet<Node<E>>();

    public DefaultNodeSet() {
    }

    public DefaultNodeSet(E entity) {
        this.nodes.add(this.getNode(entity));
    }

    public DefaultNodeSet(Node<E> node) {
        this.nodes.add(node);
    }

    public DefaultNodeSet(Set<Node<E>> nodes) {
        this.nodes.addAll(nodes);
    }

    @Override
    public Set<Node<E>> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public void addEntity(E entity) {
        this.addNode(this.getNode(entity));
    }

    public void addNode(Node<E> node) {
        this.nodes.add(node);
    }

    public void addAllNodes(Collection<Node<E>> nodes) {
        this.nodes.addAll(nodes);
    }

    public void addSameEntities(Set<E> entities) {
        this.nodes.add(this.getNode(entities));
    }

    public void addDifferentEntities(Set<E> entities) {
        for (OWLLogicalEntity e : entities) {
            this.addNode(this.getNode(e));
        }
    }

    protected abstract DefaultNode<E> getNode(E var1);

    protected abstract DefaultNode<E> getNode(Set<E> var1);

    @Override
    public Set<E> getFlattened() {
        HashSet<E> result = new HashSet<E>();
        for (Node<E> node : this.nodes) {
            result.addAll(node.getEntities());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean containsEntity(E e) {
        for (Node<E> node : this.nodes) {
            if (!node.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSingleton() {
        return this.nodes.size() == 1;
    }

    @Override
    public boolean isTopSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isTopNode();
    }

    @Override
    public boolean isBottomSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isBottomNode();
    }

    @Override
    public Iterator<Node<E>> iterator() {
        return this.nodes.iterator();
    }
}

