/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.CachingBidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.ReferencedEntitySetProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BidirectionalShortFormProviderAdapter
extends CachingBidirectionalShortFormProvider {
    private ShortFormProvider shortFormProvider;
    private Set<OWLOntology> ontologies;
    private OWLOntologyManager man;
    private OWLOntologyChangeListener changeListener = new OWLOntologyChangeListener(){

        @Override
        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            BidirectionalShortFormProviderAdapter.this.handleChanges(changes);
        }
    };

    public BidirectionalShortFormProviderAdapter(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public BidirectionalShortFormProviderAdapter(Set<OWLOntology> ontologies, ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
        this.ontologies = new HashSet<OWLOntology>(ontologies);
        this.rebuild(new ReferencedEntitySetProvider(ontologies));
    }

    public BidirectionalShortFormProviderAdapter(OWLOntologyManager man, Set<OWLOntology> ontologies, ShortFormProvider shortFormProvider) {
        this.man = man;
        this.ontologies = ontologies;
        this.shortFormProvider = shortFormProvider;
        this.man = man;
        this.man.addOntologyChangeListener(this.changeListener);
        this.rebuild(new ReferencedEntitySetProvider(ontologies));
    }

    @Override
    protected String generateShortForm(OWLEntity entity) {
        return this.shortFormProvider.getShortForm(entity);
    }

    @Override
    public void dispose() {
        if (this.man != null) {
            this.man.removeOntologyChangeListener(this.changeListener);
        }
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet<OWLEntity> processed = new HashSet<OWLEntity>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
            if (oWLOntologyChange instanceof AddAxiom) {
                AddAxiom addAx = (AddAxiom)oWLOntologyChange;
                for (OWLEntity ent : addAx.getEntities()) {
                    if (processed.contains(ent)) continue;
                    processed.add(ent);
                    this.add(ent);
                }
                continue;
            }
            if (!(oWLOntologyChange instanceof RemoveAxiom)) continue;
            RemoveAxiom remAx = (RemoveAxiom)oWLOntologyChange;
            for (OWLEntity ent : remAx.getEntities()) {
                if (processed.contains(ent)) continue;
                processed.add(ent);
                boolean stillRef = false;
                for (OWLOntology ont : this.ontologies) {
                    if (!ont.containsEntityInSignature(ent)) continue;
                    stillRef = true;
                    break;
                }
                if (stillRef) continue;
                this.remove(ent);
            }
        }
    }
}

