c_strDir <- file.path(getwd( ),"..")

source(file.path(c_strDir,"lib","Constants.R"))
source(file.path(c_strDir,"lib","ValidateData.R"))

context("Test funcIsValid")
test_that("NA and NUll are false, all others are true",{
  expect_equal(funcIsValid(NA),FALSE)
  expect_equal(funcIsValid(NULL),FALSE)
  expect_equal(funcIsValid(1), TRUE)
  expect_equal(funcIsValid("3"), TRUE)
  expect_equal(funcIsValid(c("3","4")), TRUE)
  expect_equal(funcIsValid(c(3,NA)), TRUE)
  expect_equal(funcIsValid(""), TRUE)
  expect_equal(funcIsValid(list()), TRUE)
  expect_equal(funcIsValid(2.3), TRUE)
  expect_equal(funcIsValid(TRUE), TRUE)
  expect_equal(funcIsValid(FALSE), TRUE)
  expect_equal(funcIsValid(as.factor(3)), TRUE)
})

context("Test funcIsValidString")
test_that("Test only strings are true",{
  expect_equal(funcIsValidString(NA),FALSE)
  expect_equal(funcIsValidString(NULL),FALSE)
  expect_equal(funcIsValidString(1), FALSE)
  expect_equal(funcIsValidString("3"), TRUE)
  expect_equal(funcIsValidString(c("3","4")), FALSE)
  expect_equal(funcIsValidString(""), TRUE)
  expect_equal(funcIsValidString(list()), FALSE)
  expect_equal(funcIsValidString(2.3), FALSE)
  expect_equal(funcIsValidString(TRUE), FALSE)
  expect_equal(funcIsValidString(FALSE), FALSE)
})

context("Test funcIsValidFileName")
strFileSimpleRCFileAnswer = file.path(c_strDir,c_strTestingDirectory,c_strCorrectAnswers,"FuncWriteMatrixToReadConfigFile_SimpleAnswer.read.config")
strFileUseAllRCFileAnswer = file.path(c_strDir,c_strTestingDirectory,c_strCorrectAnswers,"FuncWriteMatrixToReadConfigFile_AllAnswer.read.config")

test_that("Test only strings pointing to existing files are true",{
  expect_equal(funcIsValidFileName(NA),FALSE)
  expect_equal(funcIsValidFileName(NULL),FALSE)
  expect_equal(funcIsValidFileName(1), FALSE)
  expect_equal(funcIsValidFileName("3"), FALSE)
  expect_equal(funcIsValidFileName(c("3","4")), FALSE)
  expect_equal(funcIsValidFileName(""), FALSE)
  expect_equal(funcIsValidFileName(list()), FALSE)
  expect_equal(funcIsValidFileName(2.3), FALSE)
  expect_equal(funcIsValidFileName(TRUE), FALSE)
  expect_equal(funcIsValidFileName(FALSE), FALSE)
  expect_equal(funcIsValidFileName(strFileSimpleRCFileAnswer),TRUE)
  expect_equal(funcIsValidFileName(strFileUseAllRCFileAnswer),TRUE)
})
