from typing import Any, Dict

# --- Constants ---
SPLIT_COLUMN_NAME = "split"
LABEL_COLUMN_NAME = "label"
IMAGE_PATH_COLUMN_NAME = "image_path"
DEFAULT_SPLIT_PROBABILITIES = [0.7, 0.1, 0.2]
TEMP_CSV_FILENAME = "processed_data_for_ludwig.csv"
TEMP_CONFIG_FILENAME = "ludwig_config.yaml"
TEMP_DIR_PREFIX = "gleam_image_work_"
PREDICTIONS_PARQUET_FILE_NAME = "predictions.parquet"
TEST_STATISTICS_FILE_NAME = "test_statistics.json"
TRAIN_SET_METADATA_FILE_NAME = "train_set_metadata.json"
DESCRIPTION_FILE_NAME = "description.json"
TRAINING_STATISTICS_FILE_NAME = "training_statistics.json"
PREDICTIONS_SHAPES_FILE_NAME = "predictions.shapes"
MODEL_ENCODER_TEMPLATES: Dict[str, Any] = {
    "stacked_cnn": "stacked_cnn",
    "resnet18": {"type": "resnet", "model_variant": 18},
    "resnet34": {"type": "resnet", "model_variant": 34},
    "resnet50": {"type": "resnet", "model_variant": 50},
    "resnet101": {"type": "resnet", "model_variant": 101},
    "resnet152": {"type": "resnet", "model_variant": 152},
    "resnext50_32x4d": {"type": "resnext", "model_variant": "50_32x4d"},
    "resnext101_32x8d": {"type": "resnext", "model_variant": "101_32x8d"},
    "resnext101_64x4d": {"type": "resnext", "model_variant": "101_64x4d"},
    "resnext152_32x8d": {"type": "resnext", "model_variant": "152_32x8d"},
    "wide_resnet50_2": {"type": "wide_resnet", "model_variant": "50_2"},
    "wide_resnet101_2": {"type": "wide_resnet", "model_variant": "101_2"},
    "wide_resnet103_2": {"type": "wide_resnet", "model_variant": "103_2"},
    "efficientnet_b0": {"type": "efficientnet", "model_variant": "b0"},
    "efficientnet_b1": {"type": "efficientnet", "model_variant": "b1"},
    "efficientnet_b2": {"type": "efficientnet", "model_variant": "b2"},
    "efficientnet_b3": {"type": "efficientnet", "model_variant": "b3"},
    "efficientnet_b4": {"type": "efficientnet", "model_variant": "b4"},
    "efficientnet_b5": {"type": "efficientnet", "model_variant": "b5"},
    "efficientnet_b6": {"type": "efficientnet", "model_variant": "b6"},
    "efficientnet_b7": {"type": "efficientnet", "model_variant": "b7"},
    "efficientnet_v2_s": {"type": "efficientnet", "model_variant": "v2_s"},
    "efficientnet_v2_m": {"type": "efficientnet", "model_variant": "v2_m"},
    "efficientnet_v2_l": {"type": "efficientnet", "model_variant": "v2_l"},
    "regnet_y_400mf": {"type": "regnet", "model_variant": "y_400mf"},
    "regnet_y_800mf": {"type": "regnet", "model_variant": "y_800mf"},
    "regnet_y_1_6gf": {"type": "regnet", "model_variant": "y_1_6gf"},
    "regnet_y_3_2gf": {"type": "regnet", "model_variant": "y_3_2gf"},
    "regnet_y_8gf": {"type": "regnet", "model_variant": "y_8gf"},
    "regnet_y_16gf": {"type": "regnet", "model_variant": "y_16gf"},
    "regnet_y_32gf": {"type": "regnet", "model_variant": "y_32gf"},
    "regnet_y_128gf": {"type": "regnet", "model_variant": "y_128gf"},
    "regnet_x_400mf": {"type": "regnet", "model_variant": "x_400mf"},
    "regnet_x_800mf": {"type": "regnet", "model_variant": "x_800mf"},
    "regnet_x_1_6gf": {"type": "regnet", "model_variant": "x_1_6gf"},
    "regnet_x_3_2gf": {"type": "regnet", "model_variant": "x_3_2gf"},
    "regnet_x_8gf": {"type": "regnet", "model_variant": "x_8gf"},
    "regnet_x_16gf": {"type": "regnet", "model_variant": "x_16gf"},
    "regnet_x_32gf": {"type": "regnet", "model_variant": "x_32gf"},
    "vgg11": {"type": "vgg", "model_variant": 11},
    "vgg11_bn": {"type": "vgg", "model_variant": "11_bn"},
    "vgg13": {"type": "vgg", "model_variant": 13},
    "vgg13_bn": {"type": "vgg", "model_variant": "13_bn"},
    "vgg16": {"type": "vgg", "model_variant": 16},
    "vgg16_bn": {"type": "vgg", "model_variant": "16_bn"},
    "vgg19": {"type": "vgg", "model_variant": 19},
    "vgg19_bn": {"type": "vgg", "model_variant": "19_bn"},
    "shufflenet_v2_x0_5": {"type": "shufflenet_v2", "model_variant": "x0_5"},
    "shufflenet_v2_x1_0": {"type": "shufflenet_v2", "model_variant": "x1_0"},
    "shufflenet_v2_x1_5": {"type": "shufflenet_v2", "model_variant": "x1_5"},
    "shufflenet_v2_x2_0": {"type": "shufflenet_v2", "model_variant": "x2_0"},
    "squeezenet1_0": {"type": "squeezenet", "model_variant": "1_0"},
    "squeezenet1_1": {"type": "squeezenet", "model_variant": "1_1"},
    "swin_t": {"type": "swin_transformer", "model_variant": "t"},
    "swin_s": {"type": "swin_transformer", "model_variant": "s"},
    "swin_b": {"type": "swin_transformer", "model_variant": "b"},
    "swin_v2_t": {"type": "swin_transformer", "model_variant": "v2_t"},
    "swin_v2_s": {"type": "swin_transformer", "model_variant": "v2_s"},
    "swin_v2_b": {"type": "swin_transformer", "model_variant": "v2_b"},
    "vit_b_16": {"type": "vit", "model_variant": "b_16"},
    "vit_b_32": {"type": "vit", "model_variant": "b_32"},
    "vit_l_16": {"type": "vit", "model_variant": "l_16"},
    "vit_l_32": {"type": "vit", "model_variant": "l_32"},
    "vit_h_14": {"type": "vit", "model_variant": "h_14"},
    "vit_huge_timm": {"type": "vit", "model_variant": "huge_timm", "custom_encoder": True},
    # MetaFormer family (support all variants via custom_model)
    "identityformer_s12": {"type": "stacked_cnn", "custom_model": "identityformer_s12", "use_pretrained": True, "trainable": True},
    "identityformer_s24": {"type": "stacked_cnn", "custom_model": "identityformer_s24", "use_pretrained": True, "trainable": True},
    "identityformer_s36": {"type": "stacked_cnn", "custom_model": "identityformer_s36", "use_pretrained": True, "trainable": True},
    "identityformer_m36": {"type": "stacked_cnn", "custom_model": "identityformer_m36", "use_pretrained": True, "trainable": True},
    "identityformer_m48": {"type": "stacked_cnn", "custom_model": "identityformer_m48", "use_pretrained": True, "trainable": True},

    "randformer_s12": {"type": "stacked_cnn", "custom_model": "randformer_s12", "use_pretrained": True, "trainable": True},
    "randformer_s24": {"type": "stacked_cnn", "custom_model": "randformer_s24", "use_pretrained": True, "trainable": True},
    "randformer_s36": {"type": "stacked_cnn", "custom_model": "randformer_s36", "use_pretrained": True, "trainable": True},
    "randformer_m36": {"type": "stacked_cnn", "custom_model": "randformer_m36", "use_pretrained": True, "trainable": True},
    "randformer_m48": {"type": "stacked_cnn", "custom_model": "randformer_m48", "use_pretrained": True, "trainable": True},

    "poolformerv2_s12": {"type": "stacked_cnn", "custom_model": "poolformerv2_s12", "use_pretrained": True, "trainable": True},
    "poolformerv2_s24": {"type": "stacked_cnn", "custom_model": "poolformerv2_s24", "use_pretrained": True, "trainable": True},
    "poolformerv2_s36": {"type": "stacked_cnn", "custom_model": "poolformerv2_s36", "use_pretrained": True, "trainable": True},
    "poolformerv2_m36": {"type": "stacked_cnn", "custom_model": "poolformerv2_m36", "use_pretrained": True, "trainable": True},
    "poolformerv2_m48": {"type": "stacked_cnn", "custom_model": "poolformerv2_m48", "use_pretrained": True, "trainable": True},

    "convformer_s18": {"type": "stacked_cnn", "custom_model": "convformer_s18", "use_pretrained": True, "trainable": True},
    "convformer_s18_384": {"type": "stacked_cnn", "custom_model": "convformer_s18_384", "use_pretrained": True, "trainable": True},
    "convformer_s18_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_s18_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_s18_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_s18_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_s18_in21k": {"type": "stacked_cnn", "custom_model": "convformer_s18_in21k", "use_pretrained": True, "trainable": True},
    "convformer_s36": {"type": "stacked_cnn", "custom_model": "convformer_s36", "use_pretrained": True, "trainable": True},
    "convformer_s36_384": {"type": "stacked_cnn", "custom_model": "convformer_s36_384", "use_pretrained": True, "trainable": True},
    "convformer_s36_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_s36_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_s36_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_s36_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_s36_in21k": {"type": "stacked_cnn", "custom_model": "convformer_s36_in21k", "use_pretrained": True, "trainable": True},
    "convformer_m36": {"type": "stacked_cnn", "custom_model": "convformer_m36", "use_pretrained": True, "trainable": True},
    "convformer_m36_384": {"type": "stacked_cnn", "custom_model": "convformer_m36_384", "use_pretrained": True, "trainable": True},
    "convformer_m36_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_m36_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_m36_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_m36_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_m36_in21k": {"type": "stacked_cnn", "custom_model": "convformer_m36_in21k", "use_pretrained": True, "trainable": True},
    "convformer_b36": {"type": "stacked_cnn", "custom_model": "convformer_b36", "use_pretrained": True, "trainable": True},
    "convformer_b36_384": {"type": "stacked_cnn", "custom_model": "convformer_b36_384", "use_pretrained": True, "trainable": True},
    "convformer_b36_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_b36_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_b36_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "convformer_b36_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "convformer_b36_in21k": {"type": "stacked_cnn", "custom_model": "convformer_b36_in21k", "use_pretrained": True, "trainable": True},

    "caformer_s18": {
        "type": "stacked_cnn",
        "custom_model": "caformer_s18",
        "use_pretrained": True,
        "trainable": True,
    },
    "caformer_s36": {
        "type": "stacked_cnn",
        "custom_model": "caformer_s36",
        "use_pretrained": True,
        "trainable": True,
    },
    "caformer_m36": {
        "type": "stacked_cnn",
        "custom_model": "caformer_m36",
        "use_pretrained": True,
        "trainable": True,
    },
    "caformer_b36": {
        "type": "stacked_cnn",
        "custom_model": "caformer_b36",
        "use_pretrained": True,
        "trainable": True,
    },
    "caformer_s18_384": {"type": "stacked_cnn", "custom_model": "caformer_s18_384", "use_pretrained": True, "trainable": True},
    "caformer_s18_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_s18_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_s18_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_s18_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_s18_in21k": {"type": "stacked_cnn", "custom_model": "caformer_s18_in21k", "use_pretrained": True, "trainable": True},
    "caformer_s36_384": {"type": "stacked_cnn", "custom_model": "caformer_s36_384", "use_pretrained": True, "trainable": True},
    "caformer_s36_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_s36_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_s36_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_s36_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_s36_in21k": {"type": "stacked_cnn", "custom_model": "caformer_s36_in21k", "use_pretrained": True, "trainable": True},
    "caformer_m36_384": {"type": "stacked_cnn", "custom_model": "caformer_m36_384", "use_pretrained": True, "trainable": True},
    "caformer_m36_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_m36_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_m36_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_m36_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_m36_in21k": {"type": "stacked_cnn", "custom_model": "caformer_m36_in21k", "use_pretrained": True, "trainable": True},
    "caformer_b36_384": {"type": "stacked_cnn", "custom_model": "caformer_b36_384", "use_pretrained": True, "trainable": True},
    "caformer_b36_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_b36_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_b36_384_in21ft1k": {"type": "stacked_cnn", "custom_model": "caformer_b36_384_in21ft1k", "use_pretrained": True, "trainable": True},
    "caformer_b36_in21k": {"type": "stacked_cnn", "custom_model": "caformer_b36_in21k", "use_pretrained": True, "trainable": True},
    "convnext_tiny": {"type": "convnext", "model_variant": "tiny"},
    "convnext_small": {"type": "convnext", "model_variant": "small"},
    "convnext_base": {"type": "convnext", "model_variant": "base"},
    "convnext_large": {"type": "convnext", "model_variant": "large"},
    "maxvit_t": {"type": "maxvit", "model_variant": "t"},
    "alexnet": {"type": "alexnet"},
    "googlenet": {"type": "googlenet"},
    "inception_v3": {"type": "inceptionv3"},
    "mobilenet_v2": {"type": "mobilenet_v2"},
    "mobilenet_v3_large": {"type": "mobilenetv3", "model_variant": "large"},
    "mobilenet_v3_small": {"type": "mobilenetv3", "model_variant": "small"},
}
METRIC_DISPLAY_NAMES = {
    "accuracy": "Accuracy",
    "balanced_accuracy": "Balanced Accuracy",
    "accuracy_micro": "Micro Accuracy",
    "loss": "Loss",
    "roc_auc": "ROC-AUC",
    "roc_auc_macro": "Macro ROC-AUC",
    "roc_auc_micro": "Micro ROC-AUC",
    "hits_at_k": "Hits at K",
    "precision": "Precision",
    "recall": "Recall",
    "specificity": "Specificity",
    "kappa_score": "Cohen's Kappa",
    "token_accuracy": "Token Accuracy",
    "avg_precision_macro": "Macro Precision",
    "avg_recall_macro": "Macro Recall",
    "avg_f1_score_macro": "Macro F1-score",
    "avg_precision_micro": "Micro Precision",
    "avg_recall_micro": "Micro Recall",
    "avg_f1_score_micro": "Micro F1-score",
    "avg_precision_weighted": "Weighted Precision",
    "avg_recall_weighted": "Weighted Recall",
    "avg_f1_score_weighted": "Weighted F1-score",
    "average_precision_macro": "Macro Precision-Average",
    "average_precision_micro": "Micro Precision-Average",
    "average_precision_samples": "Precision-Average-Samples",
    "mean_squared_error": "Mean Squared Error",
    "mean_absolute_error": "Mean Absolute Error",
    "r2": "R² Score",
    "root_mean_squared_error": "Root Mean Squared Error",
    "mean_absolute_percentage_error": "Mean Absolute % Error",
    "root_mean_squared_percentage_error": "Root Mean Squared % Error",
}
