/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.clustering.hierachical;

import de.jstacs.clustering.distances.DistanceMetric;
import de.jstacs.clustering.hierachical.ClusterTree;
import de.jstacs.io.ArrayHandler;
import java.util.Iterator;
import java.util.LinkedList;

public class Hclust<T> {
    private DistanceMetric<T> metric;
    private Linkage linkage;

    public Hclust(DistanceMetric<T> metric, Linkage linkage) {
        this.metric = metric;
        this.linkage = linkage;
    }

    public ClusterTree<T> cluster(T ... objects) throws Exception {
        double[][] distMat = DistanceMetric.getPairwiseDistanceMatrix(this.metric, objects);
        return this.cluster(distMat, objects);
    }

    public ClusterTree<T> cluster(double[][] distMat, T ... objects) {
        LinkedList list = new LinkedList();
        int i = 0;
        while (i < objects.length) {
            list.add(new ClusterTree<Integer>(i));
            ++i;
        }
        while (list.size() > 1) {
            Iterator it = list.iterator();
            int mini = -1;
            int minj = -1;
            double min = Double.POSITIVE_INFINITY;
            int i2 = 0;
            while (it.hasNext()) {
                ClusterTree tree = (ClusterTree)it.next();
                Iterator it2 = list.iterator();
                int j = 0;
                while (j < i2) {
                    ClusterTree tree2 = (ClusterTree)it2.next();
                    double dist = this.getDistance(distMat, tree, tree2);
                    if (dist < min) {
                        min = dist;
                        mini = i2;
                        minj = j;
                    }
                    ++j;
                }
                ++i2;
            }
            ClusterTree nt = new ClusterTree(min, (ClusterTree)list.get(mini), (ClusterTree)list.get(minj));
            list.remove(Math.max(mini, minj));
            list.remove(Math.min(mini, minj));
            list.add(nt);
        }
        return this.createTree((ClusterTree)list.get(0), objects);
    }

    public static <T> T[][] cutTree(ClusterTree<T> tree, double distance) {
        LinkedList<T[]> list = new LinkedList<T[]>();
        Hclust.fillCutTree(tree, distance, list);
        return (Object[][])ArrayHandler.cast(list.toArray((T[])new Object[0][]));
    }

    private static <T> void fillCutTree(ClusterTree<T> tree, double distance, LinkedList<T[]> list) {
        if (tree.getDistance() < distance) {
            list.add(tree.getClusterElements());
        } else {
            ClusterTree<T>[] subs = tree.getSubTrees();
            int i = 0;
            while (i < subs.length) {
                Hclust.fillCutTree(subs[i], distance, list);
                ++i;
            }
        }
    }

    public static <T> ClusterTree<T>[] cutTree(double distance, ClusterTree<T> tree) {
        LinkedList<ClusterTree<ClusterTree>> list = new LinkedList<ClusterTree<ClusterTree>>();
        Hclust.fillCutTree(tree, list, distance);
        return list.toArray(new ClusterTree[0]);
    }

    private static <T> void fillCutTree(ClusterTree<T> tree, LinkedList<ClusterTree<T>> list, double distance) {
        if (tree.getDistance() < distance) {
            list.add(tree);
        } else {
            ClusterTree<T>[] subs = tree.getSubTrees();
            int i = 0;
            while (i < subs.length) {
                Hclust.fillCutTree(subs[i], list, distance);
                ++i;
            }
        }
    }

    private ClusterTree<T> createTree(ClusterTree<Integer> intTree, T ... objects) {
        ClusterTree<Integer>[] intSubs = intTree.getSubTrees();
        if (intSubs == null) {
            return new ClusterTree<T>(objects[intTree.getClusterElements()[0]]);
        }
        ClusterTree[] subs = new ClusterTree[intSubs.length];
        int i = 0;
        while (i < subs.length) {
            subs[i] = this.createTree(intSubs[i], objects);
            ++i;
        }
        return new ClusterTree(intTree.getDistance(), subs);
    }

    private double getDistance(double[][] distMat, ClusterTree<Integer> tree, ClusterTree<Integer> tree2) {
        double dist = this.linkage == Linkage.SINGLE ? Double.POSITIVE_INFINITY : (this.linkage == Linkage.AVERAGE ? 0.0 : Double.NEGATIVE_INFINITY);
        Integer[] el1 = tree.getClusterElements();
        Integer[] el2 = tree2.getClusterElements();
        int i = 0;
        while (i < el1.length) {
            int j = 0;
            while (j < el2.length) {
                double d = distMat[Math.max(el1[i], el2[j])][Math.min(el1[i], el2[j])];
                if (this.linkage == Linkage.SINGLE) {
                    if (d < dist) {
                        dist = d;
                    }
                } else if (this.linkage == Linkage.AVERAGE) {
                    dist += d / (double)(el1.length * el2.length);
                } else if (this.linkage == Linkage.COMPLETE) {
                    if (d > dist) {
                        dist = d;
                    }
                } else {
                    throw new RuntimeException("Linkage not supported");
                }
                ++j;
            }
            ++i;
        }
        return dist;
    }

    public static enum Linkage {
        SINGLE,
        AVERAGE,
        COMPLETE;

    }
}

