/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery.history;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.history.History;
import java.util.Iterator;
import java.util.LinkedList;

public class MinMaxLengthNoRevertHistory
implements History {
    private int[] current;
    private LinkedList<int[]> list;
    private boolean allowShift;
    private int maxShrink;
    private int maxExpand;

    public MinMaxLengthNoRevertHistory() {
        this(true, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public MinMaxLengthNoRevertHistory(boolean allowShift, int maxShrink, int maxExpand) {
        this.allowShift = allowShift;
        this.maxShrink = maxShrink;
        this.maxExpand = maxExpand;
        this.list = new LinkedList();
        this.clear();
    }

    public MinMaxLengthNoRevertHistory(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.current = (int[])XMLParser.extractObjectForTags(xml, "current");
        int[][] help = (int[][])XMLParser.extractObjectForTags(xml, "list");
        this.list = new LinkedList();
        if (help != null) {
            int i = 0;
            while (i < help.length) {
                this.list.add(help[i]);
                ++i;
            }
        }
        this.maxShrink = (Integer)XMLParser.extractObjectForTags(xml, "maxShrink");
        this.maxExpand = (Integer)XMLParser.extractObjectForTags(xml, "maxExpand");
        this.allowShift = (Boolean)XMLParser.extractObjectForTags(xml, "allowShift");
    }

    private String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.current, "current");
        XMLParser.appendObjectWithTags(xml, this.list.toArray((T[])new int[0][]), "list");
        XMLParser.appendObjectWithTags(xml, this.maxShrink, "maxShrink");
        XMLParser.appendObjectWithTags(xml, this.maxExpand, "maxExpand");
        XMLParser.appendObjectWithTags(xml, this.allowShift, "allowShift");
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    @Override
    public MinMaxLengthNoRevertHistory clone() throws CloneNotSupportedException {
        MinMaxLengthNoRevertHistory clone = (MinMaxLengthNoRevertHistory)super.clone();
        clone.current = (int[])this.current.clone();
        clone.list = new LinkedList();
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            clone.list.add((int[])((int[])it.next()).clone());
        }
        return clone;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.current = new int[2];
        this.list.add((int[])this.current.clone());
    }

    @Override
    public boolean operationAllowed(int ... op) {
        if (op.length != 2) {
            return false;
        }
        int sum = op[1] - op[0];
        int[] temp = new int[]{this.current[0] + op[0], this.current[1] + op[1]};
        if (sum < 0 ? temp[0] - temp[1] > this.maxShrink : (sum == 0 ? !this.allowShift : temp[1] - temp[0] > this.maxExpand)) {
            return false;
        }
        for (int[] temp2 : this.list) {
            if (temp[0] != temp2[0] || temp[1] != temp2[1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void operationPerfomed(int ... op) {
        this.current[0] = this.current[0] + op[0];
        this.current[1] = this.current[1] + op[1];
        this.list.add((int[])this.current.clone());
    }
}

