/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.ConstraintManager;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhomogeneousDGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEManager;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.IDGTrainSMParameterSet;

public abstract class MEManagerParameterSet
extends IDGTrainSMParameterSet {
    private static final String[] algorithmStrings = new String[]{"BGIS (p-space)", "SGIS (p-space)", "GIS", "BGIS", "SGIS", "steepest descent", "conjugate gradients (F., R.)", "conjugate gradients (P., R. positive)", "quasi newton (D., F., P.)", "quasi newton (B., F., G., S.)", "limited memory quasi newton (B., F., G., S.; n=3)", "limited memory quasi newton (B., F., G., S.; n=4)", "limited memory quasi newton (B., F., G., S.; n=5)", "limited memory quasi newton (B., F., G., S.; n=6)", "limited memory quasi newton (B., F., G., S.; n=7)", "limited memory quasi newton (B., F., G., S.; n=8)", "limited memory quasi newton (B., F., G., S.; n=9)", "limited memory quasi newton (B., F., G., S.; n=10)"};
    private static final Byte[] algorithms = new Byte[]{new Byte(12), new Byte(11), new Byte(13), new Byte(15), new Byte(14), new Byte(16), new Byte(17), new Byte(18), new Byte(19), new Byte(20), new Byte(3), new Byte(4), new Byte(5), new Byte(6), new Byte(7), new Byte(8), new Byte(9), new Byte(10)};

    public MEManagerParameterSet(StringBuffer s) throws NonParsableException {
        super(s);
    }

    public MEManagerParameterSet(Class<? extends MEManager> instanceClass) throws Exception {
        super((Class<? extends InhomogeneousDGTrainSM>)instanceClass);
        this.addParameters();
    }

    public MEManagerParameterSet(Class<? extends MEManager> instanceClass, AlphabetContainer alphabet, int length, double ess, String description, ConstraintManager.Decomposition decomposition, boolean reduce, byte algorithm, double epsilon) throws Exception {
        super((Class<? extends InhomogeneousDGTrainSM>)instanceClass, alphabet, length, ess, description);
        this.addParameters();
        ((Parameter)this.parameters.get(2)).setValue((Object)decomposition);
        ((Parameter)this.parameters.get(3)).setValue(new Boolean(reduce));
        ((Parameter)this.parameters.get(4)).setValue(algorithmStrings[MEManagerParameterSet.getIndex(algorithmStrings, algorithms, new Byte(algorithm), false)]);
        ((Parameter)this.parameters.get(5)).setValue(new Double(epsilon));
    }

    protected void addParameters() throws Exception {
        this.parameters.add(new Parameter[]{new EnumParameter(ConstraintManager.Decomposition.class, "the kind the model should be decomposed", true)});
        ((Parameter)this.parameters.get(2)).setDefault((Object)ConstraintManager.Decomposition.DECOMPOSE_LESS_CONNECTED);
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "reduce", "whether the constraints should be reduced or not", true, new Boolean(true))});
        this.parameters.add(new Parameter[]{new SelectionParameter(DataType.BYTE, algorithmStrings, algorithms, "algorithm", "the algorithm that should be used for numerical optimization", true)});
        ((Parameter)this.parameters.get(4)).setDefault("BGIS (p-space)");
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "epsilon", "the bound for stopping the numercal optimization algorithm", true, new NumberValidator<Double>(new Double(0.0), new Double(Double.MAX_VALUE)), new Double(1.0E-6))});
    }
}

