/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.MRGParams;
import de.jstacs.utils.random.MultivariateRandomGenerator;
import de.jstacs.utils.random.RandomNumberGenerator;

public class DirichletMRG
extends MultivariateRandomGenerator {
    public static final DirichletMRG DEFAULT_INSTANCE = new DirichletMRG();
    private RandomNumberGenerator r = new RandomNumberGenerator();

    private DirichletMRG() {
    }

    @Override
    public void generate(double[] d, int start, int n, MRGParams p) {
        this.fill(d, start, n, p);
        Normalisation.logSumNormalisation(d, start, start + n);
    }

    private void fill(double[] d, int start, int n, MRGParams p) {
        DiMRGParams param = (DiMRGParams)p;
        int i = param.getDimension();
        if (i > 0 && i != n) {
            throw new IllegalArgumentException("Hyperparameter doesnot have a correct dimension.");
        }
        i = 0;
        while (i < n) {
            d[start + i] = this.r.nextGammaLog(param.getHyperparameter(i), 1.0);
            ++i;
        }
    }

    public void generateLog(double[] d, int start, int n, MRGParams p) {
        this.fill(d, start, n, p);
        double logSum = Normalisation.getLogSum(start, start + n, d);
        --n;
        while (n >= 0) {
            int n2 = start + n;
            d[n2] = d[n2] - logSum;
            --n;
        }
    }
}

