/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.glyph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.glyph.Glyph;

public class TurnGlyph
implements Glyph {
    private Paint forePaint;
    private Stroke stroke;
    private Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    private Shape turnShape;

    public TurnGlyph() {
        this.forePaint = Color.YELLOW.darker();
        this.stroke = new BasicStroke(4.0f);
    }

    public TurnGlyph(Rectangle2D.Float bounds) {
        this();
        this.setBounds(bounds);
    }

    public TurnGlyph(Paint paint, Stroke stroke) {
        this.forePaint = paint;
        this.stroke = stroke;
    }

    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle2D.Float r) {
        if (this.bounds.equals(r)) {
            return;
        }
        this.bounds = r;
        float q1 = r.height * 0.25f;
        float q2 = r.height * 0.5f;
        float q3 = r.height * 0.75f;
        GeneralPath p = new GeneralPath();
        p.moveTo(r.x, r.y + q3);
        p.lineTo(r.x, r.y + q1);
        p.lineTo(r.x, r.y + q2);
        p.lineTo(r.x + r.width, r.y + q2);
        p.lineTo(r.x + r.width, r.y + q1);
        p.lineTo(r.x + r.width, r.y + q3);
        this.turnShape = p;
    }

    public void render(Graphics2D g) {
        if (this.turnShape != null) {
            g.setStroke(this.stroke);
            g.setPaint(this.forePaint);
            g.draw(this.turnShape);
        }
    }
}

