/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

public class FetchURL {
    String baseURL;
    String db;
    String rettype;
    String retmode;

    public FetchURL(String databaseName, String format) {
        if (databaseName.trim().equalsIgnoreCase("genbank") || databaseName.trim().equalsIgnoreCase("nucleotide")) {
            this.db = "nucleotide";
        }
        if (databaseName.trim().equalsIgnoreCase("genpept") || databaseName.trim().equalsIgnoreCase("protein")) {
            this.db = "protein";
            this.rettype = format;
            this.retmode = format;
        }
        if (databaseName.trim().equalsIgnoreCase("swiss-prot")) {
            this.db = "swiss-prot";
        }
        if (databaseName.trim().equalsIgnoreCase("pubmed")) {
            this.db = "pubmed";
            this.rettype = "abstract";
            this.retmode = format;
        }
        if (databaseName.trim().equalsIgnoreCase("locuslink")) {
            this.db = "locuslink";
        }
    }

    public String getbaseURL() {
        if (this.db.equalsIgnoreCase("Genbank") || this.db.equalsIgnoreCase("nucleotide") || this.db.equalsIgnoreCase("Genpept") || this.db.equalsIgnoreCase("protein") || this.db.equalsIgnoreCase("pubmed")) {
            this.baseURL = "http://www.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?";
        } else if (this.db.equalsIgnoreCase("Swiss-prot")) {
            this.baseURL = "http://us.expasy.org/cgi-bin/get-sprot-raw.pl?";
        } else if (this.db.equalsIgnoreCase("LocusLink")) {
            this.baseURL = "http://www.ncbi.nlm.nih.gov/LocusLink/LocRpt.cgi?";
        }
        return this.baseURL;
    }

    public String getDB() {
        return "db=" + this.db;
    }

    public String getReturnFormat() {
        return "rettype=" + this.rettype + "&retmode=" + this.retmode;
    }
}

