/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.ontology.OntoTools;
import org.biojava.ontology.Term;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleFeature
extends AbstractChangeable
implements Feature,
RealizingFeatureHolder,
Serializable {
    private transient ChangeListener annotationForwarder;
    private transient ChangeListener featureForwarder;
    private SimpleFeatureHolder featureHolder;
    private Location loc;
    private String type;
    private String source;
    private FeatureHolder parent;
    private Annotation annotation;
    private Term typeTerm;
    private Term sourceTerm;

    protected SimpleFeatureHolder getFeatureHolder() {
        if (this.featureHolder == null) {
            this.featureHolder = new SimpleFeatureHolder();
        }
        return this.featureHolder;
    }

    protected boolean featureHolderAllocated() {
        return this.featureHolder != null;
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        ChangeSupport cs = super.getChangeSupport(ct);
        if (this.annotationForwarder == null && (ct.isMatchingType(Annotatable.ANNOTATION) || Annotatable.ANNOTATION.isMatchingType(ct))) {
            this.annotationForwarder = new ChangeForwarder.Retyper(this, cs, Annotation.PROPERTY);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        if (this.featureForwarder == null && (ct == null || ct == FeatureHolder.FEATURES)) {
            this.featureForwarder = new ChangeForwarder(this, cs);
            this.getFeatureHolder().addChangeListener(this.featureForwarder, FeatureHolder.FEATURES);
        }
        return cs;
    }

    public Location getLocation() {
        return this.loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(Location loc) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(LOCATION);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, LOCATION, loc, this.loc);
                cs.firePreChangeEvent(ce);
                this.loc = loc;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.loc = loc;
        }
    }

    public Term getTypeTerm() {
        return this.typeTerm;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.typeTerm != null) {
            return this.typeTerm.getName();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(String type) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(TYPE);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, TYPE, type, this.type);
                cs.firePreChangeEvent(ce);
                this.type = type;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeTerm(Term t) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(TYPE);
            synchronized (changeSupport) {
                ChangeEvent ce_term = new ChangeEvent(this, TYPETERM, t, this.getTypeTerm());
                ChangeEvent ce_name = new ChangeEvent(this, TYPE, t.getName(), this.getType());
                cs.firePreChangeEvent(ce_term);
                cs.firePreChangeEvent(ce_name);
                this.typeTerm = t;
                cs.firePostChangeEvent(ce_term);
                cs.firePostChangeEvent(ce_name);
            }
        } else {
            this.typeTerm = t;
        }
    }

    public String getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceTerm != null) {
            return this.sourceTerm.getName();
        }
        return "";
    }

    public Term getSourceTerm() {
        return this.sourceTerm;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(String source) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SOURCE);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SOURCE, this.source, source);
                cs.firePreChangeEvent(ce);
                this.source = source;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.source = source;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceTerm(Term t) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(TYPE);
            synchronized (changeSupport) {
                ChangeEvent ce_term = new ChangeEvent(this, SOURCETERM, t, this.getSourceTerm());
                ChangeEvent ce_name = new ChangeEvent(this, SOURCE, t.getName(), this.getSource());
                cs.firePreChangeEvent(ce_term);
                cs.firePreChangeEvent(ce_name);
                this.sourceTerm = t;
                cs.firePostChangeEvent(ce_term);
                cs.firePostChangeEvent(ce_name);
            }
        } else {
            this.sourceTerm = t;
        }
    }

    public Sequence getSequence() {
        FeatureHolder fh = this;
        while (fh instanceof Feature) {
            fh = ((Feature)fh).getParent();
        }
        try {
            return (Sequence)fh;
        }
        catch (ClassCastException ex) {
            throw new BioError("Feature doesn't seem to have a Sequence ancestor: " + fh);
        }
    }

    public Annotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = new SimpleAnnotation();
        }
        return this.annotation;
    }

    public SymbolList getSymbols() {
        return this.getLocation().symbols(this.getSequence());
    }

    public int countFeatures() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().countFeatures();
        }
        return 0;
    }

    public Iterator features() {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().features();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        this.getFeatureHolder().removeFeature(f);
    }

    public boolean containsFeature(Feature f) {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().containsFeature(f);
        }
        return false;
    }

    public FeatureHolder filter(FeatureFilter ff) {
        FeatureFilter.Not childFilter = new FeatureFilter.Not(FeatureFilter.top_level);
        if (FilterUtils.areDisjoint(ff, childFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().filter(ff);
        }
        return FeatureHolder.EMPTY_FEATURE_HOLDER;
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (this.featureHolderAllocated()) {
            return this.getFeatureHolder().filter(ff, recurse);
        }
        return FeatureHolder.EMPTY_FEATURE_HOLDER;
    }

    public Feature.Template makeTemplate() {
        Feature.Template ft = new Feature.Template();
        this.fillTemplate(ft);
        return ft;
    }

    protected void fillTemplate(Feature.Template ft) {
        ft.location = this.getLocation();
        ft.type = this.getType();
        ft.source = this.getSource();
        ft.annotation = this.getAnnotation();
        ft.sourceTerm = this.getSourceTerm();
        ft.typeTerm = this.getTypeTerm();
    }

    public SimpleFeature(Sequence sourceSeq, FeatureHolder parent, Feature.Template template) {
        if (template.location == null) {
            throw new IllegalArgumentException("Location can not be null. Did you mean Location.EMPTY_LOCATION? " + template.toString());
        }
        if (!(parent instanceof Feature) && !(parent instanceof Sequence)) {
            throw new IllegalArgumentException("Parent must be sequence or feature, not: " + parent.getClass() + " " + parent);
        }
        if (template.location.getMin() < 1 || template.location.getMax() > sourceSeq.length()) {
            // empty if block
        }
        this.parent = parent;
        this.loc = template.location;
        this.typeTerm = template.typeTerm != null ? template.typeTerm : OntoTools.ANY;
        this.sourceTerm = template.sourceTerm != null ? template.sourceTerm : OntoTools.ANY;
        this.type = template.type != null ? template.type : this.typeTerm.getName();
        String string = this.source = template.source != null ? template.source : this.sourceTerm.getName();
        if (this.type == null) {
            throw new NullPointerException("Either type or typeTerm must have a non-null value");
        }
        if (this.source == null) {
            throw new NullPointerException("Either source or sourceTerm must have a non-null value");
        }
        this.annotation = template.annotation != null ? new SimpleAnnotation(template.annotation) : null;
    }

    public String toString() {
        return "Feature " + this.getType() + " " + this.getSource() + " " + this.getLocation();
    }

    public Feature realizeFeature(FeatureHolder fh, Feature.Template templ) throws BioException {
        try {
            RealizingFeatureHolder rfh = (RealizingFeatureHolder)this.getParent();
            return rfh.realizeFeature(fh, templ);
        }
        catch (ClassCastException ex) {
            throw new BioException("Couldn't propagate feature creation request.");
        }
    }

    public Feature createFeature(Feature.Template temp) throws BioException, ChangeVetoException {
        Feature f = this.realizeFeature(this, temp);
        this.getFeatureHolder().addFeature(f);
        return f;
    }

    public int hashCode() {
        return this.makeTemplate().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature fo = (Feature)o;
        if (!fo.getSequence().equals(this.getSequence())) {
            return false;
        }
        return this.makeTemplate().equals(fo.makeTemplate());
    }

    public FeatureFilter getSchema() {
        return new FeatureFilter.ByParent(new FeatureFilter.ByFeature(this));
    }
}

