/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusFile;
import org.biojavax.bio.phylo.io.nexus.NexusFileListener;
import org.biojavax.bio.phylo.io.nexus.NexusObject;

public class NexusFileFormat {
    public static final String NEW_LINE = System.getProperty("line.separator");

    private NexusFileFormat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFile(NexusFileListener listener, File inputFile) throws IOException, ParseException {
        FileReader fr = new FileReader(inputFile);
        try {
            NexusFileFormat.parseReader(listener, fr);
        }
        finally {
            fr.close();
        }
    }

    public static void parseInputStream(NexusFileListener listener, InputStream inputStream) throws IOException, ParseException {
        NexusFileFormat.parseReader(listener, new InputStreamReader(inputStream));
    }

    public static void parseReader(NexusFileListener listener, Reader inputReader) throws IOException, ParseException {
        NexusFileFormat.parse(listener, inputReader instanceof BufferedReader ? (BufferedReader)inputReader : new BufferedReader(inputReader));
    }

    private static void parse(NexusFileListener listener, BufferedReader reader) throws IOException, ParseException {
        String line;
        String space = " ";
        String tab = "\t";
        String beginComment = "[";
        String endComment = "]";
        String singleQuote = "'";
        String underscore = "_";
        String endTokenGroup = ";";
        String openBracket = "(";
        String closeBracket = ")";
        String openBrace = "{";
        String closeBrace = "}";
        String newLine = "\n";
        String allDelims = space + tab + beginComment + endComment + singleQuote + underscore + endTokenGroup + newLine + openBracket + closeBracket + openBrace + closeBrace;
        int inComment = 0;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean singleQuoteOpened = false;
        TokenParser parser = new TokenParser(listener);
        Stack<StringBuffer> parsedTokBufferStack = new Stack<StringBuffer>();
        StringBuffer parsedTokBuffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line.replaceAll("\\r\\n|\\r", "\n") + "\n", allDelims, true);
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                if (allDelims.indexOf(tok) >= 0) {
                    String parsedTok;
                    if (singleQuoteOpened && singleQuote.equals(tok)) {
                        inSingleQuotes = !inSingleQuotes;
                        parsedTokBuffer.append(singleQuote);
                    } else if (inComment > 0) {
                        if (singleQuote.equals(tok)) {
                            inSingleQuotes = !inSingleQuotes;
                        } else if (beginComment.equals(tok) && !inSingleQuotes && !inDoubleQuotes) {
                            if (parsedTokBuffer.length() > 0) {
                                listener.commentText(parsedTokBuffer.toString());
                                parsedTokBuffer.setLength(0);
                            }
                            ++inComment;
                            listener.beginComment();
                            parsedTokBufferStack.push(parsedTokBuffer);
                            parsedTokBuffer = new StringBuffer();
                        } else if (endComment.equals(tok) && !inSingleQuotes && !inDoubleQuotes) {
                            --inComment;
                            if (parsedTokBuffer.length() > 0) {
                                listener.commentText(parsedTokBuffer.toString());
                            }
                            listener.endComment();
                            parsedTokBuffer = (StringBuffer)parsedTokBufferStack.pop();
                        } else {
                            parsedTokBuffer.append(tok);
                        }
                    } else if (inSingleQuotes) {
                        if (singleQuote.equals(tok)) {
                            inSingleQuotes = false;
                        } else {
                            parsedTokBuffer.append(tok);
                        }
                    } else if (beginComment.equals(tok)) {
                        ++inComment;
                        listener.beginComment();
                        parsedTokBufferStack.push(parsedTokBuffer);
                        parsedTokBuffer = new StringBuffer();
                    } else if (singleQuote.equals(tok)) {
                        inSingleQuotes = true;
                    } else if (underscore.equals(tok)) {
                        parsedTokBuffer.append(space);
                    } else if (openBracket.equals(tok) || closeBracket.equals(tok) || openBrace.equals(tok) || closeBrace.equals(tok)) {
                        if (listener.wantsBracketsAndBraces()) {
                            parsedTok = parsedTokBuffer.toString();
                            parsedTokBuffer.setLength(0);
                            parser.parseToken(parsedTok);
                            listener.parseToken(tok);
                        } else {
                            parsedTokBuffer.append(tok);
                        }
                    } else if (space.equals(tok) || tab.equals(tok) || endTokenGroup.equals(tok) || newLine.equals(tok)) {
                        if (parsedTokBuffer.length() > 0) {
                            parsedTok = parsedTokBuffer.toString();
                            parsedTokBuffer.setLength(0);
                            parser.parseToken(parsedTok);
                        }
                        if (endTokenGroup.equals(tok)) {
                            listener.endTokenGroup();
                        } else {
                            listener.parseToken(tok);
                        }
                    }
                } else {
                    parsedTokBuffer.append(tok);
                }
                singleQuoteOpened = !singleQuoteOpened && singleQuote.equals(tok);
            }
        }
        listener.endFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, NexusFile nexusFile) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            NexusFileFormat.writeWriter(fw, nexusFile);
        }
        finally {
            fw.close();
        }
    }

    public static void writeStream(OutputStream os, NexusFile nexusFile) throws IOException {
        OutputStreamWriter ow = new OutputStreamWriter(os);
        NexusFileFormat.writeWriter(ow, nexusFile);
    }

    public static void writeWriter(Writer writer, NexusFile nexusFile) throws IOException {
        writer.write("#NEXUS");
        writer.write(NEW_LINE);
        Iterator i = nexusFile.objectIterator();
        while (i.hasNext()) {
            ((NexusObject)i.next()).writeObject(writer);
            writer.write(NEW_LINE);
        }
        writer.flush();
    }

    private static class TokenParser {
        private boolean expectingHeader = true;
        private boolean expectingBeginTag = false;
        private boolean expectingBeginName = false;
        private boolean expectingBlockContents = false;
        private NexusFileListener listener;

        private TokenParser(NexusFileListener listener) {
            this.listener = listener;
        }

        private void parseToken(String parsedTok) throws ParseException {
            if (this.expectingHeader && "#NEXUS".equalsIgnoreCase(parsedTok)) {
                this.expectingHeader = false;
                this.expectingBeginTag = true;
                this.listener.startFile();
            } else if (this.expectingBeginTag && "BEGIN".equalsIgnoreCase(parsedTok)) {
                this.expectingBeginTag = false;
                this.expectingBeginName = true;
            } else if (this.expectingBeginName) {
                this.listener.startBlock(parsedTok);
                this.expectingBeginName = false;
                this.expectingBlockContents = true;
            } else if (this.expectingBlockContents) {
                if ("END".equalsIgnoreCase(parsedTok)) {
                    this.listener.endBlock();
                    this.expectingBlockContents = false;
                    this.expectingBeginTag = true;
                } else {
                    this.listener.parseToken(parsedTok);
                }
            } else {
                throw new ParseException("Parser in unknown state when parsing token \"" + parsedTok + "\"");
            }
        }
    }
}

