/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.DiscreteDistribution;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class GofStat {
    private static double EPSILOND = 1.0E-15;
    public static double EPSILONAD = 1.110223E-16f;

    private GofStat() {
    }

    public static DoubleArrayList unifTransform(DoubleArrayList doubleArrayList, ContinuousDistribution continuousDistribution) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = continuousDistribution.cdf(dArray[i]);
        }
        return new DoubleArrayList(dArray2);
    }

    public static DoubleArrayList unifTransform(DoubleArrayList doubleArrayList, DiscreteDistribution discreteDistribution) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = discreteDistribution.cdf((int)dArray[i]);
        }
        return new DoubleArrayList(dArray2);
    }

    public static void diff(IntArrayList intArrayList, IntArrayList intArrayList2, int n, int n2, int n3, int n4) {
        if (n < 0 || n2 < 0 || n >= n2 || n2 >= intArrayList.size()) {
            throw new IllegalArgumentException("n1 and n2 not valid.");
        }
        int[] nArray = intArrayList.elements();
        int n5 = intArrayList.size();
        if (intArrayList2.size() <= n2 + 2) {
            intArrayList2.setSize(n2 + 2);
        }
        int[] nArray2 = intArrayList2.elements();
        nArray2[n] = nArray[n] - n3;
        for (int i = n + 1; i <= n2; ++i) {
            nArray2[i] = nArray[i] - nArray[i - 1];
        }
        nArray2[n2 + 1] = n4 - nArray[n2];
    }

    public static void diff(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2, int n, int n2, double d, double d2) {
        if (n < 0 || n2 < 0 || n >= n2 || n2 >= doubleArrayList.size()) {
            throw new IllegalArgumentException("n1 and n2 not valid.");
        }
        double[] dArray = doubleArrayList.elements();
        int n3 = doubleArrayList.size();
        if (doubleArrayList2.size() <= n2 + 2) {
            doubleArrayList2.setSize(n2 + 2);
        }
        double[] dArray2 = doubleArrayList2.elements();
        dArray2[n] = dArray[n] - d;
        for (int i = n + 1; i <= n2; ++i) {
            dArray2[i] = dArray[i] - dArray[i - 1];
        }
        dArray2[n2 + 1] = d2 - dArray[n2];
    }

    public static void iterateSpacings(DoubleArrayList doubleArrayList, DoubleArrayList doubleArrayList2) {
        int n;
        if (doubleArrayList2.size() < doubleArrayList.size() + 1) {
            throw new IllegalArgumentException("Invalid array sizes.");
        }
        double[] dArray = doubleArrayList.elements();
        doubleArrayList2.quickSortFromTo(0, doubleArrayList.size());
        double[] dArray2 = doubleArrayList2.elements();
        int n2 = doubleArrayList.size();
        for (n = 0; n < n2; ++n) {
            dArray2[n2 - n] = (double)(n + 1) * (dArray2[n2 - n] - dArray2[n2 - n - 1]);
        }
        dArray2[0] = (double)(n2 + 1) * dArray2[0];
        dArray[0] = dArray2[0];
        for (n = 1; n < n2; ++n) {
            dArray[n] = dArray[n - 1] + dArray2[n];
        }
    }

    public static void powerRatios(DoubleArrayList doubleArrayList) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        for (int i = 0; i < n - 1; ++i) {
            dArray[i] = dArray[i + 1] == 0.0 || dArray[i + 1] == -0.0 ? 1.0 : Math.pow(dArray[i] / dArray[i + 1], (double)i + 1.0);
        }
        dArray[n - 1] = Math.pow(dArray[n - 1], n);
        doubleArrayList.quickSortFromTo(0, doubleArrayList.size() - 1);
    }

    public static double chi2(double[] dArray, int[] nArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i <= n2; ++i) {
            if (dArray[i] <= 0.0) {
                if (nArray[i] == 0) continue;
                throw new IllegalArgumentException("nbExp[s] = 0 and count[s] > 0");
            }
            double d2 = (double)nArray[i] - dArray[i];
            d += d2 * d2 / dArray[i];
        }
        return d;
    }

    public static double chi2(IntArrayList intArrayList, DiscreteDistributionInt discreteDistributionInt, int n, int n2, double d, int[] nArray) {
        Object object;
        int n3 = intArrayList.size();
        int n4 = n;
        while (discreteDistributionInt.prob(n4) * (double)n3 <= DiscreteDistributionInt.EPSILON) {
            ++n4;
        }
        n = n4--;
        while (n2 <= n) {
            n2 = 2 * n2 + 1;
        }
        double[] dArray = new double[n2 + 1];
        do {
            if (++n4 > n2) {
                object = new double[(n2 *= 2) + 1];
                System.arraycopy(dArray, n, object, n, dArray.length - n);
                dArray = object;
            }
            dArray[n4] = discreteDistributionInt.prob(n4) * (double)n3;
        } while (dArray[n4] > DiscreteDistributionInt.EPSILON);
        n2 = n4 - 1;
        object = new OutcomeCategoriesChi2(dArray, n, n2);
        ((OutcomeCategoriesChi2)object).regroupCategories(d);
        if (nArray != null) {
            nArray[0] = ((OutcomeCategoriesChi2)object).nbCategories;
        }
        int[] nArray2 = new int[((OutcomeCategoriesChi2)object).smax + 1];
        for (n4 = 0; n4 < nArray2.length; ++n4) {
            nArray2[n4] = 0;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            int n5 = intArrayList.get(n4);
            while (((OutcomeCategoriesChi2)object).loc[n5] != n5) {
                n5 = ((OutcomeCategoriesChi2)object).loc[n5];
            }
            int n6 = n5;
            nArray2[n6] = nArray2[n6] + 1;
        }
        return GofStat.chi2(((OutcomeCategoriesChi2)object).nbExp, nArray2, ((OutcomeCategoriesChi2)object).smin, ((OutcomeCategoriesChi2)object).smax);
    }

    public static double chi2Equal(double d, int[] nArray, int n, int n2) {
        double d2 = 0.0;
        for (int i = n; i <= n2; ++i) {
            double d3 = (double)nArray[i] - d;
            d2 += d3 * d3;
        }
        return d2 / d;
    }

    public static double chi2Equal(DoubleArrayList doubleArrayList, double d) {
        int n = doubleArrayList.size();
        if (n < (int)Math.ceil(d)) {
            throw new IllegalArgumentException("Not enough observations");
        }
        double d2 = d / (double)n;
        int n2 = (int)Math.ceil(1.0 / d2);
        int[] nArray = new int[n2 + 1];
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = n3 = (int)Math.floor(doubleArrayList.get(i) / d2);
            nArray[n4] = nArray[n4] + 1;
        }
        int n5 = n2 - 1;
        nArray[n5] = nArray[n5] + nArray[n2];
        return GofStat.chi2Equal(d, nArray, 0, n2 - 1);
    }

    public static double chi2Equal(DoubleArrayList doubleArrayList) {
        return GofStat.chi2Equal(doubleArrayList, 10.0);
    }

    public static int scan(DoubleArrayList doubleArrayList, double d) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        int n2 = 1;
        int n3 = 0;
        int n4 = -1;
        double d2 = 0.0;
        while (n3 < n - 1 && d2 < 1.0) {
            d2 = dArray[++n4] + d;
            while (n3 < n && dArray[n3] < d2) {
                ++n3;
            }
            if (n3 - n4 <= n2) continue;
            n2 = n3 - n4;
        }
        return n2;
    }

    public static double cramerVonMises(DoubleArrayList doubleArrayList) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        if (n <= 0) {
            System.err.println("cramerVonMises:  n <= 0");
            return 0.0;
        }
        double d = 1.0 / (double)(12 * n);
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i] - ((double)i + 0.5) / (double)n;
            d += d2 * d2;
        }
        return d;
    }

    public static double watsonG(DoubleArrayList doubleArrayList) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        double d = 1.0 / (double)n;
        if (n <= 0) {
            System.err.println("watsonG: n <= 0");
            return 0.0;
        }
        if (n == 1) {
            return 0.0;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d4 = (double)(i + 1) * d - dArray[i];
            if (d4 > d3) {
                d3 = d4;
            }
            d2 += dArray[i];
        }
        d2 = d2 * d - 0.5;
        double d5 = Math.sqrt(n) * (d3 + d2);
        return d5;
    }

    public static double watsonU(DoubleArrayList doubleArrayList) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        if (n <= 0) {
            System.err.println("watsonU: n <= 0");
            return 0.0;
        }
        if (n == 1) {
            return 0.08333333333333333;
        }
        double d = 0.0;
        double d2 = 1.0 / (double)(12 * n);
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
            double d3 = dArray[i] - ((double)i + 0.5) / (double)n;
            d2 += d3 * d3;
        }
        d = d / (double)n - 0.5;
        double d4 = d2 - d * d * (double)n;
        return d4;
    }

    public static double andersonDarling(DoubleArrayList doubleArrayList) {
        double[] dArray = doubleArrayList.elements();
        int n = doubleArrayList.size();
        if (n <= 0) {
            System.err.println("andersonDarling: n <= 0");
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i];
            double d3 = 1.0 - d2;
            if (d2 < EPSILONAD) {
                d2 = EPSILONAD;
            } else if (d3 < EPSILONAD) {
                d3 = EPSILONAD;
            }
            d += (double)(2 * i + 1) * Math.log(d2) + (double)(1 + 2 * (n - i - 1)) * Math.log(d3);
        }
        d = (double)(-n) - d / (double)n;
        return d;
    }

    public static double[] kolmogorovSmirnov(DoubleArrayList doubleArrayList) {
        double[] dArray = new double[3];
        double[] dArray2 = doubleArrayList.elements();
        int n = doubleArrayList.size();
        if (n <= 0) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            System.err.println("kolmogorovSmirnov:   n <= 0");
            return dArray;
        }
        double[] dArray3 = GofStat.kolmogorovSmirnovJumpOne(doubleArrayList, 0.0);
        dArray[0] = dArray3[0];
        dArray[1] = dArray3[1];
        dArray[2] = dArray[1] > dArray[0] ? dArray[1] : dArray[0];
        return dArray;
    }

    public static double[] kolmogorovSmirnovJumpOne(DoubleArrayList doubleArrayList, double d) {
        int n;
        double[] dArray = doubleArrayList.elements();
        int n2 = doubleArrayList.size();
        double[] dArray2 = new double[2];
        if (n2 <= 0) {
            dArray2[1] = 0.0;
            dArray2[0] = 0.0;
            System.err.println("kolmogorovSmirnovJumpOne: n <= 0");
            return dArray2;
        }
        dArray2[0] = 0.0;
        dArray2[1] = 0.0;
        double d2 = 1.0 / (double)n2;
        for (n = 0; n < n2 && dArray[n] <= d + EPSILOND; ++n) {
        }
        for (int i = n - 1; i < n2; ++i) {
            double d3;
            double d4;
            if (i >= 0 && (d4 = (double)(i + 1) * d2 - dArray[i]) > dArray2[0]) {
                dArray2[0] = d4;
            }
            if (i < n || !((d3 = dArray[i] - (double)i * d2) > dArray2[1])) continue;
            dArray2[1] = d3;
        }
        return dArray2;
    }

    public static double pDisc(double d, double d2) {
        double d3 = d2 < d ? d2 : (d > 0.5 ? 0.5 : 1.0 - d);
        return d3;
    }

    public static class OutcomeCategoriesChi2 {
        public int nbCategories;
        public int smin;
        public int smax;
        public double[] nbExp;
        public int[] loc;

        public OutcomeCategoriesChi2(double[] dArray) {
            this.nbExp = dArray;
            this.smin = 0;
            this.smax = dArray.length - 1;
            this.nbCategories = dArray.length;
            this.loc = new int[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                this.loc[i] = i;
            }
        }

        public OutcomeCategoriesChi2(double[] dArray, int n, int n2) {
            int n3;
            this.nbExp = dArray;
            this.smin = n;
            this.smax = n2;
            this.nbCategories = n2 - n + 1;
            this.loc = new int[dArray.length];
            for (n3 = 0; n3 < n; ++n3) {
                this.loc[n3] = n;
            }
            for (n3 = n; n3 < n2; ++n3) {
                this.loc[n3] = n3;
            }
            for (n3 = n2; n3 < dArray.length; ++n3) {
                this.loc[n3] = n2;
            }
        }

        public OutcomeCategoriesChi2(double[] dArray, int[] nArray, int n, int n2, int n3) {
            this.nbExp = dArray;
            this.smin = n;
            this.smax = n2;
            this.nbCategories = this.nbCategories;
            this.loc = nArray;
        }

        public void regroupCategories(double d) {
            int n;
            int n2 = 0;
            this.nbCategories = 0;
            for (int i = this.smin; i <= this.smax; ++i) {
                if (this.nbExp[i] < d) {
                    double d2;
                    n2 = i;
                    for (d2 = this.nbExp[i]; d2 < d && i < this.smax; d2 += this.nbExp[++i]) {
                        this.nbExp[i] = 0.0;
                    }
                    this.nbExp[i] = d2;
                    for (n = n2; n <= i; ++n) {
                        this.loc[n] = i;
                    }
                } else {
                    this.loc[i] = i;
                }
                ++this.nbCategories;
            }
            this.smin = this.loc[this.smin];
            if (this.nbExp[this.smax] < d) {
                if (n2 > this.smin) {
                    // empty if block
                }
                int n3 = --n2;
                this.nbExp[n3] = this.nbExp[n3] + this.nbExp[this.smax];
                this.nbExp[this.smax] = 0.0;
                --this.nbCategories;
                for (n = n2 + 1; n <= this.smax; ++n) {
                    this.loc[n] = n2;
                }
                this.smax = n2;
            }
            if (this.nbCategories <= 1) {
                throw new IllegalStateException("nbCategories < 2");
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("-----------------------------------------------" + PrintfFormat.LINE_SEPARATOR);
            if (this.nbExp[this.smin] < 5.0E-16) {
                stringBuffer.append("Only expected numbers larger than " + PrintfFormat.g(6, 1, 5.0E-16) + "  are printed" + PrintfFormat.LINE_SEPARATOR);
            }
            stringBuffer.append("Number of categories: " + PrintfFormat.d(4, this.nbCategories) + PrintfFormat.LINE_SEPARATOR + "Expected numbers per category:" + PrintfFormat.LINE_SEPARATOR + PrintfFormat.LINE_SEPARATOR + "Category s      nbExp[s]" + PrintfFormat.LINE_SEPARATOR);
            int n = this.smin;
            while (this.nbExp[n] < 5.0E-16) {
                ++n;
            }
            int n2 = n;
            n = this.smax;
            while (this.nbExp[n] < 5.0E-16) {
                --n;
            }
            int n3 = n;
            double d = 0.0;
            for (n = n2; n <= n3; ++n) {
                if (this.loc[n] != n) continue;
                d += this.nbExp[n];
                stringBuffer.append(PrintfFormat.d(4, n) + " " + PrintfFormat.f(18, 4, this.nbExp[n]) + PrintfFormat.LINE_SEPARATOR);
            }
            stringBuffer.append(PrintfFormat.LINE_SEPARATOR + "Total expected number = " + PrintfFormat.f(18, 2, d) + PrintfFormat.LINE_SEPARATOR + PrintfFormat.LINE_SEPARATOR + "The groupings:" + PrintfFormat.LINE_SEPARATOR + " Category s      loc[s]" + PrintfFormat.LINE_SEPARATOR);
            for (n = this.smin; n <= this.smax; ++n) {
                if (n == this.smin && n > 0) {
                    stringBuffer.append("<= ");
                } else if (n == this.smax && n < this.loc.length - 1) {
                    stringBuffer.append(">= ");
                } else {
                    stringBuffer.append("   ");
                }
                stringBuffer.append(PrintfFormat.d(4, n) + " " + PrintfFormat.d(12, this.loc[n]) + PrintfFormat.LINE_SEPARATOR);
            }
            stringBuffer.append(PrintfFormat.LINE_SEPARATOR + PrintfFormat.LINE_SEPARATOR);
            return stringBuffer.toString();
        }
    }
}

