/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simevents.eventlist;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplayTree
implements EventList {
    private Entry root = null;
    private static Entry free = null;
    private int modCount = 0;

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public void clear() {
        while (this.root != null) {
            this.remove(this.root);
        }
    }

    @Override
    public void add(Event ev) {
        Entry e;
        double evtime = ev.time();
        Entry next = this.root;
        this.root = e = this.add(ev, null);
        if (next != null) {
            Entry left = this.root;
            Entry right = this.root;
            Entry temp = null;
            boolean end_splay = false;
            while (!end_splay) {
                if (next.event.time() <= evtime) {
                    temp = next.right;
                    if (temp == null) {
                        left.right = next;
                        next.father = left;
                        right.left = null;
                        end_splay = true;
                        continue;
                    }
                    if (temp.event.time() > evtime) {
                        left.right = next;
                        next.father = left;
                        left = next;
                        next = temp;
                        continue;
                    }
                    next.right = temp.left;
                    if (temp.left != null) {
                        temp.left.father = next;
                    }
                    left.right = temp;
                    temp.father = left;
                    temp.left = next;
                    next.father = temp;
                    left = temp;
                    next = temp.right;
                    if (next != null) continue;
                    right.left = null;
                    end_splay = true;
                    continue;
                }
                temp = next.left;
                if (temp == null) {
                    right.left = next;
                    next.father = right;
                    left.right = null;
                    end_splay = true;
                    continue;
                }
                if (temp.event.time() <= evtime) {
                    right.left = next;
                    next.father = right;
                    right = next;
                    next = temp;
                    continue;
                }
                next.left = temp.right;
                if (temp.right != null) {
                    temp.right.father = next;
                }
                right.left = temp;
                temp.father = right;
                temp.right = next;
                next.father = temp;
                right = temp;
                next = temp.left;
                if (next != null) continue;
                left.right = null;
                end_splay = true;
            }
            temp = e.left;
            e.left = e.right;
            e.right = temp;
        }
        ++this.modCount;
    }

    @Override
    public void addFirst(Event ev) {
        if (this.root == null) {
            this.root = this.add(ev, null);
        } else {
            Entry cursor = this.root;
            while (cursor.left != null) {
                cursor = cursor.left;
            }
            cursor.left = this.add(ev, cursor);
        }
        ++this.modCount;
    }

    @Override
    public void addBefore(Event ev, Event other) {
        Entry otherEntry = this.findEntry(other);
        if (otherEntry == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        Entry e = this.add(ev, null);
        if (otherEntry != this.root) {
            if (otherEntry == otherEntry.father.left) {
                otherEntry.father.left = e;
            } else {
                otherEntry.father.right = e;
            }
        } else {
            this.root = e;
        }
        e.father = otherEntry.father;
        otherEntry.father = e;
        e.right = otherEntry;
        e.left = otherEntry.left;
        if (e.left != null) {
            e.left.father = e;
        }
        otherEntry.left = null;
        ++this.modCount;
    }

    @Override
    public void addAfter(Event ev, Event other) {
        Entry otherEntry = this.findEntry(other);
        if (otherEntry == null) {
            throw new IllegalArgumentException("Event not in list.");
        }
        Entry e = this.add(ev, otherEntry);
        e.right = otherEntry.right;
        otherEntry.right = e;
        if (e.right != null) {
            e.right.father = e;
        }
        ++this.modCount;
    }

    @Override
    public Event getFirst() {
        if (this.root == null) {
            return null;
        }
        Entry cursor = this.root;
        while (cursor.left != null) {
            cursor = cursor.left;
        }
        return cursor.event;
    }

    @Override
    public Event getFirstOfClass(String cl) {
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            if (cursor.event.getClass().getName().equals(cl)) {
                return cursor.event;
            }
            cursor = this.successor(cursor);
        }
        return null;
    }

    @Override
    public <E extends Event> E getFirstOfClass(Class<E> cl) {
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            if (cursor.event.getClass() == cl) {
                return (E)cursor.event;
            }
            cursor = this.successor(cursor);
        }
        return null;
    }

    @Override
    public Iterator<Event> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Event> listIterator() {
        return new SPItr();
    }

    @Override
    public boolean remove(Event ev) {
        if (this.root == null) {
            return false;
        }
        Entry e = this.findEntry(ev);
        if (e == null) {
            return false;
        }
        return this.remove(e);
    }

    @Override
    public Event removeFirst() {
        if (this.root == null) {
            return null;
        }
        Entry cursor = this.root;
        while (cursor.left != null) {
            cursor = cursor.left;
        }
        Event first = cursor.event;
        this.remove(cursor);
        return first;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Contents of the event list SplayTree :");
        Entry cursor = this.root;
        if (this.root != null) {
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        }
        while (cursor != null) {
            sb.append(PrintfFormat.LINE_SEPARATOR + PrintfFormat.g(8, 4, cursor.event.time()) + " : " + cursor.event.toString());
            cursor = this.successor(cursor);
        }
        return sb.toString();
    }

    private Entry add(Event ev, Entry father) {
        if (free == null) {
            return new Entry(ev, null, null, father);
        }
        Entry e = free;
        free = SplayTree.free.right;
        e.event = ev;
        e.right = null;
        e.left = null;
        e.father = father;
        return e;
    }

    private void splay(Entry e) {
        while (e.father != null) {
            Entry ggf;
            boolean left;
            Entry f = e.father;
            Entry gf = f.father;
            boolean bl = left = e == f.left;
            if (left) {
                if (gf == null) {
                    f.father = e;
                    f.left = e.right;
                    if (f.left != null) {
                        f.left.father = f;
                    }
                    e.right = f;
                    e.father = null;
                    continue;
                }
                if (gf.right == f) {
                    gf.right = e;
                    f.father = e;
                    f.left = e.right;
                    if (f.left != null) {
                        f.left.father = f;
                    }
                    e.right = f;
                    e.father = gf;
                    continue;
                }
                ggf = gf.father;
                gf.left = f.right;
                if (gf.left != null) {
                    gf.left.father = gf;
                }
                f.right = gf;
                gf.father = f;
                f.left = e.right;
                if (f.left != null) {
                    f.left.father = f;
                }
                f.father = e;
                e.right = f;
                e.father = ggf;
                if (ggf == null) continue;
                if (ggf.left == gf) {
                    ggf.left = e;
                    continue;
                }
                ggf.right = e;
                continue;
            }
            if (gf == null) {
                f.father = e;
                f.right = e.left;
                if (f.right != null) {
                    f.right.father = f;
                }
                e.left = f;
                e.father = null;
                continue;
            }
            if (gf.left == f) {
                gf.left = e;
                f.father = e;
                f.right = e.left;
                if (f.right != null) {
                    f.right.father = f;
                }
                e.left = f;
                e.father = gf;
                continue;
            }
            ggf = gf.father;
            gf.right = f.left;
            if (gf.right != null) {
                gf.right.father = gf;
            }
            f.left = gf;
            gf.father = f;
            f.right = e.left;
            if (f.right != null) {
                f.right.father = f;
            }
            f.father = e;
            e.left = f;
            e.father = ggf;
            if (ggf == null) continue;
            if (ggf.left == gf) {
                ggf.left = e;
                continue;
            }
            ggf.right = e;
        }
    }

    private boolean remove(Entry e) {
        if (this.root == null || e == null) {
            return false;
        }
        this.splay(e);
        Entry leftTree = e.left;
        Entry rightTree = e.right;
        if (leftTree != null) {
            leftTree.father = null;
        }
        if (rightTree != null) {
            rightTree.father = null;
        }
        e.right = free;
        e.left = null;
        e.event = null;
        free = e;
        if (rightTree == null) {
            this.root = leftTree;
        } else if (leftTree == null) {
            this.root = rightTree;
        } else {
            Entry newRoot = rightTree;
            while (newRoot.left != null) {
                newRoot = newRoot.left;
            }
            this.splay(newRoot);
            newRoot.left = leftTree;
            leftTree.father = newRoot;
            this.root = newRoot;
        }
        ++this.modCount;
        return true;
    }

    private Entry findEntry(Event ev) {
        Entry cursor = this.root;
        double evtime = ev.time();
        while (cursor != null) {
            if (cursor.event == ev) {
                return cursor;
            }
            if (evtime < cursor.event.time()) {
                cursor = cursor.left;
                continue;
            }
            if (evtime > cursor.event.time()) {
                cursor = cursor.right;
                continue;
            }
            Entry center = cursor;
            while (cursor != null && cursor.event.time() == evtime) {
                if (cursor.event == ev) {
                    return cursor;
                }
                cursor = this.predecessor(cursor);
            }
            cursor = center;
            while (cursor != null && cursor.event.time() == evtime) {
                if (cursor.event == ev) {
                    return cursor;
                }
                cursor = this.successor(cursor);
            }
            return null;
        }
        return null;
    }

    private Entry successor(Entry cursor) {
        if (cursor == null) {
            return null;
        }
        if (cursor.right != null) {
            cursor = cursor.right;
            while (cursor.left != null) {
                cursor = cursor.left;
            }
        } else {
            while (cursor.father != null && cursor.father.right == cursor) {
                cursor = cursor.father;
            }
            cursor = cursor.father;
        }
        return cursor;
    }

    private Entry predecessor(Entry cursor) {
        if (cursor == null) {
            return null;
        }
        if (cursor.left != null) {
            cursor = cursor.left;
            while (cursor.right != null) {
                cursor = cursor.right;
            }
        } else {
            while (cursor.father != null && cursor.father.left == cursor) {
                cursor = cursor.father;
            }
            cursor = cursor.father;
        }
        return cursor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SPItr
    implements ListIterator<Event> {
        private Entry prev = null;
        private Entry next;
        private Entry lastRet;
        private int expectedModCount;
        private int nextIndex;

        SPItr() {
            this.next = SplayTree.this.root;
            if (this.next != null) {
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
            }
            this.expectedModCount = SplayTree.this.modCount;
            this.lastRet = null;
            this.nextIndex = 0;
        }

        @Override
        public void add(Event ev) {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next != null && ev.time() > this.next.event.time()) {
                ev.setTime(this.next.event.time());
            }
            if (this.prev != null && ev.time() < this.prev.event.time()) {
                ev.setTime(this.prev.event.time());
            }
            Entry e = SplayTree.this.add(ev, null);
            if (this.prev != null) {
                e.father = this.prev;
                e.right = this.prev.right;
                this.prev.right = e;
                if (e.right != null) {
                    e.right.father = e;
                }
            } else {
                if (this.next != SplayTree.this.root) {
                    if (this.next == this.next.father.left) {
                        this.next.father.left = e;
                    } else {
                        this.next.father.right = e;
                    }
                } else {
                    SplayTree.this.root = e;
                }
                e.father = this.next.father;
                this.next.father = e;
                e.right = this.next;
                e.left = this.next.left;
                if (e.left != null) {
                    e.left.father = e;
                }
                this.next.left = null;
            }
            this.prev = e;
            ++this.nextIndex;
            this.lastRet = null;
            ++SplayTree.this.modCount;
            ++this.expectedModCount;
        }

        @Override
        public boolean hasNext() {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public boolean hasPrevious() {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.prev != null;
        }

        @Override
        public Event next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Event ev = this.next.event;
            this.lastRet = this.next;
            this.prev = this.next;
            this.next = SplayTree.this.successor(this.next);
            return ev;
        }

        @Override
        public int nextIndex() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex;
        }

        @Override
        public Event previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this.nextIndex;
            Event ev = this.prev.event;
            this.lastRet = this.prev;
            this.next = this.prev;
            this.prev = SplayTree.this.predecessor(this.prev);
            return ev;
        }

        @Override
        public int previousIndex() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            if (this.lastRet == this.next) {
                this.next = SplayTree.this.successor(this.next);
            } else {
                this.prev = SplayTree.this.predecessor(this.prev);
                --this.nextIndex;
            }
            SplayTree.this.remove(this.lastRet);
            this.lastRet = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(Event ev) {
            if (SplayTree.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            Entry pred = SplayTree.this.predecessor(this.lastRet);
            Entry succ = SplayTree.this.successor(this.lastRet);
            if (pred != null && ev.time() < pred.event.time()) {
                ev.setTime(pred.event.time());
            }
            if (succ != null && ev.time() > succ.event.time()) {
                ev.setTime(succ.event.time());
            }
            this.lastRet.event = ev;
        }
    }

    private static class Entry {
        Event event;
        Entry father;
        Entry left;
        Entry right;

        Entry(Event event, Entry left, Entry right, Entry father) {
            this.event = event;
            this.left = left;
            this.right = right;
            this.father = father;
        }
    }
}

