/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.BetaSymmetricalDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.GammaProcessPCABridge;

public class GammaProcessPCASymmetricalBridge
extends GammaProcessPCABridge {
    public GammaProcessPCASymmetricalBridge(double s0, double mu, double nu, RandomStream stream) {
        super(s0, mu, nu, stream);
    }

    public double[] generatePath(double[] uniform01) {
        int oldIndexR;
        int newIndex;
        int oldIndexL;
        double[] uniformsV = new double[this.d + 1];
        double[] BMPCApath = this.BMPCA.generatePath(uniform01);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            oldIndexL = this.BMBridge.wIndexList[j];
            newIndex = this.BMBridge.wIndexList[j + 1];
            oldIndexR = this.BMBridge.wIndexList[j + 2];
            double temp = BMPCApath[newIndex] - BMPCApath[oldIndexL];
            temp -= (BMPCApath[oldIndexR] - BMPCApath[oldIndexL]) * this.BMBridge.wMuDt[newIndex];
            uniformsV[newIndex] = NormalDist.cdf01(temp /= this.BMBridge.wSqrtDt[newIndex]);
        }
        double dT = this.BMPCA.t[this.d] - this.BMPCA.t[0];
        uniformsV[this.d] = NormalDist.cdf01((BMPCApath[this.d] - BMPCApath[0] - this.BMPCA.mu * dT) / (this.BMPCA.sigma * Math.sqrt(dT)));
        this.path[0] = this.x0;
        this.path[this.d] = this.x0 + GammaDist.inverseF(this.mu2dTOverNu, this.muOverNu, 15, uniformsV[this.d]);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            oldIndexL = this.wIndexList[j];
            newIndex = this.wIndexList[j + 1];
            oldIndexR = this.wIndexList[j + 2];
            double y = BetaSymmetricalDist.inverseF(this.bMu2dtOverNuL[newIndex], uniformsV[newIndex]);
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath() {
        double[] u = new double[this.d];
        for (int i = 0; i < this.d; ++i) {
            u[i] = this.stream.nextDouble();
        }
        return this.generatePath(u);
    }

    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            int x = this.d;
            int y = 1;
            while (x > 1) {
                x /= 2;
                y *= 2;
            }
            if (y != this.d) {
                throw new IllegalArgumentException("GammaSymmetricalBridgeProcess:Number 'n' of observation times is not a power of 2");
            }
        }
    }
}

