/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassifierFactory;
import de.jstacs.classifiers.assessment.KFoldCrossValidation;
import de.jstacs.classifiers.assessment.KFoldCrossValidationAssessParameterSet;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasure;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.results.ListResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.homogeneous.HomogeneousMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.FSDAGTrainSM;

public class JenaExample {
    public static void main(String[] args) throws Exception {
        DNADataSet foreground = new DNADataSet("foreground.fa");
        DNADataSet background = new DNADataSet("background.fa");
        FSDAGTrainSM pwm = TrainableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, foreground.getElementLength(), 4.0);
        pwm.train(foreground);
        System.out.println(pwm);
        HomogeneousMM bgModel = TrainableStatisticalModelFactory.createHomogeneousMarkovModel(DNAAlphabetContainer.SINGLETON, 4.0, (byte)0);
        AbstractClassifier classifier = ClassifierFactory.createGenerativeClassifier(pwm, bgModel);
        classifier.train(foreground, background);
        NumericalPerformanceMeasureParameterSet measures = new NumericalPerformanceMeasureParameterSet(new AucROC(), new AucPR());
        classifier.evaluate((AbstractPerformanceMeasureParameterSet<? extends PerformanceMeasure>)measures, true, foreground, background);
        KFoldCrossValidation cv = new KFoldCrossValidation(classifier);
        KFoldCrossValidationAssessParameterSet assessPS = new KFoldCrossValidationAssessParameterSet(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS, foreground.getElementLength(), true, 10);
        ListResult lr = cv.assess(measures, assessPS, foreground, background);
        System.out.println(lr);
    }
}

