/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment.cost;

import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.sequences.Sequence;

public class SimpleCosts
implements Costs {
    private double match;
    private double mismatch;
    private double gap;

    public SimpleCosts(double match, double mismatch, double gap) {
        this.gap = gap;
        if (mismatch <= 0.0) {
            throw new IllegalArgumentException("Problem: mismatch <= 0");
        }
        this.mismatch = mismatch;
        if (match > 0.0) {
            throw new IllegalArgumentException("Problem: match > 0");
        }
        this.match = match;
    }

    @Override
    public double getCostFor(Sequence s1, Sequence s2, int i, int j) {
        return s1.discreteVal(i - 1) != s2.discreteVal(j - 1) ? this.mismatch : this.match;
    }

    @Override
    public double getGapCosts() {
        return this.gap;
    }
}

