/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.CyclicSequenceAdaptor;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.utils.IntList;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;

public class DeBruijnSequenceGenerator {
    public static void main(String[] args) throws Exception {
        int k = 6;
        int m = 3;
        CyclicSequenceAdaptor seq = DeBruijnSequenceGenerator.generate(DNAAlphabet.SINGLETON, k, 0);
        System.out.println(seq);
        HashMap<Sequence, Integer> map = new HashMap<Sequence, Integer>();
        DataSet ds = new DataSet(new DataSet("", seq.getSuperSequence(seq.getLength() + k - 1)), k);
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            map.put(ds.getElementAt(i), 1);
            ++i;
        }
        DiscreteSequenceEnumerator en = new DiscreteSequenceEnumerator(seq.getAlphabetContainer(), k, false);
        while (en.hasMoreElements()) {
            Object temp = en.nextElement();
            if (map.get(temp) != null) continue;
            throw new Exception(((Sequence)temp).toString());
        }
        System.out.println("all");
    }

    public static CyclicSequenceAdaptor[] generate(DiscreteAlphabet alphabet, int n) throws WrongAlphabetException, WrongSequenceTypeException, OperationNotSupportedException {
        CyclicSequenceAdaptor[] seqs = new CyclicSequenceAdaptor[(int)alphabet.length()];
        int i = 0;
        while (i < seqs.length) {
            seqs[i] = DeBruijnSequenceGenerator.generate(DNAAlphabet.SINGLETON, n, i);
            ++i;
        }
        return seqs;
    }

    public static CyclicSequenceAdaptor generate(DiscreteAlphabet alphabet, int n, int alphabetShift) throws WrongAlphabetException, WrongSequenceTypeException {
        int k = (int)alphabet.length();
        if (alphabetShift >= k || alphabetShift < 0) {
            throw new IllegalArgumentException("alphabet shift greater than alphabet size");
        }
        IntList seq = new IntList();
        int[] a = new int[k * n];
        DeBruijnSequenceGenerator.db(1, 1, n, k, seq, a);
        int[] seqa = seq.toArray();
        if (alphabetShift != 0) {
            int i = 0;
            while (i < seqa.length) {
                seqa[i] = (seqa[i] + alphabetShift) % k;
                ++i;
            }
        }
        return new CyclicSequenceAdaptor<int[]>(new IntSequence(new AlphabetContainer((Alphabet)alphabet), seqa));
    }

    private static void db(int t, int p, int n, int k, IntList seq, int[] a) {
        block3: {
            block2: {
                if (t <= n) break block2;
                if (n % p != 0) break block3;
                int j = 1;
                while (j < p + 1) {
                    seq.add(a[j]);
                    ++j;
                }
                break block3;
            }
            a[t] = a[t - p];
            DeBruijnSequenceGenerator.db(t + 1, p, n, k, seq, a);
            int j = a[t - p] + 1;
            while (j < k) {
                a[t] = j++;
                DeBruijnSequenceGenerator.db(t + 1, t, n, k, seq, a);
            }
        }
    }
}

