/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhConstraint;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.SequenceIterator;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.FastDirichletMRGParams;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class MEMConstraint
extends InhConstraint {
    private double[] expLambda;
    private double[] lambda;
    private int[] corrected_positions;
    private static String XML_TAG = "MEMConstraint";

    private static int[] isSorted(int[] pos) throws IllegalArgumentException {
        int i = 1;
        while (i < pos.length && pos[i - 1] < pos[i]) {
            ++i;
        }
        if (i < pos.length) {
            throw new IllegalArgumentException("The position array is not unique.");
        }
        return pos;
    }

    public MEMConstraint(int[] pos, int[] alphabetLength) throws IllegalArgumentException {
        super(MEMConstraint.isSorted(pos), alphabetLength);
        this.expLambda = new double[this.counts.length];
        Arrays.fill(this.expLambda, 1.0);
        this.lambda = new double[this.counts.length];
        this.corrected_positions = this.usedPositions;
    }

    public MEMConstraint(int[] pos, int[] alphabetLength, int[] corrected_positions) throws IllegalArgumentException {
        super(MEMConstraint.isSorted(pos), alphabetLength);
        if (pos.length != corrected_positions.length) {
            throw new IllegalArgumentException("The length of pos and corrected_positions is not equal.");
        }
        this.expLambda = new double[this.counts.length];
        this.lambda = new double[this.counts.length];
        this.corrected_positions = (int[])corrected_positions.clone();
    }

    public MEMConstraint(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public MEMConstraint clone() throws CloneNotSupportedException {
        MEMConstraint clone = (MEMConstraint)super.clone();
        clone.expLambda = (double[])this.expLambda.clone();
        clone.lambda = (double[])this.lambda.clone();
        clone.corrected_positions = this.corrected_positions == this.usedPositions ? clone.usedPositions : (int[])this.corrected_positions.clone();
        return clone;
    }

    @Override
    public void estimate(double ess) {
        this.estimateUnConditional(0, this.freq.length, ess / (double)this.freq.length, true);
    }

    public void draw(double ess) {
        FastDirichletMRGParams alpha = new FastDirichletMRGParams(ess / (double)this.freq.length);
        DirichletMRG.DEFAULT_INSTANCE.generate(this.expLambda, 0, this.expLambda.length, alpha);
        int i = 0;
        while (i < this.expLambda.length) {
            this.lambda[i] = Math.log(this.expLambda[i]);
            ++i;
        }
    }

    public int getCorrectedPosition(int index) {
        return this.corrected_positions[index];
    }

    public double getExpLambda(int index) {
        return this.expLambda[index];
    }

    public double getLambda(int index) {
        return this.lambda[index];
    }

    public void multiplyExpLambdaWith(int index, double val) {
        int n = index;
        this.expLambda[n] = this.expLambda[n] * val;
        int n2 = index;
        this.lambda[n2] = this.lambda[n2] + Math.log(val);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.expLambda, 1.0);
        Arrays.fill(this.lambda, 0.0);
    }

    public int satisfiesSpecificConstraint(SequenceIterator sequence) {
        int erg = 0;
        int i = 0;
        while (i < this.corrected_positions.length) {
            erg += this.offset[i] * sequence.seq[this.corrected_positions[i]];
            ++i;
        }
        return erg;
    }

    @Override
    public double getFreq(int index) {
        return this.freq[index];
    }

    public void setExpLambda(int index, double val) {
        this.expLambda[index] = val;
        this.lambda[index] = Math.log(val);
    }

    public void setLambda(int index, double val) {
        this.expLambda[index] = Math.exp(val);
        this.lambda[index] = val;
    }

    @Override
    public String toString() {
        String erg = "" + this.usedPositions[0];
        int i = 1;
        while (i < this.usedPositions.length) {
            erg = String.valueOf(erg) + ", " + this.usedPositions[i];
            ++i;
        }
        return erg;
    }

    @Override
    protected void appendAdditionalInfo(StringBuffer xml) {
        super.appendAdditionalInfo(xml);
        XMLParser.appendObjectWithTags(xml, this.lambda, "lambda");
        if (this.corrected_positions != this.usedPositions) {
            StringBuffer b = new StringBuffer(500);
            XMLParser.appendObjectWithTags(b, this.corrected_positions, "corrected_positions");
            XMLParser.addTags(b, "corrected");
            xml.append(b);
        }
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void extractAdditionalInfo(StringBuffer xml) throws NonParsableException {
        super.extractAdditionalInfo(xml);
        this.lambda = XMLParser.extractObjectForTags(xml, "lambda", double[].class);
        this.expLambda = new double[this.lambda.length];
        int i = 0;
        while (i < this.lambda.length) {
            this.expLambda[i] = Math.exp(this.lambda[i]);
            ++i;
        }
        StringBuffer corrected = XMLParser.extractForTag(xml, "corrected");
        this.corrected_positions = corrected == null ? this.usedPositions : XMLParser.extractObjectForTags(corrected, "corrected_positions", int[].class);
    }

    /*
     * Unable to fully structure code
     */
    public int comparePosition(int offset, MEMConstraint constr) {
        matching = 0;
        u1 = 0;
        u2 = 0;
        ** GOTO lbl11
        {
            ++u2;
            do {
                if (u2 < constr.usedPositions.length && constr.usedPositions[u2] - offset < this.usedPositions[u1]) continue block0;
                if (u2 < constr.usedPositions.length && constr.usedPositions[u2] - offset == this.usedPositions[u1]) {
                    ++matching;
                }
                ++u1;
lbl11:
                // 2 sources

            } while (u1 < this.usedPositions.length);
        }
        return matching;
    }

    public void addParameters(int offset, IntList list, MEMConstraint[] constraint, double[] params, int[] start) {
        int idx;
        HashSet<Integer> hash = new HashSet<Integer>();
        int u = 0;
        while (u < this.usedPositions.length) {
            hash.add(this.usedPositions[u]);
            ++u;
        }
        int n = 0;
        while (n < list.length()) {
            idx = list.get(n);
            u = 0;
            while (u < constraint[idx].usedPositions.length) {
                hash.add(constraint[idx].usedPositions[u] - offset);
                ++u;
            }
            ++n;
        }
        int[] pos = new int[hash.size()];
        Iterator it = hash.iterator();
        u = 0;
        while (it.hasNext()) {
            pos[u] = (Integer)it.next();
            ++u;
        }
        Arrays.sort(pos);
        Arrays.fill(this.expLambda, Double.NEGATIVE_INFINITY);
        int alphLength = this.lambda.length / this.offset[0] - 1;
        int[] assignment = new int[pos.length + 1];
        while (assignment[pos.length] == 0) {
            int i;
            int index;
            double p = 0.0;
            n = 0;
            while (n < list.length()) {
                idx = list.get(n);
                index = 0;
                i = 0;
                u = 0;
                while (u < pos.length && i < constraint[idx].usedPositions.length) {
                    if (pos[u] == constraint[idx].usedPositions[i] - offset) {
                        index += constraint[idx].offset[i] * assignment[u];
                        ++i;
                    }
                    ++u;
                }
                p += params[start[idx] + index];
                ++n;
            }
            index = 0;
            i = 0;
            u = 0;
            while (u < pos.length && i < this.usedPositions.length) {
                if (pos[u] == this.usedPositions[i]) {
                    index += this.offset[i] * assignment[u];
                    ++i;
                }
                ++u;
            }
            this.expLambda[index] = Normalisation.getLogSum(this.expLambda[index], p);
            u = 0;
            while (u < pos.length && assignment[u] == alphLength) {
                assignment[u] = 0;
                ++u;
            }
            int n2 = u;
            assignment[n2] = assignment[n2] + 1;
        }
        u = 0;
        while (u < this.lambda.length) {
            int n3 = u;
            this.lambda[n3] = this.lambda[n3] + this.expLambda[u];
            this.expLambda[u] = Math.exp(this.lambda[u]);
            ++u;
        }
    }
}

