/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.polynomial;

public final class ComplexPolynomial {
    private static final double EPS = 1.0E-14;

    public static void eval(double[] dArray, double[] dArray2, int n, double d, double d2, double[] dArray3) {
        ComplexPolynomial.eval(dArray, dArray2, 0, n, d, d2, dArray3);
    }

    public static void eval(double[] dArray, double[] dArray2, int n, int n2, double d, double d2, double[] dArray3) {
        if (n2 < -n) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return;
        }
        double d3 = dArray[n + n2];
        double d4 = dArray2[n + n2];
        if (n2 > 0) {
            int n3 = n2 - 1;
            for (int i = n3 + n; i >= 0 && n3 >= 0; --n3, --i) {
                double d5 = d3;
                double d6 = d4;
                d3 = d5 * d - d6 * d2 + dArray[i];
                d4 = d5 * d2 + d6 * d + dArray2[i];
            }
            while (n3 >= 0) {
                double d7 = d3;
                double d8 = d4;
                d3 = d7 * d - d8 * d2;
                d4 = d7 * d2 + d8 * d;
                --n3;
            }
        }
        dArray3[0] = d3;
        dArray3[1] = d4;
    }

    public static void evalDerivative(double[] dArray, double[] dArray2, int n, int n2, double d, double d2, double[] dArray3) {
        ComplexPolynomial.evalDerivative(dArray, dArray2, 0, n, n2, d, d2, dArray3);
    }

    public static void evalDerivative(double[] dArray, double[] dArray2, int n, int n2, int n3, double d, double d2, double[] dArray3) {
        if (n2 < -n || n2 < n3) {
            dArray3[0] = 0.0;
            dArray3[1] = 0.0;
            return;
        }
        double d3 = 1.0;
        for (int i = n2; i > n2 - n3; --i) {
            d3 *= (double)i;
        }
        double d4 = d3 * dArray[n + n2];
        double d5 = d3 * dArray2[n + n2];
        if (n2 > 0) {
            int n4 = n2 - 1;
            for (int i = n4 + n; i >= 0 && n4 >= n3; --n4, --i) {
                d3 *= (double)(n4 + 1 - n3);
                double d6 = d4;
                double d7 = d5;
                d4 = d6 * d - d7 * d2 + (d3 /= (double)(n4 + 1)) * dArray[i];
                d5 = d6 * d2 + d7 * d + d3 * dArray2[i];
            }
            while (n4 >= n3) {
                double d8 = d4;
                double d9 = d5;
                d4 = d8 * d - d9 * d2;
                d5 = d8 * d2 + d9 * d;
                --n4;
            }
        }
        dArray3[0] = d4;
        dArray3[1] = d5;
    }

    public static int calcDeg(double[] dArray, double[] dArray2, int n) {
        for (int i = n; i >= 0; --i) {
            if (!(dArray[i] * dArray[i] + dArray2[i] * dArray2[i] >= 1.0E-28)) continue;
            return i;
        }
        return -1;
    }

    public static void multiplyToConst(double d, double d2, double[] dArray, double[] dArray2, int n, double[] dArray3, double[] dArray4) {
        for (int i = 0; i <= n; ++i) {
            double d3 = dArray[i];
            double d4 = dArray2[i];
            dArray3[i] = d * d3 - d2 * d4;
            dArray4[i] = d * d4 + d2 * d3;
        }
    }

    public static void plus(double[] dArray, double[] dArray2, int n, double[] dArray3, double[] dArray4, int n2, double[] dArray5, double[] dArray6) {
        if (n == n2) {
            for (int i = 0; i <= n; ++i) {
                dArray5[i] = dArray[i] + dArray3[i];
                dArray6[i] = dArray2[i] + dArray4[i];
            }
        } else if (n < n2) {
            for (int i = 0; i <= n; ++i) {
                dArray5[i] = dArray[i] + dArray3[i];
                dArray6[i] = dArray2[i] + dArray4[i];
            }
            System.arraycopy(dArray3, n + 1, dArray5, n + 1, n2 - n);
            System.arraycopy(dArray4, n + 1, dArray6, n + 1, n2 - n);
        } else {
            for (int i = 0; i <= n2; ++i) {
                dArray5[i] = dArray[i] + dArray3[i];
                dArray6[i] = dArray2[i] + dArray4[i];
            }
            System.arraycopy(dArray, n2 + 1, dArray5, n2 + 1, n - n2);
            System.arraycopy(dArray2, n2 + 1, dArray6, n2 + 1, n - n2);
        }
    }

    public static void linComb(double d, double d2, double[] dArray, double[] dArray2, int n, double d3, double d4, double[] dArray3, double[] dArray4, int n2, double[] dArray5, double[] dArray6) {
        if (n == n2) {
            for (int i = 0; i <= n; ++i) {
                double d5 = dArray[i];
                double d6 = dArray2[i];
                double d7 = dArray3[i];
                double d8 = dArray4[i];
                dArray5[i] = d * d5 - d2 * d6 + d3 * d7 - d4 * d8;
                dArray6[i] = d * d6 + d2 * d5 + d3 * d8 + d4 * d7;
            }
        } else if (n < n2) {
            double d9;
            double d10;
            int n3;
            for (n3 = 0; n3 <= n; ++n3) {
                double d11 = dArray[n3];
                double d12 = dArray2[n3];
                d10 = dArray3[n3];
                d9 = dArray4[n3];
                dArray5[n3] = d * d11 - d2 * d12 + d3 * d10 - d4 * d9;
                dArray6[n3] = d * d12 + d2 * d11 + d3 * d9 + d4 * d10;
            }
            for (n3 = n + 1; n3 <= n2; ++n3) {
                d10 = dArray3[n3];
                d9 = dArray4[n3];
                dArray5[n3] = d3 * d10 - d4 * d9;
                dArray6[n3] = d3 * d9 + d4 * d10;
            }
        } else {
            double d13;
            double d14;
            int n4;
            for (n4 = 0; n4 <= n2; ++n4) {
                d14 = dArray[n4];
                d13 = dArray2[n4];
                double d15 = dArray3[n4];
                double d16 = dArray4[n4];
                dArray5[n4] = d * d14 - d2 * d13 + d3 * d15 - d4 * d16;
                dArray6[n4] = d * d13 + d2 * d14 + d3 * d16 + d4 * d15;
            }
            for (n4 = n2 + 1; n4 <= n; ++n4) {
                d14 = dArray[n4];
                d13 = dArray2[n4];
                dArray5[n4] = d * d14 - d2 * d13;
                dArray6[n4] = d * d13 + d2 * d14;
            }
        }
    }

    public static void derivative(double[] dArray, double[] dArray2, int n, int n2, double[] dArray3, double[] dArray4) {
        int n3;
        int n4 = 1;
        for (n3 = 2; n3 <= n2; ++n3) {
            n4 *= n3;
        }
        n3 = 0;
        for (int i = n2; i <= n; ++i) {
            dArray3[n3] = dArray[i] * (double)n4;
            dArray4[n3] = dArray2[i] * (double)n4;
            n4 *= i + 1;
            n4 /= n3 + 1;
            ++n3;
        }
    }

    public static void times(double[] dArray, double[] dArray2, int n, double[] dArray3, double[] dArray4, int n2, double[] dArray5, double[] dArray6) {
        ComplexPolynomial.times(dArray, dArray2, n, dArray3, dArray4, n2, dArray5, dArray6, n + n2);
    }

    public static void times(double[] dArray, double[] dArray2, int n, double[] dArray3, double[] dArray4, int n2, double[] dArray5, double[] dArray6, int n3) {
        int n4;
        for (n4 = n3; n4 > n + n2; --n4) {
            dArray5[n4] = 0.0;
            dArray6[n4] = 0.0;
        }
        while (n4 >= 0) {
            double d = 0.0;
            double d2 = 0.0;
            int n5 = Math.min(n4, n);
            for (int i = Math.max(0, n4 - n2); i <= n5; ++i) {
                d = d + dArray[i] * dArray3[n4 - i] - dArray2[i] * dArray4[n4 - i];
                d2 = d2 + dArray2[i] * dArray3[n4 - i] + dArray[i] * dArray4[n4 - i];
            }
            dArray5[n4] = d;
            dArray6[n4] = d2;
            --n4;
        }
    }

    public static void divide(double[] dArray, double[] dArray2, int n, double[] dArray3, double[] dArray4, int n2, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) {
        System.arraycopy(dArray, 0, dArray7, 0, n + 1);
        System.arraycopy(dArray2, 0, dArray8, 0, n + 1);
        if (n >= n2) {
            double d = dArray3[n2];
            double d2 = dArray4[n2];
            double d3 = d / (d * d + d2 * d2);
            double d4 = -d2 / (d * d + d2 * d2);
            for (int i = n - n2; i >= 0; --i) {
                double d5 = d3 * dArray7[i + n2] - d4 * dArray8[i + n2];
                double d6 = d4 * dArray7[i + n2] + d3 * dArray8[i + n2];
                dArray5[i] = d5;
                dArray6[i] = d6;
                for (int j = n2; j >= 0; --j) {
                    int n3 = i + j;
                    dArray7[n3] = dArray7[n3] - (d5 * dArray3[j] - d6 * dArray4[j]);
                    int n4 = i + j;
                    dArray8[n4] = dArray8[n4] - (d6 * dArray3[j] + d5 * dArray4[j]);
                }
            }
        } else {
            dArray5[0] = 0.0;
            dArray6[0] = 0.0;
        }
    }

    public static void laguerOneRoot(double[] dArray, double[] dArray2, int n, double d, double[] dArray3) {
        double[] dArray4 = new double[]{0.0, 0.5, 0.25, 0.75, 0.13, 0.38, 0.62, 0.88, 1.0};
        double d2 = dArray3[0];
        double d3 = dArray3[1];
        for (int i = 1; i <= 8000; ++i) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10 = dArray[n];
            double d11 = dArray2[n];
            double d12 = Math.sqrt(d10 * d10 + d11 * d11);
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            double d16 = 0.0;
            double d17 = Math.sqrt(d2 * d2 + d3 * d3);
            for (int j = n - 1; j >= 0; --j) {
                d9 = d15;
                d8 = d16;
                d15 = d2 * d9 - d3 * d8 + d13;
                d16 = d2 * d8 + d3 * d9 + d14;
                d9 = d13;
                d8 = d14;
                d13 = d2 * d9 - d3 * d8 + d10;
                d14 = d2 * d8 + d3 * d9 + d11;
                d9 = d10;
                d8 = d11;
                d10 = d2 * d9 - d3 * d8 + dArray[j];
                d11 = d2 * d8 + d3 * d9 + dArray2[j];
                d12 = Math.sqrt(d10 * d10 + d11 * d11) + d17 * d12;
            }
            double d18 = d10 * d10 + d11 * d11;
            if (d18 <= (d12 *= d) * d12) {
                dArray3[0] = d2;
                dArray3[1] = d3;
                return;
            }
            double d19 = (d13 * d10 + d14 * d11) / d18;
            double d20 = (d14 * d10 - d13 * d11) / d18;
            double d21 = d19 * d19 - d20 * d20;
            double d22 = 2.0 * d20 * d19;
            d9 = (d15 * d10 + d16 * d11) / d18;
            d8 = (d16 * d10 - d15 * d11) / d18;
            double d23 = d21 - 2.0 * d9;
            double d24 = d22 - 2.0 * d8;
            d9 = ((double)n - 1.0) * ((double)n * d23 - d21);
            d8 = ((double)n - 1.0) * ((double)n * d24 - d22);
            if (d9 == 0.0 && d8 == 0.0) {
                d7 = 0.0;
                d6 = 0.0;
            } else if (d9 >= 0.0) {
                d7 = Math.sqrt((Math.sqrt(d9 * d9 + d8 * d8) + d9) / 2.0);
                d6 = d8 / (2.0 * d7);
            } else {
                d6 = Math.sqrt((Math.sqrt(d9 * d9 + d8 * d8) - d9) / 2.0);
                d7 = d8 / (2.0 * d6);
            }
            double d25 = d19 + d7;
            double d26 = d20 + d6;
            double d27 = d19 - d7;
            double d28 = d20 - d6;
            double d29 = d25 * d25 + d26 * d26;
            double d30 = d27 * d27 + d28 * d28;
            if (d29 < d30) {
                d25 = d27;
                d26 = d28;
                d29 = d30;
            }
            if (d29 > 0.0) {
                d5 = d25 * (double)n / d29;
                d4 = -d26 * (double)n / d29;
            } else {
                d5 = (1.0 + d17) * Math.cos(i);
                d4 = (1.0 + d17) * Math.sin(i);
            }
            double d31 = d2 - d5;
            double d32 = d3 - d4;
            if (d31 == d2 && d32 == d3) {
                dArray3[0] = d2;
                dArray3[1] = d3;
                return;
            }
            if (i % 1000 != 0) {
                d2 = d31;
                d3 = d32;
                continue;
            }
            d2 -= d5 * dArray4[i / 1000];
            d3 -= d4 * dArray4[i / 1000];
        }
        throw new IllegalArgumentException(" The root was not found -- too many iterations ");
    }

    public static void laguerAllRoots(double[] dArray, double[] dArray2, int n, double d, double[] dArray3, double[] dArray4) {
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[n + 1];
        double[] dArray7 = new double[n + 1];
        System.arraycopy(dArray, 0, dArray6, 0, n + 1);
        System.arraycopy(dArray2, 0, dArray7, 0, n + 1);
        for (int i = n; i >= 1; --i) {
            dArray5[1] = 0.0;
            dArray5[0] = 0.0;
            ComplexPolynomial.laguerOneRoot(dArray6, dArray7, i, d, dArray5);
            double d2 = dArray5[0];
            dArray3[i - 1] = d2;
            double d3 = d2;
            double d4 = dArray5[1];
            dArray4[i - 1] = d4;
            double d5 = d4;
            double d6 = dArray6[i];
            double d7 = dArray7[i];
            for (int j = i - 1; j >= 0; --j) {
                double d8 = dArray6[j];
                double d9 = dArray7[j];
                dArray6[j] = d6;
                dArray7[j] = d7;
                double d10 = d8 + d3 * d6 - d5 * d7;
                double d11 = d9 + d5 * d6 + d3 * d7;
                d6 = d10;
                d7 = d11;
            }
        }
    }

    public static void setZero(int n, double[] dArray) {
        for (int i = 0; i <= n; ++i) {
            dArray[i] = 0.0;
        }
    }

    public static String toString(double[] dArray, double[] dArray2, int n) {
        return ComplexPolynomial.toString(dArray, dArray2, 0, n, 1.0E-14);
    }

    public static String toString(double[] dArray, double[] dArray2, int n, double d) {
        return ComplexPolynomial.toString(dArray, dArray2, 0, n, d);
    }

    public static String toString(double[] dArray, double[] dArray2, int n, int n2, double d) {
        StringBuffer stringBuffer = new StringBuffer(300);
        boolean bl = true;
        for (int i = n; i <= n2; ++i) {
            double d2 = dArray[i - n];
            double d3 = dArray2[i - n];
            if (!(d2 * d2 + d3 * d3 > 1.0E-28)) continue;
            if (!bl) {
                stringBuffer.append(" + ");
            } else {
                bl = false;
            }
            stringBuffer.append("( ");
            stringBuffer.append(d2);
            if (d3 < 0.0) {
                stringBuffer.append(" - i");
                stringBuffer.append(-d3);
            } else {
                stringBuffer.append(" + i");
                stringBuffer.append(d3);
            }
            stringBuffer.append(" ) z^");
            stringBuffer.append(i);
        }
        if (bl) {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }
}

