/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public class RungeKutta
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int numOfEquations;
    double stepSize = 0.1;
    private double[] y_;
    private double[] k1;
    private double[] k2;
    private double[] k3;
    private double[] k4;

    public RungeKutta(int n) {
        this.setNumOfEquations(n);
    }

    public RungeKutta() {
        this(1);
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double d) {
        if (this.stepSize == d) {
            return;
        }
        this.stepSize = d;
    }

    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    public void setNumOfEquations(int n) {
        if (this.numOfEquations == n) {
            return;
        }
        this.numOfEquations = n;
        this.y_ = new double[n];
        this.k1 = new double[n];
        this.k2 = new double[n];
        this.k3 = new double[n];
        this.k4 = new double[n];
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2) {
        RungeKutta.rungeKutta(oDE, dArray, d, d2, this.stepSize, this.y_, this.k1, this.k2, this.k3, this.k4);
    }

    public static double rungeKuttaStep(ODE oDE, double d, double[] dArray, double d2, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n;
        int n2 = oDE.getNumberOfEquations();
        double d3 = d2 / 2.0;
        double d4 = d2 / 6.0;
        oDE.eval(d, dArray, dArray3);
        double d5 = d + d3;
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n] + d3 * dArray3[n];
        }
        oDE.eval(d5, dArray2, dArray4);
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n] + d3 * dArray4[n];
        }
        oDE.eval(d5, dArray2, dArray5);
        d5 = d + d2;
        for (n = 0; n < n2; ++n) {
            dArray2[n] = dArray[n] + d2 * dArray5[n];
        }
        oDE.eval(d5, dArray2, dArray6);
        for (n = 0; n < n2; ++n) {
            int n3 = n;
            dArray[n3] = dArray[n3] + d4 * (dArray3[n] + 2.0 * (dArray4[n] + dArray5[n]) + dArray6[n]);
        }
        return d5;
    }

    public static void rungeKutta(ODE oDE, double[] dArray, double d, double d2, double d3, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) {
        int n = (int)((d2 - d) / d3) + 1;
        double d4 = (d2 - d) / (double)n;
        double d5 = d;
        for (int i = 0; i < n; ++i) {
            d5 = RungeKutta.rungeKuttaStep(oDE, d5, dArray, d4, dArray2, dArray3, dArray4, dArray5, dArray6);
        }
    }

    public static void rungeKutta(ODE oDE, double[] dArray, double d, double d2, double d3) {
        RungeKutta.rungeKutta(oDE, dArray, d, d2, d3, new double[dArray.length], new double[dArray.length], new double[dArray.length], new double[dArray.length], new double[dArray.length]);
    }
}

