/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.gui.glyph.Glyph;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.FilteringRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.utils.ChangeVetoException;

public class GlyphFeatureRenderer
extends FilteringRenderer
implements FeatureRenderer {
    private double depth = 15.0;
    private List fList = new ArrayList();
    private List gList = new ArrayList();

    public void addFilterAndGlyph(FeatureFilter ff, Glyph g) throws ChangeVetoException {
        this.fList.add(ff);
        this.gList.add(g);
        if (this.fList.size() == 0) {
            this.setFilter(FeatureFilter.none);
        } else {
            FeatureFilter f = (FeatureFilter)this.fList.get(0);
            if (this.fList.size() == 1) {
                this.setFilter(f);
            } else {
                for (int i = 1; i < this.fList.size(); ++i) {
                    f = new FeatureFilter.Or(f, (FeatureFilter)this.fList.get(i));
                }
                this.setFilter(f);
            }
        }
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public double getDepth(SequenceRenderContext src) {
        return this.depth;
    }

    public FeatureHolder processMouseEvent(FeatureHolder fh, SequenceRenderContext src, MouseEvent me) {
        return fh;
    }

    public void renderFeature(Graphics2D g2, Feature f, SequenceRenderContext src) {
        float minBounds = (float)src.sequenceToGraphics(f.getLocation().getMin());
        float maxBounds = (float)src.sequenceToGraphics(f.getLocation().getMax() + 1);
        Rectangle2D.Float bounds = new Rectangle2D.Float(minBounds, 0.0f, maxBounds - minBounds, (float)this.depth);
        for (int i = 0; i < this.fList.size(); ++i) {
            if (!((FeatureFilter)this.fList.get(i)).accept(f)) continue;
            Glyph g = (Glyph)this.gList.get(i);
            g.setBounds(bounds);
            if (src.getDirection() != 0) continue;
            g.render(g2);
        }
    }
}

