/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.program.das.ComponentFeatureHandler;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASCapabilities;
import org.biojava.bio.program.das.DASGFFFeatureHandler;
import org.biojava.bio.program.das.DASLinkHandler;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.program.das.Fetcher;
import org.biojava.bio.program.das.Segment;
import org.biojava.bio.program.xff.ElementRecognizer;
import org.biojava.bio.program.xff.XFFFeatureSetHandler;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class FeatureFetcher
implements Fetcher {
    private HashMap ticketsBySegment;
    private List doneTickets = Collections.EMPTY_LIST;
    private String category;
    private String type;
    private URL dataSource;

    FeatureFetcher(URL dataSource, String type, String category) {
        this.ticketsBySegment = new HashMap();
        this.dataSource = dataSource;
        this.type = type;
        this.category = category;
    }

    public URL getDataSourceURL() {
        return this.dataSource;
    }

    public void addTicket(FeatureRequestManager.Ticket ticket) {
        this.ticketsBySegment.put(ticket.getSegment(), ticket);
    }

    public int size() {
        return this.ticketsBySegment.size();
    }

    public List getDoneTickets() {
        return this.doneTickets;
    }

    public void runFetch() throws BioException, ParseException {
        DAS.startedActivity(this);
        URL fURL = null;
        try {
            HttpURLConnection huc;
            String fetchEncoding;
            block14: {
                int status;
                fetchEncoding = "dasgff";
                if (DASCapabilities.checkCapable(new URL(this.dataSource, "../"), "featureTable", "xff")) {
                    fetchEncoding = "xff";
                }
                huc = null;
                Set segmentObjs = this.ticketsBySegment.keySet();
                StringBuffer sb = new StringBuffer();
                Iterator i = segmentObjs.iterator();
                while (i.hasNext()) {
                    Object seg = i.next();
                    sb.append("segment=");
                    Segment segment = (Segment)seg;
                    sb.append(segment.getID());
                    if (segment.isBounded()) {
                        sb.append(':');
                        sb.append(segment.getStart());
                        sb.append(',');
                        sb.append(segment.getStop());
                    }
                    if (!i.hasNext()) continue;
                    sb.append(';');
                }
                String segments = sb.substring(0);
                String encodingRequest = "categorize=yes;";
                encodingRequest = fetchEncoding.equals("dasgff") ? encodingRequest + "" : encodingRequest + "encoding=" + fetchEncoding + ";";
                String typeRequest = "";
                if (this.type != null) {
                    typeRequest = "type=" + this.type + ";";
                }
                String categoryRequest = "";
                if (this.category != null) {
                    categoryRequest = "category=" + this.category + ";";
                }
                String queryString = encodingRequest + categoryRequest + typeRequest + segments;
                fURL = new URL(this.dataSource, "features");
                int tries = 0;
                while (true) {
                    huc = (HttpURLConnection)fURL.openConnection();
                    huc.setRequestMethod("POST");
                    huc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    huc.setRequestProperty("Accept-Encoding", "gzip");
                    huc.setDoOutput(true);
                    OutputStream os = huc.getOutputStream();
                    PrintStream ps = new PrintStream(os);
                    ps.print(queryString);
                    ps.close();
                    huc.connect();
                    ++tries;
                    status = DASSequenceDB.tolerantIntHeader(huc, "X-DAS-Status");
                    if (status == 200) break block14;
                    if (tries < 3) continue;
                    if (status == 0) {
                        throw new BioRuntimeException("Not a DAS server: " + fURL.toString());
                    }
                    if (status != 200) break;
                }
                throw new BioRuntimeException("DAS error (status code = " + status + ") fetching " + fURL.toString() + " with query " + queryString);
            }
            String contentEncoding = huc.getContentEncoding();
            InputStream inStream = huc.getInputStream();
            if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
                inStream = new GZIPInputStream(inStream);
            }
            InputSource is = new InputSource(inStream);
            is.setSystemId(fURL.toString());
            DASFeaturesHandler dfh = new DASFeaturesHandler(this.ticketsBySegment, this, fetchEncoding);
            XMLReader parser = DASSequence.nonvalidatingSAXParser();
            parser.setContentHandler(new SAX2StAXAdaptor(dfh));
            parser.parse(is);
            this.doneTickets = dfh.getDoneTickets();
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
        catch (SAXException ex) {
            throw new ParseException(ex, "Error parsing XML from " + fURL);
        }
        finally {
            DAS.completedActivity(this);
        }
    }

    private class DASSegmentHandler
    extends StAXContentHandlerBase {
        private SeqIOListener siol;
        private int level = 0;

        public DASSegmentHandler(SeqIOListener siol, String fetchEncoding) {
            this.siol = siol;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            ++this.level;
            if (this.level == 1) {
                try {
                    String segVersion;
                    String segStop;
                    this.siol.startSequence();
                    String segStart = attrs.getValue("start");
                    if (segStart != null) {
                        this.siol.addSequenceProperty("sequence.start", segStart);
                    }
                    if ((segStop = attrs.getValue("stop")) != null) {
                        this.siol.addSequenceProperty("sequence.stop", segStop);
                    }
                    if ((segVersion = attrs.getValue("version")) == null) return;
                    this.siol.addSequenceProperty("sequence.version", segVersion);
                    return;
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
            } else if (localName.equals("featureSet")) {
                XFFFeatureSetHandler xffh = new XFFFeatureSetHandler();
                xffh.setFeatureListener(this.siol);
                xffh.addFeatureHandler(new ElementRecognizer.ByLocalName("componentFeature"), ComponentFeatureHandler.COMPONENTFEATURE_HANDLER_FACTORY);
                xffh.addDetailHandler(new ElementRecognizer.ByNSName("http://www.biojava.org/dazzle", "links"), DASLinkHandler.LINKDETAIL_HANDLER_FACTORY);
                dm.delegate(xffh);
                return;
            } else {
                if (!localName.equals("FEATURE")) throw new SAXException("Expecting an XFF featureSet or DASGFF FEATURE, but got " + localName);
                dm.delegate(new DASGFFFeatureHandler(this.siol));
            }
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            if (this.level == 1) {
                try {
                    this.siol.endSequence();
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
            }
            --this.level;
        }
    }

    private class DASFeaturesHandler
    extends StAXContentHandlerBase {
        private boolean inDocument = false;
        private Map ticketsBySegment;
        private FeatureRequestManager.Ticket thisTicket;
        private List doneTickets = new ArrayList();
        private String fetchEncoding;
        private Object trigger;

        public List getDoneTickets() {
            return this.doneTickets;
        }

        public DASFeaturesHandler(Map ticketsBySegment, Object trigger, String fetchEncoding) {
            this.ticketsBySegment = ticketsBySegment;
            this.trigger = trigger;
            this.fetchEncoding = fetchEncoding;
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (!this.inDocument) {
                this.inDocument = true;
            } else if (localName.equals("SEGMENT")) {
                String segID = attrs.getValue("id");
                if (segID == null) {
                    throw new SAXException("Missing segment ID");
                }
                Segment seg = new Segment(segID);
                this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(seg);
                if (this.thisTicket == null) {
                    int start = Integer.parseInt(attrs.getValue("start"));
                    int stop = Integer.parseInt(attrs.getValue("stop"));
                    seg = new Segment(segID, start, stop);
                    this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(seg);
                    if (this.thisTicket == null) {
                        throw new SAXException("Response segment " + segID + ":" + start + "," + stop + " wasn't requested");
                    }
                    segID = segID + ":" + start + "," + stop;
                }
                this.ticketsBySegment.remove(seg);
                dm.delegate(new DASSegmentHandler(((FeatureRequestManager.FeatureTicket)this.thisTicket).getOutputListener(), this.fetchEncoding));
            } else if (localName.equals("segmentNotAnnotated") || localName.equals("SEGMENTUNKNOWN")) {
                String segID = attrs.getValue("id");
                if (segID == null) {
                    throw new SAXException("Missing segment ID");
                }
                Segment seg = new Segment(segID);
                this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(new Segment(segID));
                if (this.thisTicket == null) {
                    int start = Integer.parseInt(attrs.getValue("start"));
                    int stop = Integer.parseInt(attrs.getValue("stop"));
                    seg = new Segment(segID, start, stop);
                    this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsBySegment.get(seg);
                    if (this.thisTicket == null) {
                        throw new SAXException("Response segment " + segID + ":" + start + "," + stop + " wasn't requested");
                    }
                }
                this.ticketsBySegment.remove(seg);
                SeqIOListener siol = ((FeatureRequestManager.FeatureTicket)this.thisTicket).getOutputListener();
                try {
                    siol.startSequence();
                    siol.endSequence();
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
                this.thisTicket.setAsFetched();
                this.doneTickets.add(this.thisTicket);
            } else if (localName.equals("segmentError") || localName.equals("SEGMENTERROR")) {
                String segID = attrs.getValue("id");
                String segError = attrs.getValue("error");
                throw new SAXException("Error " + segError + " fetching " + segID);
            }
        }

        public void endTree() throws SAXException {
            for (Map.Entry me : this.ticketsBySegment.entrySet()) {
                Segment seg = (Segment)me.getKey();
                System.err.println("*** Not got anything back for segment " + seg.toString());
                SeqIOListener siol = ((FeatureRequestManager.FeatureTicket)me.getValue()).getOutputListener();
                try {
                    siol.startSequence();
                    siol.endSequence();
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
            }
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            if (localName.equals("SEGMENT")) {
                this.thisTicket.setAsFetched();
                this.doneTickets.add(this.thisTicket);
                DAS.activityProgress(this.trigger, this.doneTickets.size(), this.ticketsBySegment.size());
            }
        }
    }
}

