/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.phred;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.program.phred.PhredTools;
import org.biojava.bio.program.phred.Qualitative;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class PhredSequence
extends SimpleSequence
implements Qualitative {
    public PhredSequence(SymbolList phredSequence, String name, String urn, Annotation anno) throws IllegalAlphabetException {
        super(phredSequence, urn, name, anno);
        if (this.getAlphabet() != PhredTools.getPhredAlphabet()) {
            throw new IllegalAlphabetException("Cannot build a PhredSequence using a " + phredSequence.getAlphabet().getName() + " SymbolList.");
        }
    }

    public SymbolList getQuality() {
        SimpleSymbolList qual = new SimpleSymbolList(IntegerAlphabet.getSubAlphabet(0, 99));
        for (int i = 1; i < this.length() + 1; ++i) {
            try {
                qual.addSymbol(PhredTools.integerSymbolFromPhred(this.symbolAt(i)));
                continue;
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("PhredTools.integerSymbolFromPhred() has returned a symbol not in this SymbolLists alphabet", ise);
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Cannot construct symbol list as it has becomed locked?", cve);
            }
        }
        return qual;
    }

    public SymbolList getDNA() {
        SimpleSymbolList dna = new SimpleSymbolList(DNATools.getDNA());
        for (int i = 1; i < this.length() + 1; ++i) {
            try {
                dna.addSymbol(PhredTools.dnaSymbolFromPhred(this.symbolAt(i)));
                continue;
            }
            catch (ChangeVetoException cve) {
                throw new BioError("Cannot construct symbol list as it has becomed locked?", cve);
            }
            catch (IllegalSymbolException ise) {
                throw new BioError("PhredTools.dnaSymbolFromPhred() has returned a symbol not in the DNA alphabet", ise);
            }
        }
        return dna;
    }

    public Symbol getQualityAt(int index) throws IndexOutOfBoundsException {
        try {
            return PhredTools.integerSymbolFromPhred(this.symbolAt(index));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Something has gone badly wrong with the Phred Alphabet!", ise);
        }
    }

    public Symbol getDNAAt(int index) throws IndexOutOfBoundsException {
        try {
            return PhredTools.dnaSymbolFromPhred(this.symbolAt(index));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Something has gone badly wrong with the Phred Alphabet!", ise);
        }
    }
}

