/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.FetchURL;
import org.biojava.bio.seq.io.EmblLikeFormat;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.symbol.Alphabet;

public class SwissprotSequenceDB {
    private static SequenceFormat format = new EmblLikeFormat();
    private static String DBName = "swiss-prot";
    private boolean IOExceptionFound = false;

    protected SequenceFormat getSequenceFormat() {
        return format;
    }

    protected Alphabet getAlphabet() {
        return ProteinTools.getTAlphabet();
    }

    protected URL getAddress(String id) throws MalformedURLException {
        String defaultReturnFormat = "";
        FetchURL seqURL = new FetchURL(DBName, defaultReturnFormat);
        String baseurl = seqURL.getbaseURL();
        String url = baseurl + id;
        return new URL(url);
    }

    public String getName() {
        return DBName;
    }

    public Sequence getSequence(String id) throws BioException {
        try {
            this.IOExceptionFound = false;
            URL queryURL = this.getAddress(id);
            DataInputStream in = new DataInputStream(queryURL.openStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            SequenceIterator seqI = SeqIOTools.readSwissprot(reader);
            return seqI.nextSequence();
        }
        catch (Exception e) {
            System.out.println(e.toString());
            this.IOExceptionFound = true;
            return null;
        }
    }

    public boolean checkIOException() {
        return this.IOExceptionFound;
    }
}

