/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.RemoteFeature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.impl.LazyFilterFeatureHolder;
import org.biojava.bio.seq.projection.ProjectedFeatureHolder;
import org.biojava.bio.seq.projection.Projection;
import org.biojava.bio.seq.projection.ReparentContext;
import org.biojava.bio.seq.projection.TranslateFlipContext;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.ontology.InvalidTermException;
import org.biojava.ontology.Term;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SubSequence
implements Sequence,
Serializable {
    private final Sequence parent;
    private final SymbolList symbols;
    private final String name;
    private final String uri;
    private final Annotation annotation;
    private final RangeLocation parentLocation;
    private transient ProjectedFeatureHolder features;
    private transient ChangeSupport changeSupport;
    private transient ChangeListener seqListener;
    protected transient ChangeForwarder annotationForwarder;

    private void allocChangeSupport() {
        if (this.seqListener == null) {
            this.installSeqListener();
        }
        this.changeSupport = new ChangeSupport();
    }

    private void installSeqListener() {
        this.seqListener = new ChangeListener(){

            public void preChange(ChangeEvent cev) throws ChangeVetoException {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePreChangeEvent(this.makeChainedEvent(cev));
                }
            }

            public void postChange(ChangeEvent cev) {
                if (SubSequence.this.changeSupport != null) {
                    SubSequence.this.changeSupport.firePostChangeEvent(this.makeChainedEvent(cev));
                }
            }

            private ChangeEvent makeChainedEvent(ChangeEvent cev) {
                return new ChangeEvent(SubSequence.this, FeatureHolder.FEATURES, null, null, cev);
            }
        };
        this.parent.addChangeListener(this.seqListener, FeatureHolder.FEATURES);
    }

    public SubSequence(Sequence seq, int start, int end, String name) {
        this.parent = seq;
        this.parentLocation = new RangeLocation(start, end);
        this.symbols = seq.subList(start, end);
        this.name = name;
        this.uri = seq.getURN() + "?start=" + start + ";end=" + end;
        this.annotation = seq.getAnnotation();
    }

    public SubSequence(Sequence seq, int start, int end) {
        this(seq, start, end, seq.getName() + " (" + start + " - " + end + ")");
    }

    public Symbol symbolAt(int pos) {
        return this.symbols.symbolAt(pos);
    }

    public Alphabet getAlphabet() {
        return this.symbols.getAlphabet();
    }

    public SymbolList subList(int start, int end) {
        return this.symbols.subList(start, end);
    }

    public String seqString() {
        return this.symbols.seqString();
    }

    public String subStr(int start, int end) {
        return this.symbols.subStr(start, end);
    }

    public List toList() {
        return this.symbols.toList();
    }

    public int length() {
        return this.symbols.length();
    }

    public Iterator iterator() {
        return this.symbols.iterator();
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit SubSequences");
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getFeatures().filter(ff, recurse);
    }

    public FeatureHolder filter(FeatureFilter ff) {
        return this.getFeatures().filter(ff);
    }

    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    public Feature createFeature(Feature.Template templ) throws BioException, ChangeVetoException {
        return this.getFeatures().createFeature(templ);
    }

    public void removeFeature(Feature f) throws ChangeVetoException, BioException {
        this.getFeatures().removeFeature(f);
    }

    public FeatureFilter getSchema() {
        return this.getFeatures().getSchema();
    }

    protected ProjectedFeatureHolder getFeatures() {
        if (this.features == null) {
            ProjectedFeatureHolder clipped = new ProjectedFeatureHolder(new SubProjectedFeatureContext(this.parent, this.parentLocation));
            this.features = new ProjectedFeatureHolder(new TranslateFlipContext(this, clipped, -this.parentLocation.getMin() + 1));
        }
        return this.features;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.uri;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Sequence getSequence() {
        return this.parent;
    }

    public int getStart() {
        return this.parentLocation.getMin();
    }

    public int getEnd() {
        return this.parentLocation.getMax();
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.allocChangeSupport();
        }
        if (this.annotationForwarder == null && ct == Annotatable.ANNOTATION) {
            this.annotationForwarder = new ChangeForwarder.Retyper(this, this.changeSupport, Annotation.PROPERTY);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotatable.ANNOTATION);
        }
        this.changeSupport.addChangeListener(cl, ct);
    }

    public void addChangeListener(ChangeListener cl) {
        this.addChangeListener(cl, ChangeType.UNKNOWN);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            this.changeSupport.removeChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.removeChangeListener(cl, ChangeType.UNKNOWN);
    }

    public boolean isUnchanging(ChangeType ct) {
        return this.parent.isUnchanging(ct);
    }

    public static class SubProjectedFeatureContext
    extends ReparentContext {
        private static final FeatureFilter REMOTE_FILTER = new FeatureFilter.ByClass(RemoteFeature.class);
        private static RemoteFeature.Resolver resolver = new RemoteFeature.Resolver(){

            public Feature resolve(RemoteFeature rFeat) throws IllegalIDException, BioException {
                if (!(rFeat instanceof SubRemote)) {
                    throw new BioException("Unable to resolve feature: " + rFeat);
                }
                return rFeat.getRemoteFeature();
            }
        };
        private final RangeLocation parentLocation;
        private final FeatureFilter remoteLocationFilter;
        private final FeatureFilter clippingFilter;

        private SubProjectedFeatureContext(FeatureHolder wrapped, RangeLocation parentLocation) {
            super(FeatureHolder.EMPTY_FEATURE_HOLDER, new LazyFilterFeatureHolder(wrapped, FilterUtils.overlapsLocation(parentLocation)));
            this.parentLocation = parentLocation;
            this.remoteLocationFilter = new FeatureFilter.Not(FilterUtils.containedByLocation(parentLocation));
            this.clippingFilter = FilterUtils.overlapsLocation(parentLocation);
        }

        public Location projectLocation(Location toTransform) {
            if (LocationTools.overlaps(this.parentLocation, toTransform) && !LocationTools.contains(this.parentLocation, toTransform)) {
                toTransform = this.fuzzyize(toTransform);
            }
            return toTransform;
        }

        public Feature projectFeature(Feature origFeat) {
            if (this.remoteLocationFilter.accept(origFeat)) {
                Location loc = this.fuzzyize(origFeat.getLocation());
                List regions = this.makeRegions(origFeat.getLocation(), origFeat.getSequence().getName());
                origFeat = new SubRemote(origFeat, loc, regions);
            }
            return super.projectFeature(origFeat);
        }

        public Feature revertFeature(Feature projFeat) {
            Feature origFeat = super.revertFeature(projFeat);
            if (!(origFeat instanceof Projection) && origFeat instanceof SubRemote) {
                origFeat = ((SubRemote)origFeat).getRemoteFeature();
            }
            return origFeat;
        }

        public FeatureHolder projectChildFeatures(Feature f, FeatureHolder parent) {
            return new LazyFilterFeatureHolder(super.projectChildFeatures(f, parent), this.clippingFilter);
        }

        private Location fuzzyize(Location loc) {
            ArrayList<Location> locList = new ArrayList<Location>();
            Iterator i = loc.blockIterator();
            while (i.hasNext()) {
                boolean fuzzyRight;
                Location l = (Location)i.next();
                if (!LocationTools.overlaps(this.parentLocation, l)) continue;
                boolean fuzzyLeft = l.getMin() < this.parentLocation.getMin();
                boolean bl = fuzzyRight = l.getMax() > this.parentLocation.getMax();
                if (fuzzyLeft || fuzzyRight) {
                    locList.add(new FuzzyLocation(Math.min(l.getMin(), this.parentLocation.getMin()), Math.max(l.getMax(), this.parentLocation.getMax()), Math.max(l.getMin(), this.parentLocation.getMin()), Math.min(l.getMax(), this.parentLocation.getMax()), fuzzyLeft, fuzzyRight, FuzzyLocation.RESOLVE_INNER));
                    continue;
                }
                locList.add(l);
            }
            return LocationTools.union(locList);
        }

        private List makeRegions(Location oldLoc, String seqID) {
            ArrayList<RemoteFeature.Region> regions = new ArrayList<RemoteFeature.Region>();
            Iterator i = oldLoc.blockIterator();
            while (i.hasNext()) {
                Location loc = (Location)i.next();
                if (!LocationTools.overlaps(loc, this.parentLocation)) {
                    regions.add(new RemoteFeature.Region(loc, seqID, true));
                    continue;
                }
                if (LocationTools.contains(this.parentLocation, loc)) {
                    regions.add(new RemoteFeature.Region(loc, null, false));
                    continue;
                }
                Location remote = LocationTools.subtract(loc, this.parentLocation);
                Location local = LocationTools.subtract(this.parentLocation, loc);
                RemoteFeature.Region remoteR = new RemoteFeature.Region(remote, seqID, true);
                RemoteFeature.Region localR = new RemoteFeature.Region(local, null, false);
                if (remote.getMin() < local.getMin()) {
                    regions.add(remoteR);
                    regions.add(localR);
                    continue;
                }
                regions.add(localR);
                regions.add(remoteR);
            }
            return regions;
        }

        protected FilterUtils.FilterTransformer getReverter() {
            final FilterUtils.FilterTransformer delegate = super.getReverter();
            return new FilterUtils.FilterTransformer(){

                public FeatureFilter transform(FeatureFilter filt) {
                    if (filt.equals(REMOTE_FILTER)) {
                        filt = SubProjectedFeatureContext.this.remoteLocationFilter;
                    }
                    filt = new FeatureFilter.And(filt, FilterUtils.overlapsLocation(SubProjectedFeatureContext.this.parentLocation));
                    filt = delegate.transform(filt);
                    return filt;
                }
            };
        }

        protected FilterUtils.FilterTransformer getTransformer() {
            return super.getTransformer();
        }

        private class SubRemote
        implements RemoteFeature {
            private final Feature wrapped;
            private final Location loc;
            private final List regionList;

            public SubRemote(Feature wrapped, Location loc, List regionList) {
                this.wrapped = wrapped;
                this.loc = loc;
                this.regionList = regionList;
            }

            public Location getLocation() {
                return this.loc;
            }

            public void setLocation(Location loc) throws ChangeVetoException {
                throw new ChangeVetoException("Can't set location: " + loc + " on " + this);
            }

            public List getRegions() {
                return this.regionList;
            }

            public RemoteFeature.Resolver getResolver() {
                return resolver;
            }

            public Feature getRemoteFeature() {
                return this.wrapped;
            }

            public StrandedFeature.Strand getStrand() {
                if (this.wrapped instanceof StrandedFeature) {
                    return ((StrandedFeature)this.wrapped).getStrand();
                }
                return StrandedFeature.UNKNOWN;
            }

            public void setStrand(StrandedFeature.Strand strand) throws ChangeVetoException {
                if (!(this.wrapped instanceof StrandedFeature)) {
                    throw new ChangeVetoException("Can't set strand. The underlying feature is not stranded: " + this.wrapped);
                }
                ((StrandedFeature)this.wrapped).setStrand(strand);
            }

            public String getType() {
                return this.wrapped.getType();
            }

            public void setType(String type) throws ChangeVetoException {
                this.wrapped.setType(type);
            }

            public Term getTypeTerm() {
                return this.wrapped.getTypeTerm();
            }

            public void setTypeTerm(Term t) throws ChangeVetoException, InvalidTermException {
                this.wrapped.setTypeTerm(t);
            }

            public Term getSourceTerm() {
                return this.wrapped.getSourceTerm();
            }

            public void setSourceTerm(Term t) throws ChangeVetoException, InvalidTermException {
                this.wrapped.setSourceTerm(t);
            }

            public String getSource() {
                return this.wrapped.getSource();
            }

            public void setSource(String source) throws ChangeVetoException {
                this.wrapped.setSource(source);
            }

            public SymbolList getSymbols() {
                return this.wrapped.getSymbols();
            }

            public FeatureHolder getParent() {
                return this.wrapped.getParent();
            }

            public Sequence getSequence() {
                return this.wrapped.getSequence();
            }

            public Feature.Template makeTemplate() {
                return this.wrapped.makeTemplate();
            }

            public int countFeatures() {
                return this.wrapped.countFeatures();
            }

            public Iterator features() {
                return this.wrapped.features();
            }

            public FeatureHolder filter(FeatureFilter fc, boolean recurse) {
                return this.wrapped.filter(fc, recurse);
            }

            public FeatureHolder filter(FeatureFilter filter) {
                return this.wrapped.filter(filter);
            }

            public Feature createFeature(Feature.Template ft) throws BioException, ChangeVetoException {
                return this.wrapped.createFeature(ft);
            }

            public void removeFeature(Feature f) throws ChangeVetoException, BioException {
                this.wrapped.removeFeature(f);
            }

            public boolean containsFeature(Feature f) {
                return this.wrapped.containsFeature(f);
            }

            public FeatureFilter getSchema() {
                return this.wrapped.getSchema();
            }

            public void addChangeListener(ChangeListener cl) {
                this.wrapped.addChangeListener(cl);
            }

            public void addChangeListener(ChangeListener cl, ChangeType ct) {
                this.wrapped.addChangeListener(cl, ct);
            }

            public void removeChangeListener(ChangeListener cl) {
                this.wrapped.removeChangeListener(cl);
            }

            public void removeChangeListener(ChangeListener cl, ChangeType ct) {
                this.wrapped.removeChangeListener(cl, ct);
            }

            public boolean isUnchanging(ChangeType ct) {
                return this.wrapped.isUnchanging(ct);
            }

            public Annotation getAnnotation() {
                return this.wrapped.getAnnotation();
            }
        }
    }
}

