/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomIterator;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.PDBParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HetatomImpl
implements Group {
    public static final String type = "hetatm";
    Map<String, Object> properties;
    long id;
    boolean pdb_flag = false;
    String pdb_name = null;
    String pdb_code = null;
    List<Atom> atoms = new ArrayList<Atom>();
    Chain parent = null;

    public HetatomImpl() {
        this.properties = new HashMap<String, Object>();
    }

    @Override
    public boolean has3D() {
        return this.pdb_flag;
    }

    @Override
    public void setPDBFlag(boolean flag) {
        this.pdb_flag = flag;
    }

    @Override
    public String getPDBCode() {
        return this.pdb_code;
    }

    @Override
    public void setPDBCode(String pdb) {
        this.pdb_code = pdb;
    }

    @Override
    public void setPDBName(String s) throws PDBParseException {
        this.pdb_name = s;
    }

    @Override
    public String getPDBName() {
        return this.pdb_name;
    }

    @Override
    public void addAtom(Atom atom) {
        atom.setParent(this);
        this.atoms.add(atom);
        if (atom.getCoords() != null) {
            this.setPDBFlag(true);
        }
    }

    @Override
    public void clearAtoms() {
        this.atoms.clear();
        this.setPDBFlag(false);
    }

    @Override
    public int size() {
        return this.atoms.size();
    }

    @Override
    public List<Atom> getAtoms() {
        return this.atoms;
    }

    @Override
    public void setAtoms(List<Atom> atoms) {
        for (Atom a : atoms) {
            a.setParent(this);
        }
        this.atoms = atoms;
        if (atoms.size() > 0) {
            this.pdb_flag = true;
        }
    }

    @Override
    public Atom getAtom(String name) throws StructureException {
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = this.atoms.get(i);
            if (!atom.getName().equals(name)) continue;
            return atom;
        }
        throw new StructureException(" No atom " + name + " in group " + this.pdb_name + " " + this.pdb_code + " !");
    }

    @Override
    public Atom getAtom(int position) throws StructureException {
        if (position < 0 || position >= this.atoms.size()) {
            throw new StructureException("No atom found at position " + position);
        }
        Atom a = this.atoms.get(position);
        return a;
    }

    @Override
    public boolean hasAtom(String name) {
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = this.atoms.get(i);
            if (!atom.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getType() {
        return type;
    }

    public String toString() {
        String str = "Hetatom " + this.pdb_code + " " + this.pdb_name + " " + this.pdb_flag;
        if (this.pdb_flag) {
            str = str + "atoms: " + this.atoms.size();
        }
        return str;
    }

    @Override
    public boolean hasAminoAtoms() {
        String[] atoms = this.getType().equals("amino") & this.getPDBName().equals("GLY") ? new String[]{"N", "CA", "C", "O"} : new String[]{"N", "CA", "C", "O", "CB"};
        for (int i = 0; i < atoms.length; ++i) {
            if (this.hasAtom(atoms[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Iterator<Atom> iterator() {
        AtomIterator iter = new AtomIterator(this);
        return iter;
    }

    @Override
    public Object clone() {
        HetatomImpl n = new HetatomImpl();
        n.setPDBFlag(this.has3D());
        n.setPDBCode(this.getPDBCode());
        try {
            n.setPDBName(this.getPDBName());
        }
        catch (PDBParseException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            Atom atom = this.atoms.get(i);
            n.addAtom((Atom)atom.clone());
        }
        return n;
    }

    @Override
    public void setParent(Chain parent) {
        this.parent = parent;
    }

    @Override
    public Chain getParent() {
        return this.parent;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }
}

