/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.utils.Unchangeable;
import org.biojavax.CrossRef;
import org.biojavax.RichAnnotation;
import org.biojavax.SimpleRichAnnotation;

public class SimpleCrossRef
extends Unchangeable
implements CrossRef {
    private RichAnnotation notes = new SimpleRichAnnotation();
    private String accession;
    private String dbname;
    private int version;
    private Integer id;

    public SimpleCrossRef(String dbname, String accession, int version) {
        if (dbname == null) {
            throw new IllegalArgumentException("Database name cannot be null");
        }
        if (accession == null) {
            throw new IllegalArgumentException("Accession cannot be null");
        }
        this.accession = accession;
        this.dbname = dbname;
        this.version = version;
    }

    public SimpleCrossRef(String dbname, String accession, Integer version) {
        this(dbname, accession, (int)version);
    }

    protected SimpleCrossRef() {
    }

    public Annotation getAnnotation() {
        return this.notes;
    }

    public Set getNoteSet() {
        return this.notes.getNoteSet();
    }

    public void setNoteSet(Set notes) {
        this.notes.setNoteSet(notes);
    }

    public String getAccession() {
        return this.accession;
    }

    void setAccession(String accession) {
        this.accession = accession;
    }

    public String getDbname() {
        return this.dbname;
    }

    void setDbname(String dbname) {
        this.dbname = dbname;
    }

    public int getVersion() {
        return this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public int compareTo(Object o) {
        if (this.dbname == null) {
            return -1;
        }
        CrossRef them = (CrossRef)o;
        if (!this.dbname.equals(them.getDbname())) {
            return this.dbname.compareTo(them.getDbname());
        }
        if (!this.accession.equals(them.getAccession())) {
            return this.accession.compareTo(them.getAccession());
        }
        return this.version - them.getVersion();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CrossRef)) {
            return false;
        }
        if (this.dbname == null) {
            return false;
        }
        CrossRef them = (CrossRef)obj;
        return this.dbname.equals(them.getDbname()) && this.accession.equals(them.getAccession()) && this.version == them.getVersion();
    }

    public int hashCode() {
        int code = 17;
        if (this.dbname == null) {
            return code;
        }
        code = 37 * code + this.dbname.hashCode();
        code = 37 * code + this.accession.hashCode();
        code = 37 * code + this.version;
        return code;
    }

    public String toString() {
        return this.getDbname() + ":" + this.getAccession() + "." + this.getVersion();
    }

    Integer getId() {
        return this.id;
    }

    void setId(Integer id) {
        this.id = id;
    }
}

