/*
 * Decompiled with CFR 0.152.
 */
package projects.talen;

import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.sequences.Sequence;
import java.util.HashMap;
import projects.talen.LimitedSortedList;
import projects.talen.MatchFinder;
import projects.tals.TALgetterDiffSM;

public class InfixMatchFinder
extends MatchFinder
implements Cloneable {
    private DataSet ds;
    private int infixLength;
    private int[] powers;
    private TALgetterDiffSM model;
    private HashMap<MatchFinder.HashEntry, Object[]> preps;

    public InfixMatchFinder(DataSet ds, int infixLength, TALgetterDiffSM model) {
        this.ds = ds;
        this.infixLength = infixLength;
        this.powers = new int[infixLength];
        if ((int)model.getAlphabetContainer().getAlphabetLengthAt(0) != 4) {
            throw new RuntimeException();
        }
        this.powers[0] = 1;
        int i = 1;
        while (i < infixLength) {
            this.powers[i] = this.powers[i - 1] * 4;
            ++i;
        }
        this.model = model;
        try {
            this.model.fix();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.preps = new HashMap();
    }

    public InfixMatchFinder clone() throws CloneNotSupportedException {
        InfixMatchFinder clone = (InfixMatchFinder)super.clone();
        clone.model = this.model.clone();
        clone.scoreHash = (HashMap)this.scoreHash.clone();
        clone.scoreHashRc = (HashMap)this.scoreHashRc.clone();
        return clone;
    }

    public void setDataSet(DataSet ds) {
        this.ds = ds;
        this.reset();
    }

    public synchronized Object[] getPreps(Sequence tal, double thresh) {
        Object[] prep = this.preps.get(new MatchFinder.HashEntry(tal, thresh, 0, false));
        if (prep == null) {
            prep = this.prepare(this.model, tal, this.infixLength, thresh);
            if (this.preps.size() > 6) {
                this.preps.clear();
            }
            this.preps.put(new MatchFinder.HashEntry(tal, thresh, 0, false), prep);
        }
        return prep;
    }

    @Override
    public LimitedSortedList<MatchFinder.Match> getScoresAbove(Sequence tal, double thresh, int cap, boolean capBest, boolean rc) {
        MatchFinder.HashEntry en = new MatchFinder.HashEntry(tal, thresh, cap, capBest);
        LimitedSortedList<MatchFinder.Match> list = null;
        list = this.getHashed(en, rc);
        if (list == null) {
            Object[] prep = this.getPreps(tal, thresh);
            boolean[] bools = (boolean[])prep[1];
            double[] scores = (double[])prep[0];
            boolean[] bools2 = (boolean[])prep[3];
            double[] scores2 = (double[])prep[2];
            double rest = (Double)prep[4];
            list = new LimitedSortedList(cap);
            int i = 0;
            while (i < this.ds.getNumberOfElements()) {
                Sequence seq = this.ds.getElementAt(i);
                if (rc) {
                    try {
                        seq = seq.reverseComplement();
                    }
                    catch (Exception e) {
                        throw new RuntimeException();
                    }
                }
                this.fillMatches(seq, i, tal, bools, bools2, scores, scores2, rest, thresh, rc, list, 0, seq.getLength() - tal.getLength() + 1);
                ++i;
            }
            this.hash(en, list, rc);
        }
        return list;
    }

    public void fillMatches(Sequence seq, int i, Sequence tal, boolean[] bools, boolean[] bools2, double[] scores, double[] scores2, double rest, double thresh, boolean rc, LimitedSortedList<MatchFinder.Match> list, int start, int end) {
        int length = this.infixLength;
        int order = this.model.getOrder();
        int length2 = Math.min(length, tal.getLength() + 1 - length + order);
        int ll2 = tal.getLength() - length - length2 + order + 1;
        boolean llb = ll2 > 0;
        int pl = this.powers[length - 1];
        int pl2 = this.powers[length2 - 1];
        double thresh2 = thresh - rest;
        int off2 = length + length2 - order;
        if (end - start > 0) {
            int idx = this.getIndex(seq, start, length);
            int idx3 = this.getIndex(seq, start + length - order - 1, length2);
            int j = start + 1;
            int k = start + length + length2 - order - 1;
            int l = start + length;
            while (j < end) {
                double sc;
                idx3 = idx3 / 4 + seq.discreteVal(k) * pl2;
                if (bools[idx] && bools2[idx3] && (sc = scores[idx] + scores2[idx3]) >= thresh2) {
                    if (llb) {
                        sc += this.model.getPartialLogScoreFor(tal, seq, j - 1, off2, ll2);
                    }
                    if (sc >= thresh && list.checkInsert(sc)) {
                        if (rc) {
                            list.insert(sc, new MatchFinder.Match(i, seq.getLength() - j - tal.getLength(), rc));
                        } else {
                            list.insert(sc, new MatchFinder.Match(i, j - 1, rc));
                        }
                    }
                }
                idx = idx / 4 + seq.discreteVal(l) * pl;
                ++j;
                ++k;
                ++l;
            }
        }
    }

    private Object[] prepare(TALgetterDiffSM model, Sequence tal, int length, double thresh) {
        double[] scs = new double[tal.getLength() + 1];
        model.getBestPossibleScore(tal, scs);
        double rest = 0.0;
        int i = length;
        while (i < scs.length) {
            rest += scs[i];
            ++i;
        }
        int al = (int)model.getAlphabetContainer().getAlphabetLengthAt(0);
        boolean[] bools = new boolean[(int)Math.pow(al, length)];
        double[] scores = new double[bools.length];
        DiscreteSequenceEnumerator dse = new DiscreteSequenceEnumerator(model.getAlphabetContainer(), length, false);
        int i2 = 0;
        while (dse.hasMoreElements()) {
            Object seq = dse.nextElement();
            double sc = model.getPartialLogScoreFor(tal, (Sequence)seq, 0, 0, length);
            bools[i2] = sc + rest >= thresh;
            scores[i2] = sc;
            ++i2;
        }
        rest = 0.0;
        int j = 0;
        while (j < length) {
            rest += scs[j];
            ++j;
        }
        int order = Math.max(model.getOrder(), 1);
        int length2 = Math.min(length, tal.getLength() + 1 - length + order);
        double rest2 = 0.0;
        int j2 = length + length2 - order;
        while (j2 < scs.length) {
            rest += scs[j2];
            rest2 += scs[j2];
            ++j2;
        }
        tal = tal.getSubSequence(length - order - 1);
        length = length2;
        boolean[] bools2 = new boolean[(int)Math.pow(al, length)];
        double[] scores2 = new double[bools2.length];
        dse = new DiscreteSequenceEnumerator(model.getAlphabetContainer(), length, false);
        i2 = 0;
        while (dse.hasMoreElements()) {
            Object seq = dse.nextElement();
            try {
                seq = Sequence.create(((Sequence)seq).getAlphabetContainer(), "T" + ((Sequence)seq).toString());
            }
            catch (Exception dnh) {
                dnh.printStackTrace();
                throw new RuntimeException();
            }
            double sc = model.getPartialLogScoreFor(tal, (Sequence)seq, 0, order + 1, length - order);
            bools2[i2] = sc + rest >= thresh;
            scores2[i2] = sc;
            ++i2;
        }
        return new Object[]{scores, bools, scores2, bools2, rest2};
    }

    private final int getIndex(Sequence seq, int off, int length) {
        int idx = 0;
        int i = 0;
        while (i < length) {
            idx += seq.discreteVal(off + i) * this.powers[i];
            ++i;
        }
        return idx;
    }
}

