/*
 * Decompiled with CFR 0.152.
 */
package projects.talen;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;
import projects.talen.LimitedSortedList;
import projects.talen.MatchFinder;
import projects.tals.TALgetterDiffSM;

public class PartialStringTree
extends MatchFinder {
    private DataSet data;
    private int maxDepth;
    private int startDepth;
    private TALgetterDiffSM model;
    private Node root;
    private int n;

    public PartialStringTree(DataSet ds, int startDepth, int maxDepth, TALgetterDiffSM model) {
        this.data = ds;
        this.maxDepth = maxDepth;
        this.startDepth = startDepth;
        this.model = model;
        try {
            this.model.fix();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.construct();
    }

    private void construct() {
        this.root = new InnerNode((int)this.data.getAlphabetContainer().getAlphabetLengthAt(0));
        this.n = 0;
        int i = 0;
        while (i < this.data.getNumberOfElements()) {
            Sequence seq = this.data.getElementAt(i);
            int j = 0;
            while (j < seq.getLength() - this.maxDepth + 1) {
                this.root.add(seq, i, j, 0, this.startDepth);
                ++this.n;
                ++j;
            }
            ++i;
        }
        this.root.prune(10);
        System.gc();
        this.root.expand(20, this.maxDepth, 0);
        System.gc();
    }

    public void countChildren(int[] count) {
        ((InnerNode)this.root).countChildren(count);
    }

    @Override
    public LimitedSortedList<MatchFinder.Match> getScoresAbove(Sequence tal, double t, int cap, boolean capBest, boolean rc) {
        MatchFinder.HashEntry en = new MatchFinder.HashEntry(tal, t, cap, capBest);
        LimitedSortedList<MatchFinder.Match> l = this.getHashed(en, rc);
        if (l == null) {
            l = new LimitedSortedList(cap);
            int[] currSeq = new int[tal.getLength() + 1];
            double[] scs = new double[tal.getLength() + 1];
            double sc = this.model.getBestPossibleScore(tal, scs);
            if (rc) {
                int i = 1;
                while (i < scs.length) {
                    int n = i;
                    scs[n] = scs[n] + scs[i - 1];
                    ++i;
                }
                this.root.getScoresAboveRc(tal, t, currSeq, scs, 0, this.model, 0.0, l, cap, capBest);
            } else {
                int i = scs.length - 2;
                while (i >= 0) {
                    int n = i;
                    scs[n] = scs[n] + scs[i + 1];
                    --i;
                }
                this.root.getScoresAbove(tal, t, currSeq, scs, 0, this.model, 0.0, l, cap, capBest);
            }
            this.hash(en, l, rc);
        }
        return l;
    }

    public int getNumberOfSequences() {
        return this.n;
    }

    public void printN(PrintWriter printWriter) {
        this.root.printN(printWriter);
        printWriter.close();
    }

    private static class ArrayPool {
        static HashMap<Integer, LinkedList<int[]>> map = new HashMap();
        static LinkedList<LinkedList<int[]>> pool = new LinkedList();

        private ArrayPool() {
        }

        public static int[] getArrayOfSize(int size, int[] old) {
            LinkedList<int[]> l = map.get(size);
            int[] res = null;
            if (l != null && l.size() > 0) {
                res = l.pop();
                if (l.size() == 0) {
                    LinkedList<int[]> el = map.remove(size);
                    if (pool.size() < 20) {
                        pool.add(el);
                    }
                }
            } else {
                res = new int[size];
            }
            System.arraycopy(old, 0, res, 0, old.length);
            LinkedList<Object> l2 = map.get(old.length);
            if (l2 == null) {
                l2 = pool.size() > 0 ? pool.pop() : new LinkedList();
                map.put(old.length, l2);
            }
            if (l2.size() < 10) {
                l2.add(old);
            }
            return res;
        }
    }

    private class InnerNode
    extends Node {
        private Node[] children;

        private InnerNode(int alphabetSize) {
            this.children = new Node[alphabetSize];
            this.n = 0;
        }

        public int fill(int[] seqIdxs, int[] starts, int off) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    if (this.children[i] instanceof InnerNode) {
                        off = ((InnerNode)this.children[i]).fill(seqIdxs, starts, off);
                    } else {
                        Leaf l = (Leaf)this.children[i];
                        int j = 0;
                        while (j < l.n) {
                            seqIdxs[off + j] = l.seqIdxs[j];
                            starts[off + j] = l.starts[j];
                            ++j;
                        }
                        off += l.n;
                    }
                }
                ++i;
            }
            return off;
        }

        @Override
        protected void add(Sequence seq, int seqIdx, int start, int depth, int length) {
            int c = seq.discreteVal(start + depth);
            if (this.children[c] == null) {
                this.children[c] = depth + 1 == length ? new Leaf() : new InnerNode(this.children.length);
            }
            ++this.n;
            this.children[c].add(seq, seqIdx, start, depth + 1, length);
        }

        public void countChildren(int[] counts) {
            int c = 0;
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    ++c;
                    if (this.children[i] instanceof InnerNode) {
                        ((InnerNode)this.children[i]).countChildren(counts);
                    }
                }
                ++i;
            }
            int n = c;
            counts[n] = counts[n] + 1;
        }

        @Override
        public void printN(PrintWriter wr) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    this.children[i].printN(wr);
                }
                ++i;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    sb.append(String.valueOf(i) + ": " + this.children[i].toString() + "\n");
                }
                ++i;
            }
            sb.append("\n");
            return sb.toString();
        }

        @Override
        public void getScoresAbove(Sequence tal, double t, int[] currSeq, double[] bestSc, int depth, TALgetterDiffSM model, double currScore, LimitedSortedList<MatchFinder.Match> list, int cap, boolean capBest) {
            if (list.getLength() >= cap && !capBest) {
                return;
            }
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    currSeq[depth] = i;
                    double tempScore = currScore + model.getPartialLogScoreFor(tal, currSeq, 0, depth, 1);
                    if (list.getLength() >= cap && t < list.getWorstScore()) {
                        t = list.getWorstScore();
                    }
                    if (tempScore + bestSc[depth + 1] >= t) {
                        this.children[i].getScoresAbove(tal, t, currSeq, bestSc, depth + 1, model, tempScore, list, cap, capBest);
                    }
                }
                ++i;
            }
        }

        @Override
        public void getScoresAboveRc(Sequence tal, double t, int[] currSeq, double[] bestSc, int depth, TALgetterDiffSM model, double currScore, LimitedSortedList<MatchFinder.Match> list, int cap, boolean capBest) {
            if (list.getLength() >= cap && !capBest) {
                return;
            }
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    if (list.getLength() >= cap && t < list.getWorstScore()) {
                        t = list.getWorstScore();
                    }
                    currSeq[currSeq.length - depth - 1] = this.children.length - i - 1;
                    int order = model.getOrder();
                    double tempScore = 0.0;
                    if (depth >= order) {
                        tempScore = currScore + model.getPartialLogScoreFor(tal, currSeq, 0, tal.getLength() - depth + order, 1);
                    }
                    if (depth <= order || tempScore + bestSc[depth + 1 - order] >= t) {
                        this.children[i].getScoresAboveRc(tal, t, currSeq, bestSc, depth + 1, model, tempScore, list, cap, capBest);
                    }
                }
                ++i;
            }
        }

        @Override
        public void prune(int minN) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    if (this.children[i].n > minN) {
                        this.children[i].prune(minN);
                    } else if (this.children[i] instanceof InnerNode) {
                        this.children[i] = new Leaf((InnerNode)this.children[i]);
                    }
                }
                ++i;
            }
        }

        @Override
        public Node expand(int minN, int maxLength, int depth) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null && this.children[i].n > minN) {
                    this.children[i] = this.children[i].expand(minN, maxLength, depth + 1);
                }
                ++i;
            }
            return this;
        }
    }

    private class Leaf
    extends Node {
        private int[] seqIdxs;
        private int[] starts;

        private Leaf() {
            this.n = 0;
        }

        public Leaf(InnerNode node) {
            this.seqIdxs = new int[node.n];
            this.starts = new int[node.n];
            int n = node.fill(this.seqIdxs, this.starts, 0);
            if (n != node.n) {
                throw new RuntimeException();
            }
            this.n = n;
        }

        @Override
        protected void add(Sequence seq, int seqIdx, int start, int depth, int length) {
            if (this.seqIdxs == null) {
                this.seqIdxs = new int[1];
                this.starts = new int[1];
            }
            if (this.n + 1 == this.seqIdxs.length) {
                this.seqIdxs = ArrayPool.getArrayOfSize((int)Math.ceil((double)this.seqIdxs.length * 1.1), this.seqIdxs);
                this.starts = ArrayPool.getArrayOfSize((int)Math.ceil((double)this.starts.length * 1.1), this.starts);
            }
            this.seqIdxs[this.n] = seqIdx;
            this.starts[this.n] = start;
            ++this.n;
        }

        @Override
        public void getScoresAbove(Sequence tal, double t, int[] currSeq, double[] bestSc, int depth, TALgetterDiffSM model, double currScore, LimitedSortedList<MatchFinder.Match> list, int cap, boolean capBest) {
            if (list.getLength() >= cap && !capBest) {
                return;
            }
            int i = 0;
            while (i < this.n) {
                Sequence full = PartialStringTree.this.data.getElementAt(this.seqIdxs[i]);
                if (full.getLength() - this.starts[i] >= tal.getLength() + 1) {
                    double temp = model.getPartialLogScoreFor(tal, full, this.starts[i], depth, tal.getLength() + 1 - depth);
                    if ((temp += currScore) > t) {
                        list.insert(temp, new MatchFinder.Match(this.seqIdxs[i], this.starts[i], false));
                    }
                }
                ++i;
            }
        }

        @Override
        public void getScoresAboveRc(Sequence tal, double t, int[] currSeq, double[] bestSc, int depth, TALgetterDiffSM model, double currScore, LimitedSortedList<MatchFinder.Match> list, int cap, boolean capBest) {
            if (list.getLength() >= cap && !capBest) {
                return;
            }
            int i = 0;
            while (i < this.n) {
                Sequence full = null;
                try {
                    full = PartialStringTree.this.data.getElementAt(this.seqIdxs[i]).reverseComplement();
                }
                catch (OperationNotSupportedException doesnothappen) {
                    throw new RuntimeException();
                }
                int start = full.getLength() - this.starts[i] - tal.getLength() - 1;
                if (start >= 0 && full.getLength() - start >= tal.getLength() + 1) {
                    int order = model.getOrder();
                    double temp = model.getPartialLogScoreFor(tal, full, start, 0, tal.getLength() + 2 - depth + order - 1);
                    if ((temp += currScore) > t) {
                        list.insert(temp, new MatchFinder.Match(this.seqIdxs[i], this.starts[i], true));
                    }
                }
                ++i;
            }
        }

        @Override
        public void printN(PrintWriter wr) {
            wr.println(this.n);
        }

        @Override
        public void prune(int minN) {
        }

        @Override
        public Node expand(int minN, int maxLength, int depth) {
            if (this.n > minN) {
                InnerNode temp = new InnerNode((int)PartialStringTree.this.data.getAlphabetContainer().getAlphabetLengthAt(0));
                int i = 0;
                while (i < this.n) {
                    temp.add(PartialStringTree.this.data.getElementAt(this.seqIdxs[i]), this.seqIdxs[i], this.starts[i], depth, maxLength);
                    ++i;
                }
                temp.prune(minN);
                return temp;
            }
            return this;
        }
    }

    private abstract class Node {
        protected int n;

        private Node() {
        }

        protected abstract void add(Sequence var1, int var2, int var3, int var4, int var5);

        public abstract void getScoresAbove(Sequence var1, double var2, int[] var4, double[] var5, int var6, TALgetterDiffSM var7, double var8, LimitedSortedList<MatchFinder.Match> var10, int var11, boolean var12);

        public abstract void getScoresAboveRc(Sequence var1, double var2, int[] var4, double[] var5, int var6, TALgetterDiffSM var7, double var8, LimitedSortedList<MatchFinder.Match> var10, int var11, boolean var12);

        public abstract void printN(PrintWriter var1);

        public abstract void prune(int var1);

        public abstract Node expand(int var1, int var2, int var3);
    }
}

