/*
 * Decompiled with CFR 0.152.
 */
package supplementary.codeExamples;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasureParameterSet;
import de.jstacs.io.FileManager;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.REnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;

public class Classification {
    private static double[] getSortedValues(String fName) throws Exception {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(fName));
        DoubleList dlist = new DoubleList();
        while ((line = r.readLine()) != null) {
            dlist.add(Double.parseDouble(line));
        }
        r.close();
        double[] res = dlist.toArray();
        Arrays.sort(res);
        return res;
    }

    public static void main(String[] args) throws Exception {
        double[] fg = Classification.getSortedValues(args[0]);
        double[] bg = Classification.getSortedValues(args[1]);
        boolean plot = args.length > 2;
        REnvironment r = null;
        try {
            try {
                AbstractPerformanceMeasure[] m;
                if (plot) {
                    switch (args.length) {
                        case 3: {
                            r = new REnvironment(args[2], null, null);
                            break;
                        }
                        case 5: {
                            r = new REnvironment(args[2], args[3], args[4]);
                            break;
                        }
                        default: {
                            System.out.println("You have to specify the server and optionally username and login.");
                        }
                    }
                }
                AbstractPerformanceMeasureParameterSet performance = AbstractPerformanceMeasureParameterSet.createFilledParameters(plot, 0.999, 0.95, 0.95, 1.0);
                boolean isNumeric = true;
                AbstractPerformanceMeasure[] abstractPerformanceMeasureArray = m = performance.getAllMeasures();
                int n = m.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractPerformanceMeasure current = abstractPerformanceMeasureArray[n2];
                    ResultSet rs = current.compute(fg, bg);
                    if (rs != null) {
                        System.out.println(rs);
                        if (plot) {
                            int i = 0;
                            while (i < rs.getNumberOfResults()) {
                                Result res = rs.getResultAt(i);
                                if (res instanceof AbstractScoreBasedClassifier.DoubleTableResult) {
                                    AbstractScoreBasedClassifier.DoubleTableResult dtr = (AbstractScoreBasedClassifier.DoubleTableResult)res;
                                    String name = dtr.getName().replaceAll(" ", "-");
                                    r.plotToPDF(AbstractScoreBasedClassifier.DoubleTableResult.getPlotCommands(r, dtr.getName(), dtr).toString(), "./" + name + ".pdf", true);
                                    FileManager.writeFile(new File("./" + name + ".xml"), (CharSequence)dtr.toXML());
                                }
                                ++i;
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (r != null) {
                    r.close();
                }
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }
}

