/*
 * Decompiled with CFR 0.152.
 */
package supplementary.codeExamples;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.assessment.RepeatedHoldOutAssessParameterSet;
import de.jstacs.classifiers.assessment.RepeatedHoldOutExperiment;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.msp.MSPClassifier;
import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.classifiers.performanceMeasures.PerformanceMeasure;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.results.ListResult;
import de.jstacs.results.ResultSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.VariableLengthWrapperTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.BayesianNetworkTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.BayesianNetworkTrainSMParameterSet;
import de.jstacs.utils.REnvironment;
import java.io.PrintWriter;

public class MiMBExample {
    public static void main(String[] args) throws Exception {
        AbstractPerformanceMeasureParameterSet mp;
        MSPClassifier cll;
        TrainSMBasedClassifier cl;
        DNADataSet bgData;
        DNADataSet fgData;
        String home;
        block12: {
            home = String.valueOf(args[0]) + System.getProperty("file.separator");
            fgData = new DNADataSet(String.valueOf(home) + "foreground.fa");
            bgData = new DNADataSet(String.valueOf(home) + "background.fa");
            BayesianNetworkTrainSMParameterSet pars = new BayesianNetworkTrainSMParameterSet(fgData.getAlphabetContainer(), fgData.getElementLength(), 4.0, "fg model", StructureLearner.ModelType.IMM, 0, StructureLearner.LearningType.ML_OR_MAP);
            BayesianNetworkTrainSM fgModel = new BayesianNetworkTrainSM(pars);
            BayesianNetworkTrainSMParameterSet pars2 = new BayesianNetworkTrainSMParameterSet(fgData.getAlphabetContainer(), fgData.getElementLength(), 1024.0, "bg model", StructureLearner.ModelType.IMM, 0, StructureLearner.LearningType.ML_OR_MAP);
            AbstractTrainableStatisticalModel bgModel = new BayesianNetworkTrainSM(pars2);
            bgModel = new VariableLengthWrapperTrainSM(bgModel);
            cl = new TrainSMBasedClassifier(fgModel, bgModel);
            cl.train(fgData, bgData);
            BayesianNetworkDiffSMParameterSet parsD = new BayesianNetworkDiffSMParameterSet(fgData.getAlphabetContainer(), fgData.getElementLength(), 4.0, true, new InhomogeneousMarkov(0));
            BayesianNetworkDiffSM fgFun = new BayesianNetworkDiffSM(parsD);
            BayesianNetworkDiffSMParameterSet parsDbg = new BayesianNetworkDiffSMParameterSet(fgData.getAlphabetContainer(), fgData.getElementLength(), 1024.0, true, new InhomogeneousMarkov(0));
            BayesianNetworkDiffSM bgFun = new BayesianNetworkDiffSM(parsDbg);
            GenDisMixClassifierParameterSet clPars = new GenDisMixClassifierParameterSet(fgData.getAlphabetContainer(), fgData.getElementLength(), 20, 1.0E-6, 1.0E-6, 1.0, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 1);
            cll = new MSPClassifier(clPars, (LogPrior)new CompositeLogPrior(), fgFun, bgFun);
            cll.train(fgData, bgData);
            DataSet[] fgSplit = MiMBExample.bisect(fgData, fgData.getElementLength());
            DataSet[] bgSplit = MiMBExample.bisect(bgData, fgData.getElementLength());
            DataSet fgTest = fgSplit[1];
            DataSet bgTest = bgSplit[1];
            cl.train(fgSplit[0], bgSplit[0]);
            mp = AbstractPerformanceMeasureParameterSet.createFilledParameters(false, 0.999, 0.95, 0.95, 1.0);
            ResultSet rs = cl.evaluate((AbstractPerformanceMeasureParameterSet<? extends PerformanceMeasure>)mp, true, fgTest, bgTest);
            System.out.println(rs);
            AbstractScoreBasedClassifier.DoubleTableResult roc = (AbstractScoreBasedClassifier.DoubleTableResult)rs.getResultAt(rs.findColumn("ROC curve"));
            AbstractScoreBasedClassifier.DoubleTableResult pr = (AbstractScoreBasedClassifier.DoubleTableResult)rs.getResultAt(rs.findColumn("PR curve"));
            REnvironment re = null;
            try {
                try {
                    re = new REnvironment("localhost", "", "");
                    re.voidEval("p<-palette();p[8]<-\"gray66\";palette(p);");
                    re.plotToPDF(AbstractScoreBasedClassifier.DoubleTableResult.getPlotCommands(re, null, new int[]{8}, roc).toString(), 4.0, 4.5, String.valueOf(home) + "roc.pdf", true);
                    re.plotToPDF(AbstractScoreBasedClassifier.DoubleTableResult.getPlotCommands(re, null, new int[]{8}, pr).toString(), 4.0, 4.5, String.valueOf(home) + "pr.pdf", true);
                }
                catch (Exception e) {
                    System.out.println("could not plot the curves");
                    if (re != null) {
                        re.close();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (re != null) {
                    re.close();
                }
                throw throwable;
            }
            if (re != null) {
                re.close();
            }
        }
        MiMBExample.separator();
        mp = AbstractPerformanceMeasureParameterSet.createFilledParameters();
        RepeatedHoldOutAssessParameterSet parsA = new RepeatedHoldOutAssessParameterSet(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_SYMBOLS, fgData.getElementLength(), true, 1000, new double[]{0.1, 0.1});
        RepeatedHoldOutExperiment exp = new RepeatedHoldOutExperiment(cl, cll);
        ListResult lr = exp.assess((NumericalPerformanceMeasureParameterSet)mp, parsA, fgData, bgData);
        System.out.println(lr);
        MiMBExample.separator();
        cll.train(fgData, bgData);
        DNADataSet promoters = new DNADataSet(String.valueOf(home) + "human_promoters.fa");
        int si = 0;
        int id = 0;
        double max = Double.NEGATIVE_INFINITY;
        PrintWriter out = new PrintWriter(String.valueOf(home) + "/allscores.txt");
        int i = 0;
        for (Sequence seq : promoters) {
            int l = 0;
            while (l < seq.getLength() - cll.getLength() + 1) {
                Sequence sub = seq.getSubSequence(l, cll.getLength());
                double llr = cll.getScore(sub, 0) - cll.getScore(sub, 1);
                out.print(String.valueOf(llr) + "\t");
                if (llr > max) {
                    max = llr;
                    si = i;
                    id = l;
                }
                ++l;
            }
            out.println();
            ++i;
        }
        out.close();
        Sequence bestSequence = promoters.getElementAt(si);
        out = new PrintWriter(String.valueOf(home) + "/scores.txt");
        out.println(bestSequence.toString("\t", id - 30, id + 30));
        int l = id - 30;
        while (l < id + 30) {
            Sequence site = bestSequence.getSubSequence(l, cll.getLength());
            out.print(String.valueOf(cll.getScore(site, 0) - cll.getScore(site, 1)) + "\t");
            ++l;
        }
        out.println();
        out.close();
    }

    private static DataSet[] bisect(DataSet data, int l) throws Exception {
        int mid = data.getNumberOfElements() / 2;
        return new DataSet[]{MiMBExample.getSubDataSet(data, 0, mid, "train", l), MiMBExample.getSubDataSet(data, mid, data.getNumberOfElements(), "test", l)};
    }

    private static DataSet getSubDataSet(DataSet data, int start, int end, String annotation, int l) throws Exception {
        Sequence[] seqs = new Sequence[end - start];
        int i = 0;
        while (i < seqs.length) {
            seqs[i] = data.getElementAt(i + start);
            ++i;
        }
        return new DataSet(new DataSet(annotation, seqs), l);
    }

    private static void separator() {
        int i = 0;
        while (i < 50) {
            System.out.print("=");
            ++i;
        }
        System.out.println();
    }
}

