/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.assessment;

import de.jstacs.DataType;
import de.jstacs.classifiers.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.ArrayList;

public class KFoldCrossValidationAssessParameterSet
extends ClassifierAssessmentAssessParameterSet {
    public KFoldCrossValidationAssessParameterSet() throws UnsupportedOperationException, ParameterException {
        this.addParameters();
    }

    public KFoldCrossValidationAssessParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public KFoldCrossValidationAssessParameterSet(DataSet.PartitionMethod dataSplitMethod, int elementLength, boolean exceptionIfMPNotComputable, int k) throws ParameterException {
        super(elementLength, exceptionIfMPNotComputable);
        this.addParameters();
        ((Parameter)this.parameters.get("k")).setValue(new Integer(k));
        ((Parameter)this.parameters.get(DataSet.PartitionMethod.class.getSimpleName())).setValue((Object)dataSplitMethod);
    }

    private void addParameters() throws ParameterException {
        try {
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "k", "Defines the folds of a KFoldCrossValidation.", true, new NumberValidator<Integer>(2, Integer.MAX_VALUE))});
        }
        catch (SimpleParameter.DatatypeNotValidException doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
        this.parameters.add(new Parameter[]{new EnumParameter(DataSet.PartitionMethod.class, "The method used to compute the percentages of the partitions", true)});
    }

    public int getK() {
        return (Integer)this.getParameterForName("k").getValue();
    }

    public DataSet.PartitionMethod getDataSplitMethod() {
        return (DataSet.PartitionMethod)((EnumParameter)this.getParameterForName(DataSet.PartitionMethod.class.getSimpleName())).getValue();
    }

    public ArrayList<Result> getAnnotation() {
        ArrayList<Result> l = new ArrayList<Result>(2);
        l.add(new NumericalResult("k", "The folds of a KFoldCrossValidation.", this.getK()));
        l.add(new CategoricalResult("dataSplitMethod", "Describes how data should be splitted in ClassifierAssessment.evaluateClassifier())", this.getDataSplitMethod().name()));
        return l;
    }
}

