/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import javax.naming.OperationNotSupportedException;

public abstract class MultiDimensionalSequence<T>
extends Sequence<T> {
    protected Sequence[] content;

    public MultiDimensionalSequence(SequenceAnnotation[] seqAn, Sequence ... sequence) throws WrongLengthException, WrongAlphabetException {
        super(sequence[0].getAlphabetContainer(), seqAn);
        int l = sequence[0].getLength();
        int s = 1;
        while (s < sequence.length) {
            if (sequence[s].getLength() != l) {
                throw new WrongLengthException("Creating an multi-dimensional sequence, all sequence have to have the same length");
            }
            if (!sequence[s].getAlphabetContainer().checkConsistency(this.alphabetCon)) {
                throw new WrongAlphabetException("All sequences have to have the same alphabet.");
            }
            ++s;
        }
        this.content = (Sequence[])sequence.clone();
    }

    @Override
    public double continuousVal(int pos) {
        return this.content[0].continuousVal(pos);
    }

    @Override
    public int discreteVal(int pos) {
        return this.content[0].discreteVal(pos);
    }

    protected abstract MultiDimensionalSequence<T> getInstance(SequenceAnnotation[] var1, Sequence ... var2) throws WrongLengthException, WrongAlphabetException;

    @Override
    protected MultiDimensionalSequence<T> flatCloneWithoutAnnotation() {
        try {
            return this.getInstance(null, this.content);
        }
        catch (WrongLengthException doesNotHappen) {
            throw new RuntimeException(doesNotHappen.getMessage());
        }
        catch (WrongAlphabetException doesNotHappen) {
            throw new RuntimeException(doesNotHappen.getMessage());
        }
    }

    @Override
    protected Object getEmptyRepresentation() {
        StringBuffer[] rep = new StringBuffer[this.content.length];
        int i = 0;
        while (i < this.content.length) {
            rep[i] = new StringBuffer();
            ++i;
        }
        return rep;
    }

    @Override
    protected void addToRepresentation(Object representation, int pos, String delim) {
        int i = 0;
        while (i < this.content.length) {
            ((StringBuffer[])representation)[i].append(String.valueOf(this.alphabetCon.getSymbol(pos, this.content[i].continuousVal(pos))) + delim);
            ++i;
        }
    }

    @Override
    protected String getStringRepresentation(Object representation) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < this.content.length) {
            res.append(((StringBuffer[])representation)[i]);
            res.append("\n");
            ++i;
        }
        return res.toString();
    }

    @Override
    public int getLength() {
        return this.content[0].getLength();
    }

    @Override
    public boolean isMultiDimensional() {
        return true;
    }

    @Override
    public MultiDimensionalSequence<T> complement(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isReverseComplementable()) {
            Sequence[] compContent = new Sequence[this.content.length];
            int s = 0;
            while (s < this.content.length) {
                compContent[s] = this.content[s].complement(start, end);
                ++s;
            }
            try {
                return this.getInstance(null, compContent);
            }
            catch (WrongLengthException doesNotHappen) {
                throw new RuntimeException(doesNotHappen.getMessage());
            }
            catch (WrongAlphabetException doesNotHappen) {
                throw new RuntimeException(doesNotHappen.getMessage());
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    @Override
    public MultiDimensionalSequence<T> reverseComplement(int start, int end) throws OperationNotSupportedException {
        if (this.rc != null && start == 0 && end == this.getLength()) {
            return (MultiDimensionalSequence)this.rc;
        }
        if (this.alphabetCon.isReverseComplementable()) {
            try {
                Sequence[] revCompContent = new Sequence[this.content.length];
                int s = 0;
                while (s < this.content.length) {
                    revCompContent[s] = this.content[s].reverseComplement(start, end);
                    ++s;
                }
                MultiDimensionalSequence<T> revComp = this.getInstance(null, revCompContent);
                if (start == 0 && end == this.getLength()) {
                    this.rc = revComp;
                    ((MultiDimensionalSequence)this.rc).rc = this;
                }
                return revComp;
            }
            catch (Exception e) {
                RuntimeException doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be reverse-complementable.");
    }

    @Override
    protected int hashCodeForPos(int pos) {
        int h = 0;
        int i = 0;
        while (i < this.content.length) {
            h = 31 * h + this.content[i].hashCodeForPos(pos);
            ++i;
        }
        return h;
    }

    public SequenceAnnotation[][] getAnnotations() {
        SequenceAnnotation[][] res = new SequenceAnnotation[this.content.length][];
        int i = 0;
        while (i < this.content.length) {
            res[i] = this.content[i].getAnnotation();
            ++i;
        }
        return res;
    }

    public int getNumberOfSequences() {
        return this.content.length;
    }

    public Sequence getSequence(int index) {
        return this.content[index];
    }
}

