/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.io.AbstractStringExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class StringExtractor
extends AbstractStringExtractor {
    private String[] strs;
    private int last;
    private int idx;
    private int anz;
    private boolean first;
    private StringBuffer current;

    private StringExtractor(int initSize, char ignore) throws IllegalArgumentException {
        super(ignore);
        if (initSize < 1) {
            throw new IllegalArgumentException("The initSize is too small.");
        }
        this.idx = 0;
        this.last = 0;
        this.strs = new String[initSize];
    }

    public StringExtractor(File file, int initSize) throws IOException, FileNotFoundException {
        this(file, initSize, '#');
    }

    public StringExtractor(File file, int initSize, char ignore) throws IOException, FileNotFoundException {
        this(file, initSize, ignore, file.getName());
    }

    public StringExtractor(File file, int initSize, String annotation) throws IOException, FileNotFoundException {
        this(file, initSize, '#', annotation);
    }

    public StringExtractor(File file, int initSize, char ignore, String annotation) throws IOException, FileNotFoundException {
        this(initSize, ignore);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String str = null;
        this.anz = 0;
        this.first = true;
        while ((str = reader.readLine()) != null) {
            this.insert(str);
        }
        if (this.anz > 0) {
            String string = ignore == '>' ? (this.current == null ? "" : this.current.toString()) : (this.strs[this.last++] = "");
        }
        if (this.current != null && this.current.length() > 0) {
            this.strs[this.last++] = this.current.toString();
            this.current.delete(0, this.current.length());
        }
        reader.close();
        this.annotation = annotation;
    }

    public StringExtractor(String content, int initSize, String annotation) {
        this(content, initSize, '#', annotation);
    }

    public StringExtractor(String content, int initSize, char ignore, String annotation) {
        this(initSize, ignore);
        StringTokenizer tok = new StringTokenizer(content, "\n");
        this.anz = 0;
        this.first = true;
        while (tok.hasMoreTokens()) {
            this.insert(tok.nextToken());
        }
        if (this.anz > 0) {
            this.strs[this.last++] = ignore == '>' ? (this.current == null ? "" : this.current.toString()) : "";
        } else if (this.current != null && this.current.length() > 0) {
            this.strs[this.last++] = this.current.toString();
            this.current.delete(0, this.current.length());
        }
        this.annotation = annotation;
    }

    private void expand() {
        String[] temp = new String[2 * this.strs.length];
        System.arraycopy(this.strs, 0, temp, 0, this.strs.length);
        this.strs = temp;
        temp = null;
    }

    @Override
    public String nextElement() {
        if (this.idx >= this.last) {
            throw new IndexOutOfBoundsException();
        }
        return this.strs[this.idx++];
    }

    @Override
    public boolean hasMoreElements() {
        return this.idx < this.last;
    }

    public int getNumberOfElements() {
        return this.last;
    }

    public String getElement(int idx) {
        if (idx < this.last) {
            return this.strs[idx];
        }
        throw new IndexOutOfBoundsException();
    }

    private void insert(String str) {
        if (this.ignorePattern.matcher(str).matches()) {
            if (this.ignore == '>') {
                if (!this.first) {
                    if (this.current != null) {
                        this.strs[this.last++] = this.current.toString();
                        this.current.delete(0, this.current.length());
                    } else {
                        this.strs[this.last++] = "";
                    }
                }
                this.anz = 1;
            } else {
                ++this.anz;
            }
        } else {
            this.anz = 0;
            if (this.ignore == '>') {
                if (this.current == null) {
                    this.current = new StringBuffer();
                }
                this.current.append(str);
            } else {
                this.strs[this.last++] = str;
            }
        }
        if (this.last == this.strs.length) {
            this.expand();
        }
        this.first = false;
    }
}

