/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.differentiable;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;

public abstract class AbstractDifferentiableSequenceScore
implements DifferentiableSequenceScore {
    protected static final Random r = new Random();
    protected AlphabetContainer alphabets;
    protected int length;

    public static final int getNumberOfStarts(DifferentiableSequenceScore[] score) {
        int starts = score[0].getNumberOfRecommendedStarts();
        int i = 1;
        while (i < score.length) {
            starts = Math.max(starts, score[i].getNumberOfRecommendedStarts());
            ++i;
        }
        return starts;
    }

    public AbstractDifferentiableSequenceScore(AlphabetContainer alphabets, int length) throws IllegalArgumentException {
        this.alphabets = alphabets;
        int l = alphabets.getPossibleLength();
        if (length < 0 || length != 0 && l != 0 && length != l) {
            throw new IllegalArgumentException("The given length could not be used. The length has to be not negative and has to match with the possible length defined by the AlphabetContainer.");
        }
        this.length = length;
    }

    public AbstractDifferentiableSequenceScore(StringBuffer xml) throws NonParsableException {
        this.alphabets = null;
        this.length = -1;
        this.fromXML(xml);
        if (this.alphabets == null) {
            throw new NonParsableException("AlphabetContainer could not be parsed.");
        }
        if (this.length < 0 || this.alphabets == null) {
            throw new NonParsableException("Length could not be parsed.");
        }
    }

    @Override
    public AbstractDifferentiableSequenceScore clone() throws CloneNotSupportedException {
        return (AbstractDifferentiableSequenceScore)super.clone();
    }

    protected abstract void fromXML(StringBuffer var1) throws NonParsableException;

    @Override
    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabets;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public final double getLogScoreFor(Sequence seq) {
        return this.getLogScoreFor(seq, 0);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int startpos, int endpos) throws WrongLengthException {
        if (endpos - startpos + 1 == this.length) {
            return this.getLogScoreFor(seq, startpos);
        }
        throw new WrongLengthException("The sequence length of " + (endpos - startpos + 1) + " is not supported by this instance.");
    }

    @Override
    public final double getLogScoreAndPartialDerivation(Sequence seq, IntList indices, DoubleList partialDer) {
        return this.getLogScoreAndPartialDerivation(seq, 0, indices, partialDer);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int startpos, int endpos, IntList indices, DoubleList partialDer) throws WrongLengthException {
        if (endpos - startpos + 1 == this.length) {
            return this.getLogScoreAndPartialDerivation(seq, startpos, indices, partialDer);
        }
        throw new WrongLengthException("The sequence length of " + (endpos - startpos + 1) + " is not supported by this instance.");
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 1;
    }

    @Override
    public double getInitialClassParam(double classProb) {
        return Math.log(classProb);
    }

    @Override
    public double[] getLogScoreFor(DataSet data) throws Exception {
        double[] res = new double[data.getNumberOfElements()];
        this.getLogScoreFor(data, res);
        return res;
    }

    @Override
    public void getLogScoreFor(DataSet data, double[] res) throws Exception {
        if (res.length != data.getNumberOfElements()) {
            throw new IllegalArgumentException("The array has wrong dimension.");
        }
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(data);
        int i = 0;
        while (i < res.length) {
            res[i] = this.getLogScoreFor(ei.nextElement());
            ++i;
        }
    }

    @Override
    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("model", "the xml representation of the model", this)});
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return new NumericalResultSet(new NumericalResult("number of parameters", "the number of parameters used in this instance to score sequences", this.getNumberOfParameters()));
    }

    public final String toString() {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(3);
        return this.toString(nf);
    }
}

