/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.VariableLengthDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public abstract class AbstractVariableLengthDiffSM
extends AbstractDifferentiableStatisticalModel
implements VariableLengthDiffSM {
    protected AbstractVariableLengthDiffSM(AlphabetContainer alphabets) {
        this(alphabets, 0);
    }

    protected AbstractVariableLengthDiffSM(AlphabetContainer alphabets, int length) {
        super(alphabets, length);
        if (!alphabets.isSimple() || !alphabets.isDiscrete()) {
            throw new IllegalArgumentException("The AlphabetContainer has to be simple and discrete.");
        }
    }

    protected AbstractVariableLengthDiffSM(StringBuffer source) throws NonParsableException {
        super(source);
    }

    @Override
    public double getLogNormalizationConstant() {
        return this.getLogNormalizationConstant(this.length);
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return this.getLogPartialNormalizationConstant(parameterIndex, this.length);
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        if (this.length != 0) {
            return this.getLogScoreFor(seq, start, start + this.length - 1);
        }
        return this.getLogScoreFor(seq, start, seq.getLength() - 1);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList dList) {
        if (this.length != 0) {
            return this.getLogScoreAndPartialDerivation(seq, start, start + this.length - 1, indices, dList);
        }
        return this.getLogScoreAndPartialDerivation(seq, start, seq.getLength() - 1, indices, dList);
    }

    @Override
    public abstract double getLogScoreFor(Sequence var1, int var2, int var3);

    @Override
    public abstract double getLogScoreAndPartialDerivation(Sequence var1, int var2, int var3, IntList var4, DoubleList var5);
}

