/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.MarkovRandomFieldDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.MixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.ExtendedZOOPSDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.UniformDurationDiffSM;

public class DifferentiableStatisticalModelFactory {
    public static BayesianNetworkDiffSM createPWM(AlphabetContainer con, int length, double ess) throws Exception {
        return DifferentiableStatisticalModelFactory.createInhomogeneousMarkovModel(con, length, ess, 0);
    }

    public static BayesianNetworkDiffSM createInhomogeneousMarkovModel(AlphabetContainer con, int length, double ess, int order) throws Exception {
        return new BayesianNetworkDiffSM(con, length, ess, true, new InhomogeneousMarkov(order));
    }

    public static HomogeneousMMDiffSM createHomogeneousMarkovModel(AlphabetContainer con, double ess, int order, int priorLength) {
        return new HomogeneousMMDiffSM(con, order, ess, priorLength);
    }

    public static StrandDiffSM createStrandModel(DifferentiableStatisticalModel model) throws CloneNotSupportedException, WrongAlphabetException {
        return new StrandDiffSM(model, 0.5, 10, true, StrandDiffSM.InitMethod.INIT_BOTH_STRANDS);
    }

    public static MixtureDiffSM createMixtureModel(DifferentiableStatisticalModel[] models) throws CloneNotSupportedException {
        return new MixtureDiffSM(10, true, models);
    }

    public static ExtendedZOOPSDiffSM createZOOPS(int length, DifferentiableStatisticalModel motif, HomogeneousDiffSM bg) throws Exception {
        return new ExtendedZOOPSDiffSM(false, length, 10, true, bg, motif, new UniformDurationDiffSM(0, length - motif.getLength() + 1), true);
    }

    public static MarkovRandomFieldDiffSM createMarkovRandomField(AlphabetContainer con, int length, String constraintType) {
        return new MarkovRandomFieldDiffSM(con, length, constraintType);
    }
}

