/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.localMixture;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.text.NumberFormat;
import java.util.Arrays;

public class SparseLocalInhomogeneousMixtureDiffSM
extends AbstractDifferentiableStatisticalModel
implements Mutable {
    private int components;
    private double ess;
    private double[] localMixtureScore;
    private double[][] ancestorScore;
    private double[][] depGrad;
    private double[][] componentMixtureParameters;
    private double[][][] ancestorMixtureParameters;
    private double[][] symbolParameters;
    private double[][][][] dependencyParameters;
    private double[] componentMixtureLogNorm;
    private double[][] ancestorMixtureLogNorm;
    private double[] symbolLogNorm;
    private double[][][] dependencyLogNorm;
    private double[][] componentMixturePotential;
    private double[][][] ancestorMixturePotential;
    private double[][] symbolPotential;
    private double[][][][] dependencyPotential;
    private int[] componentMixtureIndex;
    private int[][] ancestorMixtureIndex;
    private int[] symbolIndex;
    private int[][][] dependencyIndex;
    private int numParameter;
    private boolean max = false;
    private double q;
    private double[] e;
    private double[][] logGamma;
    private PriorType type;
    private static final String XML_TAG = "SLIM";

    public SparseLocalInhomogeneousMixtureDiffSM(AlphabetContainer alphabets, int length, int components, double ess, boolean max) throws IllegalArgumentException {
        this(alphabets, length, components, ess, max, 1.0, PriorType.BDeu);
    }

    public SparseLocalInhomogeneousMixtureDiffSM(AlphabetContainer alphabets, int length, int components, double ess, boolean max, double q, PriorType t) throws IllegalArgumentException {
        super(alphabets, length);
        if (!alphabets.isSimple()) {
            throw new IllegalArgumentException("check alphabet");
        }
        if (ess < 0.0) {
            throw new IllegalArgumentException("Check ess");
        }
        this.ess = ess;
        if (components < 1) {
            throw new IllegalArgumentException("Check number of local components");
        }
        this.components = components;
        this.type = t;
        this.q = q;
        this.max = max;
        int a = (int)alphabets.getAlphabetLengthAt(0);
        this.symbolParameters = new double[length][a];
        this.dependencyParameters = new double[length][][][];
        this.componentMixtureParameters = new double[length][];
        this.ancestorMixtureParameters = new double[length][][];
        int l = 0;
        while (l < length) {
            this.componentMixtureParameters[l] = new double[Math.min(l + 1, components)];
            this.dependencyParameters[l] = new double[this.componentMixtureParameters[l].length - 1][a][a];
            this.ancestorMixtureParameters[l] = new double[this.componentMixtureParameters[l].length - 1][l];
            ++l;
        }
        this.init();
    }

    public SparseLocalInhomogeneousMixtureDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    private void init() {
        this.localMixtureScore = new double[this.components];
        this.ancestorScore = new double[this.components][this.length - 1];
        this.e = new double[this.components];
        try {
            this.logGamma = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
            this.componentMixturePotential = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
            this.componentMixtureLogNorm = new double[this.length];
            this.componentMixtureIndex = new int[this.length];
            this.symbolPotential = (double[][])ArrayHandler.clone((Cloneable[])this.symbolParameters);
            this.symbolLogNorm = new double[this.length];
            this.symbolIndex = new int[this.length];
            this.ancestorMixturePotential = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureParameters);
            this.dependencyPotential = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyParameters);
            int a = (int)this.alphabets.getAlphabetLengthAt(0);
            this.dependencyLogNorm = new double[this.length][][];
            this.dependencyIndex = new int[this.length][][];
            this.ancestorMixtureLogNorm = new double[this.length][];
            this.ancestorMixtureIndex = new int[this.length][];
            int l = 0;
            while (l < this.length) {
                this.dependencyLogNorm[l] = new double[this.componentMixtureParameters[l].length - 1][a];
                this.dependencyIndex[l] = new int[this.componentMixtureParameters[l].length - 1][a];
                this.ancestorMixtureLogNorm[l] = new double[this.componentMixtureParameters[l].length - 1];
                this.ancestorMixtureIndex[l] = new int[this.componentMixtureParameters[l].length - 1];
                ++l;
            }
            this.depGrad = new double[a][a];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.precompute();
        this.numParameter = 0;
        int l = 0;
        while (l < this.length) {
            this.componentMixtureIndex[l] = this.numParameter;
            this.numParameter += this.componentMixtureParameters[l].length;
            this.symbolIndex[l] = this.numParameter;
            this.numParameter += this.symbolParameters[l].length;
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                this.ancestorMixtureIndex[l][c - 1] = this.numParameter;
                this.numParameter += this.ancestorMixtureParameters[l][c - 1].length;
                int b = 0;
                while (b < this.dependencyParameters[l][c - 1].length) {
                    this.dependencyIndex[l][c - 1][b] = this.numParameter;
                    this.numParameter += this.dependencyParameters[l][c - 1][b].length;
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        if (this.type == PriorType.Complex_Mixture) {
            this.precomputeLogGamma();
        }
    }

    private void precompute() {
        int l = 0;
        while (l < this.length) {
            this.componentMixtureLogNorm[l] = Normalisation.logSumNormalisation(this.componentMixtureParameters[l], 0, this.componentMixtureParameters[l].length, this.componentMixturePotential[l], 0);
            this.symbolLogNorm[l] = Normalisation.logSumNormalisation(this.symbolParameters[l], 0, this.symbolParameters[l].length, this.symbolPotential[l], 0);
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                this.ancestorMixtureLogNorm[l][c - 1] = Normalisation.logSumNormalisation(this.ancestorMixtureParameters[l][c - 1], 0, this.ancestorMixtureParameters[l][c - 1].length, this.ancestorMixturePotential[l][c - 1], 0);
                int b = 0;
                while (b < this.dependencyParameters[l][c - 1].length) {
                    this.dependencyLogNorm[l][c - 1][b] = Normalisation.logSumNormalisation(this.dependencyParameters[l][c - 1][b], 0, this.dependencyParameters[l][c - 1][b].length, this.dependencyPotential[l][c - 1][b], 0);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
    }

    @Override
    public SparseLocalInhomogeneousMixtureDiffSM clone() throws CloneNotSupportedException {
        SparseLocalInhomogeneousMixtureDiffSM clone = (SparseLocalInhomogeneousMixtureDiffSM)super.clone();
        clone.componentMixtureParameters = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixtureParameters);
        clone.ancestorMixtureParameters = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureParameters);
        clone.symbolParameters = (double[][])ArrayHandler.clone((Cloneable[])this.symbolParameters);
        clone.dependencyParameters = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyParameters);
        clone.componentMixtureLogNorm = (double[])this.componentMixtureLogNorm.clone();
        clone.ancestorMixtureLogNorm = (double[][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureLogNorm);
        clone.symbolLogNorm = (double[])this.symbolLogNorm.clone();
        clone.dependencyLogNorm = (double[][][])ArrayHandler.clone((Cloneable[])this.dependencyLogNorm);
        clone.componentMixturePotential = (double[][])ArrayHandler.clone((Cloneable[])this.componentMixturePotential);
        clone.ancestorMixturePotential = (double[][][])ArrayHandler.clone((Cloneable[])this.ancestorMixturePotential);
        clone.symbolPotential = (double[][])ArrayHandler.clone((Cloneable[])this.symbolPotential);
        clone.dependencyPotential = (double[][][][])ArrayHandler.clone((Cloneable[])this.dependencyPotential);
        clone.componentMixtureIndex = (int[])this.componentMixtureIndex.clone();
        clone.ancestorMixtureIndex = (int[][])ArrayHandler.clone((Cloneable[])this.ancestorMixtureIndex);
        clone.symbolIndex = (int[])this.symbolIndex.clone();
        clone.dependencyIndex = (int[][][])ArrayHandler.clone((Cloneable[])this.dependencyIndex);
        clone.localMixtureScore = (double[])this.localMixtureScore.clone();
        clone.ancestorScore = (double[][])ArrayHandler.clone((Cloneable[])this.ancestorScore);
        clone.depGrad = (double[][])ArrayHandler.clone((Cloneable[])this.depGrad);
        clone.e = (double[])this.e.clone();
        clone.logGamma = (double[][])ArrayHandler.clone((Cloneable[])this.logGamma);
        return clone;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double f = this.ess == 0.0 ? (double)(a * this.components) : this.ess;
        int l = 0;
        while (l < this.length) {
            if (this.type == PriorType.Complex_Mixture && this.componentMixtureParameters[l].length > 1) {
                int idx = (int)Math.floor(r.nextDouble() * (double)this.componentMixtureParameters[l].length);
                double v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
                Arrays.fill(this.e, v * f);
                this.e[idx] = this.q * f;
            } else {
                Arrays.fill(this.e, f / (double)this.componentMixtureParameters[l].length);
            }
            DirichletMRG.DEFAULT_INSTANCE.generateLog(this.symbolParameters[l], 0, this.symbolParameters[l].length, new FastDirichletMRGParams(this.e[0] / (double)a));
            if (this.componentMixtureParameters[l].length > 1) {
                DirichletMRG.DEFAULT_INSTANCE.generateLog(this.componentMixtureParameters[l], 0, this.componentMixtureParameters[l].length, new DirichletMRGParams(this.e));
                int c = 1;
                while (c < this.componentMixtureParameters[l].length) {
                    DirichletMRG.DEFAULT_INSTANCE.generateLog(this.ancestorMixtureParameters[l][c - 1], 0, l, new FastDirichletMRGParams(this.e[c] / (double)(this.componentMixtureParameters[l].length * l)));
                    FastDirichletMRGParams depPars = new FastDirichletMRGParams(this.e[c] / (double)(this.componentMixtureParameters[l].length * a * a));
                    int b = 0;
                    while (b < this.dependencyParameters[l][c - 1].length) {
                        DirichletMRG.DEFAULT_INSTANCE.generateLog(this.dependencyParameters[l][c - 1][b], 0, a, depPars);
                        ++b;
                    }
                    ++c;
                }
            }
            ++l;
        }
        this.precompute();
    }

    public void initializeFunctionFromIMM1(MarkovModelDiffSM model) throws Exception {
        double[] pars = model.getCurrentParameterValues();
        double[] marg = new double[(int)this.alphabets.getAlphabetLengthAt(0)];
        int i = 0;
        i = 0;
        while (i < marg.length) {
            marg[i] = pars[i];
            ++i;
        }
        Normalisation.logSumNormalisation(marg);
        int j = 0;
        while (j < this.symbolParameters[0].length) {
            this.symbolParameters[0][j] = Math.log(marg[j]);
            ++j;
        }
        int l = 1;
        while (l < model.getLength()) {
            int a;
            double[][] temp = new double[(int)this.alphabets.getAlphabetLengthAt(l - 1)][(int)this.alphabets.getAlphabetLengthAt(l)];
            int b = 0;
            while ((double)b < this.alphabets.getAlphabetLengthAt(l - 1)) {
                int a2 = 0;
                while ((double)a2 < this.alphabets.getAlphabetLengthAt(l)) {
                    temp[b][a2] = pars[i];
                    ++i;
                    ++a2;
                }
                ++b;
            }
            b = 0;
            while (b < temp.length) {
                Normalisation.logSumNormalisation(temp[b]);
                ++b;
            }
            double[] temp2 = new double[temp[0].length];
            int b2 = 0;
            while (b2 < temp.length) {
                a = 0;
                while (a < temp[b2].length) {
                    int n = a;
                    temp2[n] = temp2[n] + marg[b2] * temp[b2][a];
                    ++a;
                }
                ++b2;
            }
            b2 = 0;
            while (b2 < this.dependencyParameters[l][0].length) {
                a = 0;
                while (a < this.dependencyParameters[l][0][b2].length) {
                    this.dependencyParameters[l][0][b2][a] = Math.log(temp[b2][a]);
                    ++a;
                }
                ++b2;
            }
            this.componentMixtureParameters[l][0] = Math.log(0.5);
            this.componentMixtureParameters[l][1] = Math.log(0.5);
            Arrays.fill(this.ancestorMixtureParameters[l][0], Math.log(1.0 / (double)this.ancestorMixtureParameters[l][0].length));
            marg = temp2;
            int j2 = 0;
            while (j2 < this.symbolParameters[l].length) {
                this.symbolParameters[l][j2] = Math.log(marg[j2]);
                ++j2;
            }
            ++l;
        }
        this.precompute();
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        int l;
        Sequence s;
        int l2 = 0;
        while (l2 < this.length) {
            Arrays.fill(this.symbolParameters[l2], this.ess / (double)this.symbolParameters[l2].length);
            Arrays.fill(this.componentMixtureParameters[l2], 0.0);
            this.componentMixtureParameters[l2][0] = Math.log(this.q);
            int i = 1;
            while (i < this.componentMixtureParameters[l2].length) {
                this.componentMixtureParameters[l2][i] = Math.log((1.0 - this.q) / ((double)this.componentMixtureParameters[l2].length - 1.0));
                ++i;
            }
            int c = 1;
            while (c < this.componentMixtureParameters[l2].length) {
                Arrays.fill(this.ancestorMixtureParameters[l2][c - 1], 0.0);
                int b = 0;
                while (b < this.dependencyParameters[l2][c - 1].length) {
                    Arrays.fill(this.dependencyParameters[l2][c - 1][b], this.ess / (double)this.dependencyParameters[l2][c - 1].length / (double)this.dependencyParameters[l2][c - 1][b].length);
                    ++b;
                }
                ++c;
            }
            ++l2;
        }
        double w = 1.0;
        double all = this.ess;
        int i = 0;
        while (i < data[index].getNumberOfElements()) {
            if (weights != null && weights[index] != null) {
                w = weights[index][i];
            }
            all += w;
            s = data[index].getElementAt(i);
            l = 0;
            while (l < this.length) {
                double[] dArray = this.symbolParameters[l];
                int n = s.discreteVal(l);
                dArray[n] = dArray[n] + w;
                ++l;
            }
            ++i;
        }
        all = Math.log(all);
        int l3 = 0;
        while (l3 < this.length) {
            int i2 = 0;
            while (i2 < this.symbolParameters[l3].length) {
                this.symbolParameters[l3][i2] = Math.log(this.symbolParameters[l3][i2]) - all;
                ++i2;
            }
            ++l3;
        }
        i = 0;
        while (i < data[index].getNumberOfElements()) {
            if (weights != null && weights[index] != null) {
                w = weights[index][i];
            }
            all += w;
            s = data[index].getElementAt(i);
            l = 0;
            while (l < this.length) {
                int c = 1;
                while (c < this.componentMixtureParameters[l].length) {
                    double[] dArray = this.dependencyParameters[l][c - 1][s.discreteVal(l - c)];
                    int n = s.discreteVal(l);
                    dArray[n] = dArray[n] + w;
                    ++c;
                }
                ++l;
            }
            ++i;
        }
        l3 = 0;
        while (l3 < this.length) {
            int c = 1;
            while (c < this.componentMixtureParameters[l3].length) {
                int b = 0;
                while (b < this.dependencyParameters[l3][c - 1].length) {
                    Normalisation.sumNormalisation(this.dependencyParameters[l3][c - 1][b]);
                    int a = 0;
                    while (a < this.dependencyParameters[l3][c - 1][b].length) {
                        this.dependencyParameters[l3][c - 1][b][a] = Math.log(this.dependencyParameters[l3][c - 1][b][a]);
                        ++a;
                    }
                    ++b;
                }
                ++c;
            }
            ++l3;
        }
        this.precompute();
    }

    private double evaluatePosterior(DataSet data, double[] weight) {
        double ll = 0.0;
        int i = 0;
        while (i < data.getNumberOfElements()) {
            ll += this.getLogProbFor(data.getElementAt(i)) * weight[i];
            ++i;
        }
        return ll += this.getLogPriorTerm();
    }

    private double unifGamma(double e, int anz) {
        return (double)anz * Gamma.logOfGamma(e / (double)anz) - Gamma.logOfGamma(e);
    }

    private double precomputePartLogGamma(int l) {
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        double lg = 0.0;
        int i = 0;
        while (i < this.componentMixtureParameters[l].length) {
            lg += Gamma.logOfGamma(this.e[i]) * this.componentMixtureParameters[l][i];
            ++i;
        }
        lg -= Gamma.logOfGamma(this.ess);
        lg += this.unifGamma(this.e[0], this.symbolParameters[l].length);
        int c = 1;
        while (c < this.componentMixtureParameters[l].length) {
            lg += this.unifGamma(this.e[c], this.ancestorMixtureParameters[l][c - 1].length);
            int b = 0;
            while (b < this.dependencyParameters[l][c - 1].length) {
                lg += this.unifGamma(this.e[c] / (double)a, this.dependencyParameters[l][c - 1][b].length);
                ++b;
            }
            ++c;
        }
        return lg;
    }

    private void precomputeLogGamma() {
        int l = 0;
        while (l < this.length) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            Arrays.fill(this.e, v * this.ess);
            int i = 0;
            while (i < this.componentMixtureParameters[l].length) {
                this.e[i] = w * this.ess;
                double[] dArray = this.logGamma[l];
                int n = i;
                dArray[n] = dArray[n] + this.precomputePartLogGamma(l);
                this.e[i] = v * this.ess;
                ++i;
            }
            ++l;
        }
    }

    protected static final double logPrior(double ess, double[] parameter, double logNorm) {
        double res = 0.0;
        double e = ess / (double)parameter.length;
        int i = 0;
        while (i < parameter.length) {
            res += e * parameter[i];
            ++i;
        }
        return res - ess * logNorm;
    }

    private void setLogPriorTerm(int l, int index, double logP) {
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        this.localMixtureScore[index] = logP;
        int i = 0;
        while (i < this.componentMixtureParameters[l].length) {
            int n = index;
            this.localMixtureScore[n] = this.localMixtureScore[n] + this.e[i] * this.componentMixtureParameters[l][i];
            ++i;
        }
        int n = index;
        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
        int n2 = index;
        this.localMixtureScore[n2] = this.localMixtureScore[n2] + SparseLocalInhomogeneousMixtureDiffSM.logPrior(this.e[0], this.symbolParameters[l], this.symbolLogNorm[l]);
        int c = 1;
        while (c < this.componentMixtureParameters[l].length) {
            int n3 = index;
            this.localMixtureScore[n3] = this.localMixtureScore[n3] + SparseLocalInhomogeneousMixtureDiffSM.logPrior(this.e[c], this.ancestorMixtureParameters[l][c - 1], this.ancestorMixtureLogNorm[l][c - 1]);
            int b = 0;
            while (b < this.dependencyParameters[l][c - 1].length) {
                int n4 = index;
                this.localMixtureScore[n4] = this.localMixtureScore[n4] + SparseLocalInhomogeneousMixtureDiffSM.logPrior(this.e[c] / (double)a, this.dependencyParameters[l][c - 1][b], this.dependencyLogNorm[l][c - 1][b]);
                ++b;
            }
            ++c;
        }
    }

    @Override
    public double getLogPriorTerm() {
        double logPrior = 0.0;
        double logP = 0.0;
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        int l = 0;
        while (l < this.length) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            switch (this.type) {
                case BDeu: {
                    Arrays.fill(this.e, this.ess / (double)this.componentMixtureParameters[l].length);
                    this.setLogPriorTerm(l, 0, 1.0);
                    logPrior += this.localMixtureScore[0];
                    break;
                }
                case Complex_Mixture: {
                    Arrays.fill(this.e, v * this.ess);
                    int i = 0;
                    while (i < this.componentMixtureParameters[l].length) {
                        this.e[i] = w * this.ess;
                        this.setLogPriorTerm(l, i, logP);
                        int n = i;
                        this.localMixtureScore[n] = this.localMixtureScore[n] + this.logGamma[l][i];
                        this.e[i] = v * this.ess;
                        ++i;
                    }
                    logPrior += Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                    break;
                }
                case Simple_Mixture: {
                    int c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        this.localMixtureScore[c] = 0.0;
                        int i = 0;
                        while (i < this.componentMixtureParameters[l].length) {
                            int n = c;
                            this.localMixtureScore[n] = this.localMixtureScore[n] + (i == c ? w : v) * this.ess * this.componentMixtureParameters[l][i];
                            ++i;
                        }
                        int n = c++;
                        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
                    }
                    logPrior += Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                    double e = this.ess / (double)this.componentMixtureParameters[l].length;
                    logPrior += SparseLocalInhomogeneousMixtureDiffSM.logPrior(e, this.symbolParameters[l], this.symbolLogNorm[l]);
                    int c2 = 1;
                    while (c2 < this.componentMixtureParameters[l].length) {
                        logPrior += SparseLocalInhomogeneousMixtureDiffSM.logPrior(e, this.ancestorMixtureParameters[l][c2 - 1], this.ancestorMixtureLogNorm[l][c2 - 1]);
                        int b = 0;
                        while (b < this.dependencyParameters[l][c2 - 1].length) {
                            logPrior += SparseLocalInhomogeneousMixtureDiffSM.logPrior(e / (double)a, this.dependencyParameters[l][c2 - 1][b], this.dependencyLogNorm[l][c2 - 1][b]);
                            ++b;
                        }
                        ++c2;
                    }
                    break;
                }
            }
            ++l;
        }
        return logPrior;
    }

    protected static final void addGrad(double ess, double[] potential, double[] grad, int start, double w) {
        double e = ess / (double)potential.length;
        int i = 0;
        while (i < potential.length) {
            int n = start + i;
            grad[n] = grad[n] + w * (e - ess * potential[i]);
            ++i;
        }
    }

    private void addGradientPartOfLogPriorTerm(double[] grad, int start, int l, double w) throws Exception {
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        int i = 0;
        while (i < this.componentMixtureParameters[l].length) {
            int n = start + this.componentMixtureIndex[l] + i;
            grad[n] = grad[n] + w * (this.e[i] - this.ess * this.componentMixturePotential[l][i]);
            ++i;
        }
        SparseLocalInhomogeneousMixtureDiffSM.addGrad(this.e[0], this.symbolPotential[l], grad, start + this.symbolIndex[l], w);
        int c = 1;
        while (c < this.componentMixtureParameters[l].length) {
            SparseLocalInhomogeneousMixtureDiffSM.addGrad(this.e[c], this.ancestorMixturePotential[l][c - 1], grad, start + this.ancestorMixtureIndex[l][c - 1], w);
            int b = 0;
            while (b < this.dependencyParameters[l][c - 1].length) {
                SparseLocalInhomogeneousMixtureDiffSM.addGrad(this.e[c] / (double)a, this.dependencyPotential[l][c - 1][b], grad, start + this.dependencyIndex[l][c - 1][b], w);
                ++b;
            }
            ++c;
        }
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        double logP = 0.0;
        int a = (int)this.alphabets.getAlphabetLengthAt(0);
        int l = 0;
        while (l < this.length) {
            double v;
            double w;
            if (this.componentMixtureParameters[l].length == 1) {
                w = 1.0;
                v = 0.0;
            } else {
                w = this.q;
                v = (1.0 - this.q) / ((double)this.componentMixturePotential[l].length - 1.0);
            }
            switch (this.type) {
                case BDeu: {
                    Arrays.fill(this.e, this.ess / (double)this.componentMixtureParameters[l].length);
                    this.addGradientPartOfLogPriorTerm(grad, start, l, 1.0);
                    break;
                }
                case Complex_Mixture: {
                    Arrays.fill(this.e, v * this.ess);
                    int i = 0;
                    while (i < this.componentMixtureParameters[l].length) {
                        this.e[i] = w * this.ess;
                        this.setLogPriorTerm(l, i, logP);
                        this.e[i] = v * this.ess;
                        ++i;
                    }
                    Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
                    i = 0;
                    while (i < this.componentMixtureParameters[l].length) {
                        this.e[i] = w * this.ess;
                        this.addGradientPartOfLogPriorTerm(grad, start, l, this.localMixtureScore[i]);
                        this.e[i] = v * this.ess;
                        ++i;
                    }
                    break;
                }
                case Simple_Mixture: {
                    int i;
                    int c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        this.localMixtureScore[c] = 0.0;
                        i = 0;
                        while (i < this.componentMixtureParameters[l].length) {
                            int n = c;
                            this.localMixtureScore[n] = this.localMixtureScore[n] + (i == c ? w : v) * this.ess * this.componentMixtureParameters[l][i];
                            ++i;
                        }
                        int n = c++;
                        this.localMixtureScore[n] = this.localMixtureScore[n] - this.ess * this.componentMixtureLogNorm[l];
                    }
                    Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
                    c = 0;
                    while (c < this.componentMixtureParameters[l].length) {
                        i = 0;
                        while (i < this.componentMixtureParameters[l].length) {
                            int n = start + this.componentMixtureIndex[l] + c;
                            grad[n] = grad[n] + this.localMixtureScore[i] * (i == c ? w : v) * this.ess;
                            ++i;
                        }
                        int n = start + this.componentMixtureIndex[l] + c;
                        grad[n] = grad[n] - this.ess * this.componentMixturePotential[l][c];
                        ++c;
                    }
                    double e = this.ess / (double)this.componentMixtureParameters[l].length;
                    SparseLocalInhomogeneousMixtureDiffSM.addGrad(e, this.symbolPotential[l], grad, start + this.symbolIndex[l], 1.0);
                    int c2 = 1;
                    while (c2 < this.componentMixtureParameters[l].length) {
                        SparseLocalInhomogeneousMixtureDiffSM.addGrad(e, this.ancestorMixturePotential[l][c2 - 1], grad, start + this.ancestorMixtureIndex[l][c2 - 1], 1.0);
                        int b = 0;
                        while (b < this.dependencyParameters[l][c2 - 1].length) {
                            SparseLocalInhomogeneousMixtureDiffSM.addGrad(e / (double)a, this.dependencyPotential[l][c2 - 1][b], grad, start + this.dependencyIndex[l][c2 - 1][b], 1.0);
                            ++b;
                        }
                        ++c2;
                    }
                    break;
                }
            }
            ++l;
        }
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        double score = 0.0;
        int l = 0;
        while (l < this.length) {
            int current = seq.discreteVal(start + l);
            this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.symbolParameters[l][current] - this.symbolLogNorm[l];
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                int m = 0;
                while (m < l) {
                    int an = seq.discreteVal(start + l - 1 - m);
                    this.ancestorScore[c - 1][m] = this.ancestorMixtureParameters[l][c - 1][m] - this.ancestorMixtureLogNorm[l][c - 1] + this.dependencyParameters[l][c - 1][an][current] - this.dependencyLogNorm[l][c - 1][an];
                    ++m;
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + (this.max ? ToolBox.max(0, l, this.ancestorScore[c - 1]) : Normalisation.getLogSum(0, l, this.ancestorScore[c - 1]));
                ++c;
            }
            score += this.max ? ToolBox.max(0, this.componentMixtureParameters[l].length, this.localMixtureScore) : Normalisation.getLogSum(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
            ++l;
        }
        return score;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double score = 0.0;
        int l = 0;
        while (l < this.length) {
            int a;
            int an;
            int m;
            int current = seq.discreteVal(start + l);
            this.localMixtureScore[0] = this.componentMixtureParameters[l][0] - this.componentMixtureLogNorm[l] + this.symbolParameters[l][current] - this.symbolLogNorm[l];
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                m = 0;
                while (m < l) {
                    an = seq.discreteVal(start + l - 1 - m);
                    this.ancestorScore[c - 1][m] = this.ancestorMixtureParameters[l][c - 1][m] - this.ancestorMixtureLogNorm[l][c - 1] + this.dependencyParameters[l][c - 1][an][current] - this.dependencyLogNorm[l][c - 1][an];
                    ++m;
                }
                this.localMixtureScore[c] = this.componentMixtureParameters[l][c] - this.componentMixtureLogNorm[l] + (this.max ? ToolBox.max(0, l, this.ancestorScore[c - 1]) : Normalisation.logSumNormalisation(this.ancestorScore[c - 1], 0, l));
                ++c;
            }
            if (this.max) {
                int idx1 = ToolBox.getMaxIndex(0, this.componentMixtureParameters[l].length, this.localMixtureScore);
                score += this.localMixtureScore[idx1];
                c = 0;
                while (c < this.componentMixtureParameters[l].length) {
                    indices.add(this.componentMixtureIndex[l] + c);
                    partialDer.add((double)(c == idx1 ? 1 : 0) - this.componentMixturePotential[l][c]);
                    ++c;
                }
                if (idx1 == 0) {
                    a = 0;
                    while (a < this.symbolParameters[l].length) {
                        indices.add(this.symbolIndex[l] + a);
                        partialDer.add((double)(a == current ? 1 : 0) - this.symbolPotential[l][a]);
                        ++a;
                    }
                } else {
                    int idx2 = ToolBox.getMaxIndex(0, l, this.ancestorScore[idx1 - 1]);
                    int m2 = 0;
                    while (m2 < l) {
                        indices.add(this.ancestorMixtureIndex[l][idx1 - 1] + m2);
                        partialDer.add((double)(idx2 == m2 ? 1 : 0) - this.ancestorMixturePotential[l][idx1 - 1][m2]);
                        ++m2;
                    }
                    int an2 = seq.discreteVal(start + l - 1 - idx2);
                    int b = 0;
                    while (b < this.dependencyParameters[an2].length) {
                        indices.add(this.dependencyIndex[l][idx1 - 1][an2] + b);
                        partialDer.add((double)(b == current ? 1 : 0) - this.dependencyPotential[l][idx1 - 1][an2][b]);
                        ++b;
                    }
                }
            } else {
                score += Normalisation.logSumNormalisation(this.localMixtureScore, 0, this.componentMixtureParameters[l].length);
                c = 0;
                while (c < this.componentMixtureParameters[l].length) {
                    indices.add(this.componentMixtureIndex[l] + c);
                    partialDer.add(this.localMixtureScore[c] - this.componentMixturePotential[l][c]);
                    ++c;
                }
                a = 0;
                while (a < this.symbolParameters[l].length) {
                    indices.add(this.symbolIndex[l] + a);
                    partialDer.add(this.localMixtureScore[0] * ((double)(a == current ? 1 : 0) - this.symbolPotential[l][a]));
                    ++a;
                }
                c = 1;
                while (c < this.componentMixtureParameters[l].length) {
                    int a2 = 0;
                    while (a2 < this.depGrad.length) {
                        Arrays.fill(this.depGrad[a2], 0.0);
                        ++a2;
                    }
                    m = 0;
                    while (m < l) {
                        indices.add(this.ancestorMixtureIndex[l][c - 1] + m);
                        partialDer.add(this.localMixtureScore[c] * (this.ancestorScore[c - 1][m] - this.ancestorMixturePotential[l][c - 1][m]));
                        an = seq.discreteVal(start + l - 1 - m);
                        int a3 = 0;
                        while (a3 < this.depGrad[an].length) {
                            double[] dArray = this.depGrad[an];
                            int n = a3;
                            dArray[n] = dArray[n] + this.ancestorScore[c - 1][m] * ((double)(a3 == current ? 1 : 0) - this.dependencyPotential[l][c - 1][an][a3]);
                            ++a3;
                        }
                        ++m;
                    }
                    a2 = 0;
                    while (a2 < this.depGrad.length) {
                        int b = 0;
                        while (b < this.depGrad[a2].length) {
                            if (this.depGrad[a2][b] != 0.0) {
                                indices.add(this.dependencyIndex[l][c - 1][a2] + b);
                                partialDer.add(this.localMixtureScore[c] * this.depGrad[a2][b]);
                            }
                            ++b;
                        }
                        ++a2;
                    }
                    ++c;
                }
            }
            ++l;
        }
        return score;
    }

    public void checkGrad(IntList indices, DoubleList partDer) {
        double[] grad = new double[this.numParameter];
        int i = 0;
        while (i < indices.length()) {
            int n = indices.get(i);
            grad[n] = grad[n] + partDer.get(i);
            ++i;
        }
        System.out.println(Arrays.toString(grad));
        int l = 0;
        while (l < this.length) {
            System.out.println("comMix " + l + " " + ToolBox.sum(this.componentMixtureIndex[l], this.componentMixtureIndex[l] + this.componentMixtureParameters[l].length, grad));
            System.out.println("sym " + l + " " + ToolBox.sum(this.symbolIndex[l], this.symbolIndex[l] + this.symbolParameters[l].length, grad));
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                System.out.println("anMix " + l + " " + (c - 1) + " " + ToolBox.sum(this.ancestorMixtureIndex[l][c - 1], this.ancestorMixtureIndex[l][c - 1] + this.ancestorMixtureParameters[l][c - 1].length, grad));
                int b = 0;
                while (b < this.dependencyParameters[l][c - 1].length) {
                    System.out.println("dep " + l + " " + (c - 1) + " " + b + " " + ToolBox.sum(this.dependencyIndex[l][c - 1][b], this.dependencyIndex[l][c - 1][b] + this.dependencyParameters[l][c - 1][b].length, grad));
                    ++b;
                }
                ++c;
            }
            ++l;
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.numParameter;
    }

    private void get(int start, double[] parameter, double[] array) {
        int i = 0;
        while (i < parameter.length) {
            array[start + i] = parameter[i];
            ++i;
        }
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] res = new double[this.numParameter];
        int l = 0;
        while (l < this.length) {
            this.get(this.componentMixtureIndex[l], this.componentMixtureParameters[l], res);
            this.get(this.symbolIndex[l], this.symbolParameters[l], res);
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                this.get(this.ancestorMixtureIndex[l][c - 1], this.ancestorMixtureParameters[l][c - 1], res);
                int b = 0;
                while (b < this.dependencyParameters[l][c - 1].length) {
                    this.get(this.dependencyIndex[l][c - 1][b], this.dependencyParameters[l][c - 1][b], res);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        return res;
    }

    private void set(int start, double[] parameter, double[] array) {
        int i = 0;
        while (i < parameter.length) {
            parameter[i] = array[start + i];
            ++i;
        }
    }

    @Override
    public void setParameters(double[] params, int start) {
        int l = 0;
        while (l < this.length) {
            this.set(start + this.componentMixtureIndex[l], this.componentMixtureParameters[l], params);
            this.set(start + this.symbolIndex[l], this.symbolParameters[l], params);
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                this.set(start + this.ancestorMixtureIndex[l][c - 1], this.ancestorMixtureParameters[l][c - 1], params);
                int b = 0;
                while (b < this.dependencyParameters[l][c - 1].length) {
                    this.set(start + this.dependencyIndex[l][c - 1][b], this.dependencyParameters[l][c - 1][b], params);
                    ++b;
                }
                ++c;
            }
            ++l;
        }
        this.precompute();
    }

    @Override
    public String getInstanceName() {
        return "slim(" + this.components + ", " + this.max + ", " + (Object)((Object)this.type) + " " + this.ess + " " + this.q + ")";
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.components, "components");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.componentMixtureParameters, "componentMixtureParameters");
        XMLParser.appendObjectWithTags(xml, this.ancestorMixtureParameters, "ancestorMixtureParameters");
        XMLParser.appendObjectWithTags(xml, this.symbolParameters, "symbolParameters");
        XMLParser.appendObjectWithTags(xml, this.dependencyParameters, "dependencyParameters");
        XMLParser.appendObjectWithTags(xml, (Object)this.type, "priorType");
        XMLParser.appendObjectWithTags(xml, this.q, "q");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.length = (Integer)XMLParser.extractObjectForTags(xml, "length");
        this.components = (Integer)XMLParser.extractObjectForTags(xml, "components");
        this.ess = (Double)XMLParser.extractObjectForTags(xml, "ess");
        this.componentMixtureParameters = (double[][])XMLParser.extractObjectForTags(xml, "componentMixtureParameters");
        this.ancestorMixtureParameters = (double[][][])XMLParser.extractObjectForTags(xml, "ancestorMixtureParameters");
        this.symbolParameters = (double[][])XMLParser.extractObjectForTags(xml, "symbolParameters");
        this.dependencyParameters = (double[][][][])XMLParser.extractObjectForTags(xml, "dependencyParameters");
        this.type = (PriorType)((Object)XMLParser.extractObjectForTags(xml, "priorType"));
        this.q = (Double)XMLParser.extractObjectForTags(xml, "q");
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer res = new StringBuffer();
        DiscreteAlphabet abc = (DiscreteAlphabet)this.alphabets.getAlphabetAt(0);
        int l = 0;
        while (l < this.length) {
            res.append("P_" + l + "(c=0)=" + nf.format(this.componentMixturePotential[l][0]) + "\n");
            res.append("P_" + l + "(x|c=0)=" + ToolBox.toString(this.symbolPotential[l], nf) + "\n\n");
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                res.append("P_" + l + "(c=" + c + ")=" + nf.format(this.componentMixturePotential[l][c]) + "\n");
                res.append("P_" + l + "(p|c=" + c + ")=" + ToolBox.toString(this.ancestorMixturePotential[l][c - 1], nf) + "\n");
                int b = 0;
                while (b < this.dependencyParameters[l][c - 1].length) {
                    res.append("P_" + l + "(x|y=" + abc.getSymbolAt(b) + ",c=" + c + ")=" + ToolBox.toString(this.dependencyPotential[l][c - 1][b], nf) + "\n");
                    ++b;
                }
                res.append("\n");
                ++c;
            }
            res.append("\n");
            ++l;
        }
        return String.valueOf(res.toString()) + this.getGraphviz();
    }

    public double[][][] getConditionalProbabilities(int component) throws CloneNotSupportedException {
        double[][][] condProbs = new double[this.dependencyPotential.length][][];
        int i = 0;
        while (i < condProbs.length) {
            condProbs[i] = this.dependencyPotential[i].length > component ? (double[][])ArrayHandler.clone((Cloneable[])this.dependencyPotential[i][component]) : new double[0][0];
            ++i;
        }
        return condProbs;
    }

    public double[][] getPWMParameters() throws CloneNotSupportedException {
        return (double[][])ArrayHandler.clone((Cloneable[])this.symbolPotential);
    }

    public double[][] getMixtureProbabilities() throws CloneNotSupportedException {
        return (double[][])ArrayHandler.clone((Cloneable[])this.componentMixturePotential);
    }

    public double[][] getAncestorProbabilities(int component) {
        double[][] ancProb = new double[this.ancestorMixturePotential.length][];
        int i = 0;
        while (i < ancProb.length) {
            ancProb[i] = this.ancestorMixturePotential[i].length > component ? (double[])this.ancestorMixturePotential[i][component].clone() : new double[0];
            ++i;
        }
        return ancProb;
    }

    public String getGraphviz() {
        StringBuffer res = new StringBuffer();
        int l = 0;
        while (l < this.length) {
            int c = 1;
            while (c < this.componentMixtureParameters[l].length) {
                int p = 0;
                while (p < this.ancestorMixturePotential[l][c - 1].length) {
                    String w = Integer.toHexString((int)(256.0 * (1.0 - this.componentMixturePotential[l][c] * this.ancestorMixturePotential[l][c - 1][p])));
                    if (w.length() == 1) {
                        w = "0" + w;
                    }
                    res.append(String.valueOf(l - p - 1) + " -> " + l + "[" + "color=\"#" + w + w + w + "\"]\n");
                    ++p;
                }
                ++c;
            }
            ++l;
        }
        return res.toString();
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 1;
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        if (offsetLeft != 0 || offsetRight != 0) {
            int oldLength = this.length;
            this.length = oldLength - offsetLeft + offsetRight;
            boolean modLength = oldLength != this.length;
            int a = (int)this.alphabets.getAlphabetLengthAt(0);
            double[][] newSymbolParameters = new double[this.length][];
            double[][][][] newDependencyParameters = new double[this.length][][][];
            double[][] newComponentMixtureParameters = new double[this.length][];
            double[][][] newAncestorMixtureParameters = new double[this.length][][];
            int oldIndex = offsetLeft;
            int l = 0;
            while (l < this.length) {
                int m = Math.min(l + 1, this.components);
                newAncestorMixtureParameters[l] = new double[m - 1][l];
                if (oldIndex >= 0 && oldIndex < oldLength) {
                    int i;
                    newSymbolParameters[l] = this.symbolParameters[oldIndex];
                    int n = Math.min(m, this.componentMixtureParameters[oldIndex].length);
                    if (m == this.componentMixtureParameters[oldIndex].length) {
                        newDependencyParameters[l] = this.dependencyParameters[oldIndex];
                        newComponentMixtureParameters[l] = this.componentMixtureParameters[oldIndex];
                    } else {
                        newDependencyParameters[l] = new double[m - 1][][];
                        newComponentMixtureParameters[l] = new double[m];
                        i = 0;
                        while (i < n) {
                            double sum = ToolBox.sum(0, n, this.componentMixturePotential[oldIndex]);
                            double f = (double)n / (double)m;
                            newComponentMixtureParameters[l][i] = Math.log(this.componentMixturePotential[oldIndex][i] / sum * f);
                            if (i > 0) {
                                newDependencyParameters[l][i - 1] = this.dependencyParameters[oldIndex][i - 1];
                            }
                            ++i;
                        }
                        i = n;
                        while (i < m) {
                            newDependencyParameters[l][i - 1] = new double[a][a];
                            ++i;
                        }
                        Arrays.fill(newComponentMixtureParameters[l], n, m, -Math.log(m));
                    }
                    --m;
                    --n;
                    i = 0;
                    while (i < m) {
                        Arrays.fill(newAncestorMixtureParameters[l][i], 0, l, -Math.log(l));
                        if (i < n) {
                            int k = Math.min(l, oldIndex);
                            double sum = ToolBox.sum(0, k, this.ancestorMixturePotential[oldIndex][i]);
                            double f = (double)k / (double)l;
                            int j = 0;
                            while (j < k) {
                                newAncestorMixtureParameters[l][i][j] = Math.log(this.ancestorMixturePotential[oldIndex][i][j] / sum * f);
                                ++j;
                            }
                        }
                        ++i;
                    }
                } else {
                    newSymbolParameters[l] = new double[a];
                    newComponentMixtureParameters[l] = new double[Math.min(l + 1, this.components)];
                    newDependencyParameters[l] = new double[newComponentMixtureParameters[l].length - 1][a][a];
                    newAncestorMixtureParameters[l] = new double[newComponentMixtureParameters[l].length - 1][l];
                }
                ++l;
                ++oldIndex;
            }
            this.symbolParameters = newSymbolParameters;
            this.dependencyParameters = newDependencyParameters;
            this.componentMixtureParameters = newComponentMixtureParameters;
            this.ancestorMixtureParameters = newAncestorMixtureParameters;
            if (modLength) {
                this.init();
            } else {
                this.precompute();
            }
        }
        return true;
    }

    public static enum PriorType {
        BDeu,
        Simple_Mixture,
        Complex_Mixture;

    }
}

