/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable;

import de.jstacs.NotTrainedException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.LinkedList;

public class CompositeTrainSM
extends AbstractTrainableStatisticalModel {
    private static final long serialVersionUID = 1263707296720984521L;
    private static final String XML_TAG = "CompositeTrainSM";
    protected TrainableStatisticalModel[] models;
    protected int[][] starts;
    protected int[][] lengths;

    public CompositeTrainSM(AlphabetContainer alphabets, int[] assignment, TrainableStatisticalModel ... models) throws WrongAlphabetException, CloneNotSupportedException {
        super(alphabets, assignment.length);
        this.starts = new int[models.length][];
        this.lengths = new int[models.length][];
        int i = 0;
        int start = -1;
        int[] len = new int[models.length];
        int[] parts = new int[models.length];
        while (i < assignment.length) {
            if (assignment[i] != start) {
                int n = assignment[i];
                parts[n] = parts[n] + 1;
                start = assignment[i];
            }
            ++i;
        }
        i = 0;
        while (i < models.length) {
            this.starts[i] = new int[parts[i]];
            this.lengths[i] = new int[parts[i]];
            parts[i] = 0;
            ++i;
        }
        len[assignment[0]] = 1;
        start = 0;
        i = 1;
        while (i < assignment.length) {
            int n = assignment[i];
            len[n] = len[n] + 1;
            if (assignment[i] != assignment[start]) {
                this.starts[assignment[start]][parts[assignment[start]]] = start;
                this.lengths[assignment[start]][parts[assignment[start]]] = i - start;
                int n2 = assignment[start];
                parts[n2] = parts[n2] + 1;
                start = i;
            }
            ++i;
        }
        this.starts[assignment[start]][parts[assignment[start]]] = start;
        this.lengths[assignment[start]][parts[assignment[start]]] = i - start;
        i = 0;
        while (i < models.length) {
            if (!alphabets.getCompositeContainer(this.starts[i], this.lengths[i]).checkConsistency(models[i].getAlphabetContainer())) {
                throw new WrongAlphabetException("The " + i + "-th model has not the correct alphabet.");
            }
            if (models[i].getLength() != 0 && models[i].getLength() != len[i]) {
                throw new IllegalArgumentException("The " + i + "-th model can not model sequence of length " + len[i] + ", model length is " + models[i].getLength() + ".");
            }
            ++i;
        }
        this.models = (TrainableStatisticalModel[])ArrayHandler.clone((Cloneable[])models);
    }

    public CompositeTrainSM(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public CompositeTrainSM clone() throws CloneNotSupportedException {
        CompositeTrainSM c = (CompositeTrainSM)super.clone();
        c.starts = new int[this.models.length][];
        c.lengths = new int[this.models.length][];
        int i = 0;
        while (i < this.models.length) {
            c.starts[i] = (int[])this.starts[i].clone();
            c.lengths[i] = (int[])this.lengths[i].clone();
            ++i;
        }
        c.models = (TrainableStatisticalModel[])ArrayHandler.clone((Cloneable[])this.models);
        return c;
    }

    @Override
    public ResultSet getCharacteristics() throws Exception {
        LinkedList<Result> infos = new LinkedList<Result>();
        int i = 0;
        while (i < this.models.length) {
            ResultSet part = this.models[i].getCharacteristics();
            if (part != null) {
                infos.add(new NumericalResult("model number", "type of model " + this.models[i].getClass().getSimpleName(), new Integer(i)));
                int j = 0;
                while (j < part.getNumberOfResults()) {
                    infos.add(part.getResultAt(j));
                    ++j;
                }
            }
            ++i;
        }
        infos.add(new StorableResult("model", "the xml representation of the model", this));
        return new ResultSet(infos);
    }

    @Override
    public String getInstanceName() {
        StringBuffer erg = new StringBuffer("composite model(");
        erg.append(this.models[0].getInstanceName());
        int i = 1;
        while (i < this.models.length) {
            erg.append(", ");
            erg.append(this.models[i].getInstanceName());
            ++i;
        }
        erg.append(")");
        return erg.toString();
    }

    public int[] getLengthOfModels() {
        int[] erg = new int[this.models.length];
        int i = 0;
        while (i < this.models.length) {
            erg[i] = this.models[i].getLength();
            ++i;
        }
        return erg;
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        byte max = 0;
        int i = 0;
        while (i < this.models.length) {
            byte c = this.models[i].getMaximalMarkovOrder();
            if (max < c) {
                max = c;
            }
            ++i;
        }
        return max;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        LinkedList<NumericalResult> infos = new LinkedList<NumericalResult>();
        int i = 0;
        while (i < this.models.length) {
            NumericalResultSet part = this.models[i].getNumericalCharacteristics();
            if (part != null && part.getNumberOfResults() > 0) {
                infos.add(new NumericalResult("model number", "type of model " + this.models[i].getClass().getSimpleName(), new Integer(i)));
                int j = 0;
                while (j < part.getNumberOfResults()) {
                    infos.add(part.getResultAt(j));
                    ++j;
                }
            }
            ++i;
        }
        return new NumericalResultSet(infos);
    }

    public TrainableStatisticalModel[] getModels() throws CloneNotSupportedException {
        return (TrainableStatisticalModel[])ArrayHandler.clone((Cloneable[])this.models);
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        double sum = 0.0;
        int i = 0;
        while (i < this.models.length) {
            sum += this.models[i].getLogPriorTerm();
            ++i;
        }
        return sum;
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        if (endpos - startpos + 1 != this.length) {
            throw new IllegalArgumentException("This sequence has not length " + this.length + ".");
        }
        double erg = 0.0;
        int i = 0;
        while (i < this.models.length) {
            erg = this.lengths[i].length == 1 ? (erg += this.models[i].getLogProbFor(sequence, startpos + this.starts[i][0], startpos + this.starts[i][0] + this.lengths[i][0] - 1)) : (erg += this.models[i].getLogProbFor(sequence.getCompositeSequence(this.alphabets, this.getStartsFor(i, startpos), this.lengths[i])));
            ++i;
        }
        return erg;
    }

    private int[] getStartsFor(int index, int offset) {
        int[] arrays = new int[this.starts[index].length];
        int i = 0;
        while (i < arrays.length) {
            arrays[i] = offset + this.starts[index][i];
            ++i;
        }
        return arrays;
    }

    @Override
    public boolean isInitialized() {
        boolean erg = true;
        int i = 0;
        while (i < this.models.length && erg) {
            erg &= this.models[i++].isInitialized();
        }
        return erg;
    }

    @Override
    public void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, XML_TAG);
        this.alphabets = new AlphabetContainer(xml);
        this.length = XMLParser.extractObjectForTags(xml, "sequencelength", Integer.TYPE);
        this.lengths = XMLParser.extractObjectForTags(xml, "lengths", int[][].class);
        this.starts = XMLParser.extractObjectForTags(xml, "starts", int[][].class);
        this.models = XMLParser.extractObjectForTags(xml, "models", AbstractTrainableStatisticalModel[].class);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = this.alphabets.toXML();
        XMLParser.appendObjectWithTags(xml, this.length, "sequencelength");
        XMLParser.appendObjectWithTags(xml, this.lengths, "lengths");
        XMLParser.appendObjectWithTags(xml, this.starts, "starts");
        XMLParser.appendObjectWithTags(xml, this.models, "models");
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        if (data.getElementLength() != this.length) {
            throw new IOException("The given data has not correct sequence length.");
        }
        int i = 0;
        while (i < this.models.length) {
            if (weights == null) {
                this.models[i].train(data.getCompositeDataSet(this.starts[i], this.lengths[i]));
            } else {
                this.models[i].train(data.getCompositeDataSet(this.starts[i], this.lengths[i]), weights);
            }
            ++i;
        }
    }

    @Override
    public String toString(NumberFormat nf) {
        String erg = "";
        int i = 0;
        while (i < this.models.length) {
            erg = String.valueOf(erg) + "model: " + i + "\n";
            erg = String.valueOf(erg) + this.models[i].toString(nf) + "\n\n";
            ++i;
        }
        return erg;
    }
}

