/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous;

import de.jstacs.data.DataSet;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.DGTrainSMParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.DAGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.BayesianNetworkTrainSMParameterSet;
import java.util.Arrays;

public class BayesianNetworkTrainSM
extends DAGTrainSM {
    private StructureLearner sl;
    private static final String XML_TAG = "BayesianNetworkTrainSM";

    public BayesianNetworkTrainSM(BayesianNetworkTrainSMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public BayesianNetworkTrainSM(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    @Override
    public BayesianNetworkTrainSM clone() throws CloneNotSupportedException {
        BayesianNetworkTrainSM clone = (BayesianNetworkTrainSM)super.clone();
        clone.sl = new StructureLearner(this.alphabets, this.length, this.getESS());
        return clone;
    }

    @Override
    public String getInstanceName() {
        return ((BayesianNetworkTrainSMParameterSet)this.params).getModelInstanceName();
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        this.createConstraints(this.sl.getStructure(data, weights, this.getModel(), this.getMaximalMarkovOrder(), this.getMethod()));
        this.estimateParameters(data, weights);
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        if (this.getMethod() == StructureLearner.LearningType.BMA) {
            throw new UnsupportedOperationException();
        }
        return super.getLogPriorTerm();
    }

    @Override
    public byte getMaximalMarkovOrder() {
        return (byte)Math.min(this.length - 1, ((Byte)this.params.getParameterAt(3).getValue()).byteValue());
    }

    private StructureLearner.LearningType getMethod() {
        return (StructureLearner.LearningType)((Object)this.params.getParameterAt(4).getValue());
    }

    private StructureLearner.ModelType getModel() {
        return (StructureLearner.ModelType)((Object)this.params.getParameterAt(2).getValue());
    }

    protected int[] count(int[][] structure, byte maxOrder) {
        int[] counts = new int[maxOrder + 1];
        int i = 0;
        while (i < this.length) {
            if (i != structure[i][structure[i].length - 1]) {
                throw new IllegalArgumentException("The structure is not correct. Look at the parents of node " + i);
            }
            if (structure[i].length - 1 > maxOrder) {
                throw new IllegalArgumentException("The structure is not correct. There is at least one node (" + i + ") that has to many parents.");
            }
            int n = structure[i].length - 1;
            counts[n] = counts[n] + 1;
            int[] help = (int[])structure[i].clone();
            Arrays.sort(help);
            int j = 1;
            while (j < help.length && help[j - 1] < help[j]) {
                ++j;
            }
            if (j != help.length) {
                throw new IllegalArgumentException("The structure is not correct. Look at the parents of node " + i);
            }
            ++i;
        }
        return counts;
    }

    @Override
    protected void set(DGTrainSMParameterSet parameter, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(parameter, trained);
        this.sl = new StructureLearner(this.alphabets, this.length, this.getESS());
    }
}

