/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.group;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class Permutation {
    private static final long serialVersionUID = 1L;

    public static int[] identity(int n) {
        int[] nArray = new int[n];
        Permutation.identity(nArray);
        return nArray;
    }

    public static void identity(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
    }

    public static int[] random(int n) {
        int[] nArray = new int[n];
        Permutation.random(nArray);
        return nArray;
    }

    public static int[] random(int n, int n2) {
        int[] nArray = new int[n];
        Permutation.random(nArray, n2);
        return nArray;
    }

    public static void random(int[] nArray) {
        Permutation.random(nArray, 0);
    }

    public static void random(int[] nArray, int n) {
        boolean bl = n != 0;
        Permutation.identity(nArray);
        Random random = new Random();
        int n2 = nArray.length;
        while (n2 > 1) {
            int n3;
            if (bl) {
                n3 = --n2;
            } else {
                int n4 = n2;
                n3 = n4;
                n2 = n4 - 1;
            }
            int n5 = random.nextInt(n3);
            int n6 = nArray[n2];
            nArray[n2] = nArray[n5];
            nArray[n5] = n6;
        }
    }

    public static boolean isPermutation(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        return Permutation.isPermutation(nArray, blArray);
    }

    public static boolean isPermutation(int[] nArray, int[] nArray2) {
        if (nArray.length > nArray2.length) {
            throw new IllegalArgumentException("mfc.de.jtem.numericalMethods.group.Permutation.isPermutation called with int[] of insufficient size.");
        }
        Arrays.fill(nArray2, 1);
        int n = nArray.length;
        while (--n >= 0) {
            try {
                int n2 = nArray[n];
                nArray2[n2] = nArray2[n2] - 1;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
        }
        n = nArray.length;
        while (--n >= 0) {
            if (nArray2[n] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isPermutation(int[] nArray, boolean[] blArray) {
        if (nArray.length > blArray.length) {
            throw new IllegalArgumentException("mfc.de.jtem.numericalMethods.group.Permutation.isPermutation called with int[] of insufficient size.");
        }
        Arrays.fill(blArray, true);
        int n = nArray.length;
        while (--n >= 0) {
            try {
                if (blArray[nArray[n]]) {
                    blArray[nArray[n]] = false;
                    continue;
                }
                return false;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
        }
        n = nArray.length;
        while (--n >= 0) {
            if (!blArray[n]) continue;
            return false;
        }
        return true;
    }

    public static boolean isDerangement(int[] nArray) {
        boolean[] blArray = new boolean[nArray.length];
        return Permutation.isDerangement(nArray, blArray);
    }

    public static boolean isDerangement(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        while (--n >= 0) {
            if (nArray[n] != n) continue;
            return false;
        }
        return Permutation.isPermutation(nArray, nArray2);
    }

    public static boolean isDerangement(int[] nArray, boolean[] blArray) {
        int n = nArray.length;
        while (--n >= 0) {
            if (nArray[n] != n) continue;
            return false;
        }
        return Permutation.isPermutation(nArray, blArray);
    }

    public static int[][] cycles(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        int[][] nArrayArray = new int[n][];
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (blArray[i]) continue;
            int n3 = 0;
            try {
                int n4 = nArray[i];
                while (!blArray[n4]) {
                    nArray2[n - ++n3] = n4;
                    blArray[n4] = true;
                    n4 = nArray[n4];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1." + arrayIndexOutOfBoundsException.getMessage());
            }
            if (nArray2[n - n3] != i) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1.");
            }
            nArrayArray[n2] = new int[n3];
            System.arraycopy(nArray2, n - n3, nArrayArray[n2], 0, n3);
            ++n2;
        }
        int[][] nArrayArray2 = new int[n2][];
        System.arraycopy(nArrayArray, 0, nArrayArray2, 0, n2);
        return nArrayArray2;
    }

    public static int[][] cyclesFun(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        int[][] nArrayArray = new int[n][];
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (blArray[i]) continue;
            int n3 = 0;
            try {
                int n4 = i;
                while (!blArray[n4]) {
                    nArray2[n3++] = n4;
                    blArray[n4] = true;
                    n4 = nArray[n4];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1." + arrayIndexOutOfBoundsException.getMessage());
            }
            if (nArray[nArray2[n3 - 1]] != i) {
                throw new IllegalArgumentException("Permutation.cycles called with a non valid permutation of its indices 0..n-1.");
            }
            nArrayArray[n2] = new int[n3];
            System.arraycopy(nArray2, 0, nArrayArray[n2], 0, n3);
            ++n2;
        }
        int[][] nArrayArray2 = new int[n2][];
        System.arraycopy(nArrayArray, 0, nArrayArray2, 0, n2);
        return nArrayArray2;
    }

    public static void fromCycles(int[][] nArray, int[] nArray2) throws ArrayIndexOutOfBoundsException {
        int n = nArray2.length;
        Permutation.identity(nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i].length - 1;
            nArray2[nArray[i][0]] = nArray[i][n2];
            int n3 = n2;
            while (n3 > 0) {
                nArray2[nArray[i][n3]] = nArray[i][--n3];
            }
        }
    }

    public static void fromCyclesFun(int[][] nArray, int[] nArray2) throws ArrayIndexOutOfBoundsException {
        int n = nArray2.length;
        Permutation.identity(nArray2);
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i].length - 1;
            nArray2[nArray[i][n2]] = nArray[i][0];
            int n3 = 0;
            while (n3 < n2) {
                nArray2[nArray[i][n3]] = nArray[i][++n3];
            }
        }
    }

    public static int[] fromCycles(int[][] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i].length;
        }
        int[] nArray2 = new int[n];
        try {
            Permutation.fromCycles(nArray, nArray2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Permutation.fromCycles called with a non valid array of cycles.");
        }
        return nArray2;
    }

    public static int[] inverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        Permutation.inverse(nArray, nArray2);
        return nArray2;
    }

    public static void inverse(int[] nArray, int[] nArray2) throws IllegalArgumentException {
        int n = nArray.length;
        while (--n >= 0) {
            try {
                nArray2[nArray[n]] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Permutation.inverse called with a non valid permutation of its indices 0..n-1.");
            }
        }
    }

    public static int numTranspos(int[] nArray) {
        return Permutation.numTranspos(nArray, new int[nArray.length]);
    }

    public static int numTranspos(int[] nArray, int[] nArray2) {
        Arrays.fill(nArray2, 0);
        int n = 0;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = n2;
            if (nArray2[n2] != 0) continue;
            do {
                nArray2[n3] = 1;
                n3 = nArray[n3];
                ++n;
            } while (nArray2[n3] == 0);
            --n;
        }
        return n;
    }

    public static int numTranspos(int[] nArray, boolean[] blArray) {
        Arrays.fill(blArray, true);
        int n = 0;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = n2;
            if (!blArray[n2]) continue;
            do {
                blArray[n3] = false;
                n3 = nArray[n3];
                ++n;
            } while (blArray[n3]);
            --n;
        }
        return n;
    }

    public static int numInversions(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = n = nArray.length;
        while (--n3 >= 0) {
            for (int i = 0; nArray[i] != n3 && i < n; ++i) {
                if (nArray[i] <= n3) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static int parity(int[] nArray) {
        return Permutation.numInversions(nArray) % 2;
    }

    public static int order(int[] nArray) {
        return Permutation.order(nArray, new boolean[nArray.length]);
    }

    public static int order(int[] nArray, int[] nArray2) {
        Arrays.fill(nArray2, 0);
        int n = 1;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = n2;
            if (nArray2[n2] != 0) continue;
            int n4 = 0;
            do {
                nArray2[n3] = 1;
                n3 = nArray[n3];
                ++n4;
            } while (nArray2[n3] == 0);
            n = Permutation.lcm(n, n4);
        }
        return n;
    }

    public static int order(int[] nArray, boolean[] blArray) {
        Arrays.fill(blArray, true);
        int n = 1;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            int n3 = n2;
            if (!blArray[n2]) continue;
            int n4 = 0;
            do {
                blArray[n3] = false;
                n3 = nArray[n3];
                ++n4;
            } while (blArray[n3]);
            n = Permutation.lcm(n, n4);
        }
        return n;
    }

    public static int lcm(int n, int n2) {
        return n * n2 / Permutation.gcd(n, n2);
    }

    public static int gcd(int n, int n2) {
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        while (n > 0) {
            if (n2 > n) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            n -= n2;
        }
        return n2;
    }

    public static int lcm(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = nArray[n];
        while (--n >= 0) {
            n2 = Permutation.lcm(n2, nArray[n]);
        }
        return n2;
    }

    public static int gcd(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = nArray[n];
        while (--n >= 0) {
            n2 = Permutation.gcd(n2, nArray[n]);
        }
        return n2;
    }

    public static int factorial(int n) {
        int n2 = 1;
        for (int i = n; i > 0; --i) {
            n2 *= i;
        }
        return n2;
    }

    public static int subFactorial(int n) {
        int n2 = 0;
        int n3 = n > 1 ? 1 : 0;
        for (int i = 2; i < n; ++i) {
            int n4 = n3;
            n3 = i * (n3 + n2);
            n2 = n4;
        }
        return n3;
    }

    public static void next(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = nArray[n];
        int n3 = n;
        while (--n3 >= 0) {
            if (nArray[n3] < n2) {
                int n4 = nArray[n3];
                int n5 = nArray.length;
                while (nArray[--n5] < n4) {
                }
                nArray[n3] = nArray[n5];
                nArray[n5] = n4;
                int n6 = n + n3 + 1;
                for (n5 = n6 >> 1; n5 > n3; --n5) {
                    int n7 = n6 - n5;
                    n4 = nArray[n5];
                    nArray[n5] = nArray[n7];
                    nArray[n7] = n4;
                }
                return;
            }
            n2 = nArray[n3];
        }
        Permutation.identity(nArray);
    }

    public static void nextDerangement(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = nArray[n];
        int n3 = n;
        while (--n3 >= 0) {
            if (nArray[n3] < n2) {
                int n4 = nArray[n3];
                int n5 = nArray.length;
                while (nArray[--n5] < n4) {
                }
                if (nArray[n5] != n3) {
                    nArray[n3] = nArray[n5];
                    nArray[n5] = n4;
                } else if (n5 > n3 + 1) {
                    nArray[n5] = n4;
                    nArray[n3] = nArray[--n5];
                    nArray[n5] = n3;
                } else {
                    nArray[n3] = nArray[n5];
                    nArray[n5] = n4;
                    n2 = nArray[n3];
                    continue;
                }
                int n6 = n + n3 + 1;
                for (n5 = n6 >> 1; n5 > n3; --n5) {
                    int n7 = n6 - n5;
                    n4 = nArray[n5];
                    nArray[n5] = nArray[n7];
                    nArray[n7] = n4;
                }
                for (n5 = n3; n5 < n; ++n5) {
                    if (nArray[n5] != n5) continue;
                    n4 = nArray[n5];
                    nArray[n5++] = nArray[n5];
                    nArray[n5] = n4;
                }
                if (nArray[n] == n) {
                    nArray[n] = nArray[n - 1];
                    nArray[n - 1] = n;
                }
                return;
            }
            n2 = nArray[n3];
        }
        Permutation.firstDerangement(nArray);
    }

    public static void firstDerangement(int[] nArray) {
        int n = nArray.length - 1;
        for (int i = 0; i < n; ++i) {
            nArray[i++] = i;
            nArray[i] = i - 1;
        }
        if (n % 2 == 0) {
            nArray[n] = n - 2;
            nArray[n - 1] = n;
            nArray[n - 2] = n - 1;
        }
    }

    public static void flipLR(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = nArray.length >> 1;
        while (n2-- >= 0) {
            int n3 = nArray[n2];
            int n4 = n - n2;
            nArray[n2] = nArray[n4];
            nArray[n4] = n3;
        }
    }

    public static void flipUD(int[] nArray) {
        int n = nArray.length - 1;
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n - nArray[n2];
        }
    }

    public static void previous(int[] nArray) {
        Permutation.flipUD(nArray);
        Permutation.next(nArray);
        Permutation.flipUD(nArray);
    }

    public static int applyTo(int[] nArray, int n) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] != n) continue;
            return n2;
        }
        throw new IllegalArgumentException("Permutation.applyTo called with a non valid index.");
    }

    public static int applyToFun(int[] nArray, int n) {
        return nArray[n];
    }

    public static int[] times(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        Permutation.times(nArray, nArray2, nArray3);
        return nArray3;
    }

    public static void times(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Permutation.times called with permutations of different sizes.");
        }
        int n = nArray.length;
        while (--n >= 0) {
            try {
                nArray3[n] = nArray2[nArray[n]];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Permutation.times called with invalid permutations.");
            }
        }
    }

    public static int[] timesInverse(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        Permutation.timesInverse(nArray, nArray2, nArray3);
        return nArray3;
    }

    public static void timesInverse(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Permutation.times called with permutations of different sizes.");
        }
        int n = nArray.length;
        while (--n >= 0) {
            try {
                nArray3[nArray[nArray2[n]]] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Permutation.timesInverse called with invalid permutations.");
            }
        }
    }

    public static int[] timesFun(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        Permutation.timesFun(nArray, nArray2, nArray3);
        return nArray3;
    }

    public static void timesFun(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Permutation.times called with permutations of different sizes.");
        }
        int n = nArray.length;
        while (--n >= 0) {
            try {
                nArray3[n] = nArray[nArray2[n]];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Permutation.timesInverse called with invalid permutations.");
            }
        }
    }

    public static int[] divide(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        Permutation.divide(nArray, nArray2, nArray3);
        return nArray3;
    }

    public static void divide(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Permutation.divide called with permutations of different sizes.");
        }
        int n = nArray.length;
        block0: while (--n >= 0) {
            int n2 = nArray.length;
            while (--n2 >= 0) {
                if (nArray2[n2] != nArray[n]) continue;
                nArray3[n] = n2;
                continue block0;
            }
        }
    }

    public static int[] divideFun(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length];
        Permutation.divideFun(nArray, nArray2, nArray3);
        return nArray3;
    }

    public static void divideFun(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Permutation.divideFun called with permutations of different sizes.");
        }
        int n = nArray.length;
        while (--n >= 0) {
            try {
                nArray3[nArray2[n]] = nArray[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("Permutation.divideFun called with invalid permutations.");
            }
        }
    }

    public static int[] inversions(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        Permutation.inversions(nArray, nArray2);
        return nArray2;
    }

    public static void inversions(int[] nArray, int[] nArray2) {
        int n;
        int n2 = n = nArray.length;
        while (--n2 >= 0) {
            for (int i = 0; nArray[i] != n2 && i < n; ++i) {
                if (nArray[i] <= n2) continue;
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + 1;
            }
        }
    }

    public static int[] inversionsFun(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        Permutation.inversionsFun(nArray, nArray2);
        return nArray2;
    }

    public static void inversionsFun(int[] nArray, int[] nArray2) {
        int n;
        int n2 = n = nArray.length;
        while (--n2 >= 0) {
            int n3 = n;
            while (--n3 > n2) {
                if (nArray[n3] >= n2) continue;
                int n4 = n2;
                nArray2[n4] = nArray2[n4] + 1;
            }
        }
    }

    public static int[] fromInversions(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        Permutation.fromInversions(nArray, nArray2);
        return nArray2;
    }

    public static void fromInversions(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        int n2 = n;
        while (--n2 >= 0) {
            arrayList.add(nArray[n2], new Integer(n2));
        }
        n2 = n;
        while (--n2 >= 0) {
            nArray2[n2] = (Integer)arrayList.get(n2);
        }
    }

    public static int[] fromInversionsFun(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        Permutation.fromInversionsFun(nArray, nArray2);
        return nArray2;
    }

    public static void fromInversionsFun(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        int n2 = n;
        while (--n2 >= 0) {
            arrayList.add(nArray[n2], new Integer(n2));
        }
        n2 = n;
        while (--n2 >= 0) {
            nArray2[((Integer)arrayList.get((int)n2)).intValue()] = n2;
        }
    }

    public static int[][][] youngTableaux(int[] nArray) {
        ArrayList arrayList;
        int n;
        int n2 = nArray.length;
        ArrayList arrayList2 = new ArrayList(n2);
        ArrayList arrayList3 = new ArrayList(n2);
        int n3 = n2;
        while (--n3 >= 0) {
            arrayList2.add(0, new ArrayList(n3));
            arrayList3.add(0, new ArrayList(n3));
        }
        block1: for (n3 = 0; n3 < nArray.length; ++n3) {
            int n4 = nArray[n3];
            int n5 = arrayList2.size();
            for (n = 0; n < n5; ++n) {
                arrayList = (ArrayList)arrayList2.get(n);
                ArrayList arrayList4 = (ArrayList)arrayList3.get(n);
                boolean bl = false;
                int n6 = arrayList.size();
                for (int i = 0; i < n6; ++i) {
                    int n7 = (Integer)arrayList.get(i);
                    if (n7 <= n4) continue;
                    bl = true;
                    arrayList.set(i, new Integer(n4));
                    n4 = n7;
                    break;
                }
                if (bl) continue;
                arrayList.add(new Integer(n4));
                arrayList4.add(new Integer(n3));
                continue block1;
            }
        }
        n3 = n2;
        while (--n3 >= 0 && ((ArrayList)arrayList2.get(n3)).size() == 0) {
        }
        int[][][] nArrayArray = new int[][][]{new int[++n3][], new int[n3][]};
        n = n3;
        while (--n >= 0) {
            ArrayList arrayList5 = (ArrayList)arrayList2.get(n);
            arrayList = (ArrayList)arrayList3.get(n);
            nArrayArray[0][n] = new int[arrayList5.size()];
            nArrayArray[1][n] = new int[arrayList.size()];
            int n8 = arrayList5.size();
            while (--n8 >= 0) {
                nArrayArray[0][n][n8] = (Integer)arrayList5.get(n8);
                nArrayArray[1][n][n8] = (Integer)arrayList.get(n8);
            }
        }
        return nArrayArray;
    }

    public static int[] fromYoungTableaux(int[][][] nArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = nArray[0].length;
        ArrayList arrayList = new ArrayList(n4);
        for (int i = 0; i < n4; ++i) {
            n2 = nArray[0][i].length;
            n3 += n2;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n2);
            for (n = 0; n < n2; ++n) {
                arrayList2.add(new Integer(nArray[0][i][n]));
            }
            arrayList.add(arrayList2);
        }
        int[] nArray2 = new int[n3];
        n2 = n3;
        while (--n2 >= 0) {
            int n5;
            n = 0;
            int n6 = arrayList.size();
            block3: for (n5 = 0; n5 < n6; ++n5) {
                int n7 = nArray[1][n5].length;
                for (n = 0; n < n7; ++n) {
                    if (nArray[1][n5][n] == n2) break block3;
                }
            }
            n6 = 0;
            ArrayList arrayList3 = (ArrayList)arrayList.get(n5);
            Integer n8 = (Integer)arrayList3.get(n);
            n6 = n8;
            arrayList3.remove(n);
            while (--n5 >= 0) {
                arrayList3 = (ArrayList)arrayList.get(n5);
                int n9 = arrayList3.size();
                if (n9 > 0) {
                    for (n = 0; n < n9 && (Integer)arrayList3.get(n) <= n6; ++n) {
                    }
                    --n;
                }
                Integer n10 = (Integer)arrayList3.get(n);
                arrayList3.set(n, n8);
                n8 = n10;
                n6 = n8;
            }
            nArray2[n2] = n6;
        }
        return nArray2;
    }

    public static int[][] runs(int[] nArray) {
        int n = nArray.length;
        int[][] nArrayArray = new int[n][];
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            for (int j = i; j < n; ++j) {
                nArray2[n3++] = nArray[j];
            }
            nArrayArray[n2] = new int[n3];
            System.arraycopy(nArray2, 0, nArrayArray[n2], 0, n3);
            ++n2;
            i += n3;
        }
        int[][] nArrayArray2 = new int[n2][];
        System.arraycopy(nArrayArray, 0, nArrayArray2, 0, n2);
        return nArrayArray2;
    }

    public static String cyclesToString(int[] nArray) {
        return Permutation.cyclesToString(Permutation.cycles(nArray));
    }

    public static String cyclesToString(int[][] nArray) {
        StringBuffer stringBuffer = new StringBuffer().append('(');
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append('(').append(' ');
            for (int j = 0; j < nArray[i].length; ++j) {
                stringBuffer.append(nArray[i][j] + " ");
            }
            stringBuffer.append(')');
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static final int[][] stringToCycles(String string) {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.wordChars(48, 57);
            streamTokenizer.wordChars(0, 32);
            streamTokenizer.whitespaceChars(40, 41);
            int n = 0;
            int n2 = 0;
            Object object = new StreamTokenizer(new StringReader(string));
            ((StreamTokenizer)object).resetSyntax();
            ((StreamTokenizer)object).wordChars(48, 57);
            ((StreamTokenizer)object).wordChars(0, 32);
            ((StreamTokenizer)object).whitespaceChars(40, 41);
            while (true) {
                if (((StreamTokenizer)object).nextToken() == -1) break;
                int n3 = ((StreamTokenizer)object).sval.trim().length();
                if (n3 > n2) {
                    n2 = n3;
                }
                if (n3 <= 0) continue;
                ++n;
            }
            object = new int[n2];
            int[][] nArrayArray = new int[n][];
            n = 0;
            while (true) {
                if (streamTokenizer.nextToken() == -1) break;
                String string2 = streamTokenizer.sval.trim();
                if (string2.length() <= 0) continue;
                nArrayArray[n++] = Permutation.stringToIntArray(string2, (int[])object);
            }
            return nArrayArray;
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public static int[] stringToIntArray(String string) {
        return Permutation.stringToIntArray(string, new int[string.length()]);
    }

    public static int[] stringToIntArray(String string, int[] nArray) {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.resetSyntax();
            streamTokenizer.whitespaceChars(0, 44);
            streamTokenizer.whitespaceChars(58, 59);
            streamTokenizer.whitespaceChars(123, 125);
            streamTokenizer.parseNumbers();
            int n = 0;
            while (true) {
                if (streamTokenizer.nextToken() == -1) break;
                nArray[n++] = (int)streamTokenizer.nval;
            }
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            return nArray2;
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public static String toString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer().append('(').append(' ');
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i] + " ");
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

