/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.differentiation;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import java.io.Serializable;

public final class NumericalGradient
implements RealFunctionOfSeveralVariablesWithGradient,
Serializable {
    private static final long serialVersionUID = 1L;
    RealFunctionOfSeveralVariables f;
    int n;
    double h;

    public NumericalGradient(RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        this(realFunctionOfSeveralVariables, 1.0E-8);
    }

    public NumericalGradient(RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, double d) {
        this.f = realFunctionOfSeveralVariables;
        this.n = realFunctionOfSeveralVariables.getNumberOfVariables();
        this.h = d;
    }

    public double getH() {
        return this.h;
    }

    public void setH(double d) {
        this.h = d;
    }

    public int getNumberOfVariables() {
        return this.n;
    }

    public double eval(double[] dArray) {
        return this.f.eval(dArray);
    }

    public double eval(double[] dArray, double[] dArray2) {
        return NumericalGradient.computeGradient(this.f, dArray, dArray2, this.h);
    }

    public static double computeGradient(RealFunctionOfSeveralVariables realFunctionOfSeveralVariables, double[] dArray, double[] dArray2, double d) {
        int n = realFunctionOfSeveralVariables.getNumberOfVariables();
        double d2 = realFunctionOfSeveralVariables.eval(dArray);
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[i];
            int n2 = i;
            dArray[n2] = dArray[n2] + d;
            double d4 = dArray[i] - d3;
            dArray2[i] = (realFunctionOfSeveralVariables.eval(dArray) - d2) / d4;
            dArray[i] = d3;
        }
        return d2;
    }
}

