/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.bounding;

public class BoundingBox {
    static final double EPS = 1.0E-14;

    protected BoundingBox() {
    }

    private static void resultIsPoint(double[] dArray, int n, double[][] dArray2, double[] dArray3, double[] dArray4) {
        System.arraycopy(dArray, 0, dArray3, 0, n);
        System.arraycopy(dArray, 0, dArray4, 0, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    private static void gramSchmitt(double[][] dArray, int n) {
        int n2;
        int n3;
        int n4 = dArray.length;
        double[] dArray2 = dArray[n];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray2[n3] = 1.0 + Math.random();
        }
        for (n3 = 0; n3 < n; ++n3) {
            double[] dArray3 = dArray[n3];
            double d = 0.0;
            for (n2 = 0; n2 < n4; ++n2) {
                d += dArray3[n2] * dArray2[n2];
            }
            for (n2 = 0; n2 < n4; ++n2) {
                int n5 = n2;
                dArray2[n5] = dArray2[n5] - d * dArray3[n2];
            }
        }
        double d = 0.0;
        for (int i = 0; i < n4; ++i) {
            d += dArray2[i] * dArray2[i];
        }
        double d2 = Math.sqrt(d);
        if (d2 < 1.0E-14) {
            throw new RuntimeException("gram schmitt failed");
        }
        n2 = 0;
        while (n2 < n4) {
            int n6 = n2++;
            dArray2[n6] = dArray2[n6] / d2;
        }
    }

    public static void compute(double[] dArray, int n, double[][] dArray2, double[] dArray3, double[] dArray4) {
        if (dArray.length % n != 0) {
            throw new IllegalArgumentException("length of point array is not multiple of dim");
        }
        int n2 = dArray.length / n;
        for (int i = 0; i < n; ++i) {
            int n3;
            double d;
            int n4;
            int n5;
            int n6;
            int n7;
            double d2 = 0.0;
            int n8 = 0;
            int n9 = 1;
            for (int j = 0; j < n2 - 1; ++j) {
                n7 = n * j;
                n6 = j + 1;
                n5 = n6 * n;
                while (n6 < n2) {
                    double d3 = 0.0;
                    for (n4 = 0; n4 < n; ++n4) {
                        d3 += (dArray[n7 + n4] - dArray[n5 + n4]) * (dArray[n7 + n4] - dArray[n5 + n4]);
                    }
                    if (d2 < d3) {
                        d2 = d3;
                        n8 = n7;
                        n9 = n5;
                    }
                    ++n6;
                    n5 += n;
                }
            }
            double[] dArray5 = dArray2[i];
            if (d2 < 1.0E-14) {
                if (i == 0) {
                    BoundingBox.resultIsPoint(dArray, n, dArray2, dArray3, dArray4);
                    return;
                }
                BoundingBox.gramSchmitt(dArray2, i);
                d = -1.7976931348623157E308;
                double d4 = Double.MAX_VALUE;
                n3 = 0;
                n4 = 0;
                while (n3 < n2) {
                    double d5 = 0.0;
                    for (int j = 0; j < n; ++j) {
                        d5 += dArray[n4 + j] * dArray5[j];
                    }
                    if (d5 < d4) {
                        d4 = d5;
                    }
                    if (d5 > d) {
                        d = d5;
                    }
                    ++n3;
                    n4 += n;
                }
                dArray3[i] = d4;
                dArray4[i] = d;
            } else {
                d = Math.sqrt(d2);
                for (n5 = 0; n5 < n; ++n5) {
                    dArray5[n5] = (dArray[n8 + n5] - dArray[n9 + n5]) / d;
                }
                dArray3[i] = 0.0;
                dArray4[i] = 0.0;
                for (n5 = 0; n5 < n; ++n5) {
                    int n10 = i;
                    dArray3[n10] = dArray3[n10] + dArray[n9 + n5] * dArray5[n5];
                    int n11 = i;
                    dArray4[n11] = dArray4[n11] + dArray[n8 + n5] * dArray5[n5];
                }
            }
            n6 = 0;
            for (n7 = 0; n7 < n2; ++n7) {
                double d6 = 0.0;
                for (n3 = 0; n3 < n; ++n3) {
                    d6 += dArray[n6 + n3] * dArray5[n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    int n12 = n6++;
                    dArray[n12] = dArray[n12] - d6 * dArray5[n3];
                }
            }
        }
    }
}

