/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db.biosql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.db.biosql.HypersonicDBHelper;
import org.biojava.bio.seq.db.biosql.MySQLDBHelper;
import org.biojava.bio.seq.db.biosql.OracleDBHelper;
import org.biojava.bio.seq.db.biosql.PostgreSQLDBHelper;
import org.biojava.bio.seq.db.biosql.UnknownDBHelper;

public abstract class DBHelper {
    public static final DeleteStyle DELETE_POSTGRESQL = new DeleteStyle("Postgresql");
    public static final DeleteStyle DELETE_MYSQL4 = new DeleteStyle("Mysql 4.0.* or later");
    public static final DeleteStyle DELETE_GENERIC = new DeleteStyle("Portable SQL");
    public static final JoinStyle JOIN_ORACLE8 = new JoinStyle("Oracle 8i or earlier");
    public static final JoinStyle JOIN_GENERIC = new JoinStyle("Portable SQL");
    public static final BioSequenceStyle BIOSEQUENCE_GENERIC = new BioSequenceStyle("Standard schema (except for Oracle schemas using CLOBs)");
    public static final BioSequenceStyle BIOSEQUENCE_ORACLECLOB = new BioSequenceStyle("Oracle schema using CLOBS (but not Len Trigg's schema)");

    public static DBHelper getDBHelper(Connection conn) {
        try {
            String dbType = conn.getMetaData().getURL();
            if (dbType.startsWith("jdbc:")) {
                dbType = dbType.substring(5);
            }
            if (!Character.isLetter(dbType.charAt(0))) {
                throw new IllegalArgumentException("URL must start with a letter: " + dbType);
            }
            int colon = dbType.indexOf(58);
            if (colon > 0) {
                String protocol = dbType.substring(0, colon);
                if (protocol.indexOf("mysql") >= 0) {
                    return new MySQLDBHelper(conn);
                }
                if (protocol.equals("postgresql")) {
                    return new PostgreSQLDBHelper();
                }
                if (protocol.equals("oracle")) {
                    return new OracleDBHelper(conn);
                }
                if (protocol.equals("hsqldb")) {
                    return new HypersonicDBHelper();
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        return new UnknownDBHelper();
    }

    public abstract int getInsertID(Connection var1, String var2, String var3) throws SQLException;

    public DeleteStyle getDeleteStyle() {
        return DELETE_GENERIC;
    }

    public JoinStyle getJoinStyle() {
        return JOIN_GENERIC;
    }

    public BioSequenceStyle getBioSequenceStyle() {
        return BIOSEQUENCE_GENERIC;
    }

    public boolean containsTable(DataSource ds, String tablename) {
        if (ds == null) {
            throw new NullPointerException("Require a datasource.");
        }
        if (tablename == null || tablename.length() == 0) {
            throw new IllegalArgumentException("Invalid table name given");
        }
        Connection conn = null;
        try {
            boolean present;
            Statement ps = null;
            try {
                conn = ds.getConnection();
                ps = conn.prepareStatement("select * from " + tablename + " limit 1");
                ps.executeQuery();
                present = true;
            }
            catch (SQLException ex) {
                present = false;
            }
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
            return present;
        }
        catch (SQLException ex) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex3) {
                    // empty catch block
                }
            }
            throw new BioRuntimeException(ex);
        }
    }

    public static final class BioSequenceStyle {
        private final String name;

        private BioSequenceStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return "DBHelper.BioSequenceStyle: " + this.name;
        }
    }

    public static final class JoinStyle {
        private final String name;

        private JoinStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return "DBHelper.JoinStyle: " + this.name;
        }
    }

    public static final class DeleteStyle {
        private final String name;

        private DeleteStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return "DBHelper.DeleteStyle: " + this.name;
        }
    }
}

