/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.BioException;
import org.biojava.bio.symbol.CodonPref;
import org.biojava.bio.symbol.CodonPrefTools;
import org.biojava.utils.xml.PrettyXMLWriter;

public interface CodonPrefFilter {
    public boolean isRequired(String var1);

    public void put(CodonPref var1) throws BioException;

    public static class EverythingToXML
    implements CodonPrefFilter {
        PrintWriter pw;
        PrettyXMLWriter xw;
        boolean writtenWrapper = false;

        public EverythingToXML(PrintWriter pw) {
            this.pw = pw;
            this.xw = new PrettyXMLWriter(pw);
        }

        public boolean isRequired(String name) {
            return true;
        }

        public void put(CodonPref codonPref) throws BioException {
            try {
                if (!this.writtenWrapper) {
                    this.xw.openTag("CodonPrefs");
                    this.writtenWrapper = true;
                }
                CodonPrefTools.dumpToXML(codonPref, this.xw, false);
            }
            catch (IOException ioe) {
                throw new BioException(ioe);
            }
        }

        public void close() throws IOException {
            this.xw.closeTag("CodonPrefs");
            this.pw.flush();
        }
    }

    public static class ByName
    implements CodonPrefFilter {
        String name;
        CodonPref filteredCodonPref;

        public ByName(String name) {
            this.name = name;
        }

        public boolean isRequired(String name) {
            return name.equals(this.name);
        }

        public void put(CodonPref codonPref) throws BioException {
            this.filteredCodonPref = codonPref;
        }

        public CodonPref getCodonPref() {
            return this.filteredCodonPref;
        }
    }

    public static class AcceptAll
    implements CodonPrefFilter {
        List filteredCodonPrefs = new ArrayList();

        public boolean isRequired(String name) {
            return true;
        }

        public void put(CodonPref codonPref) {
            this.filteredCodonPrefs.add(codonPref);
        }

        public List getCodonPrefs() {
            return this.filteredCodonPrefs;
        }
    }
}

