/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeVetoException;

class CrossProductAlphabetIndex
extends AbstractChangeable
implements AlphabetIndex,
ChangeListener,
Serializable {
    final FiniteAlphabet Alpha;
    List alphaIndexes;
    List revIndexes;

    public CrossProductAlphabetIndex(FiniteAlphabet theAlpha) {
        this.Alpha = theAlpha;
        this.Alpha.addChangeListener(this, Alphabet.SYMBOLS);
        this.alphaIndexes = this.buildIndexList(theAlpha);
        this.revIndexes = new ArrayList(this.alphaIndexes);
        Collections.reverse(this.revIndexes);
    }

    public FiniteAlphabet getAlphabet() {
        return this.Alpha;
    }

    private List buildIndexList(FiniteAlphabet fA) {
        List subAlphas = fA.getAlphabets();
        ArrayList<AlphabetIndex> retList = new ArrayList<AlphabetIndex>();
        for (FiniteAlphabet currAlpha : subAlphas) {
            AlphabetIndex currInd = AlphabetManager.getAlphabetIndex(currAlpha);
            retList.add(currInd);
        }
        return retList;
    }

    public void preChange(ChangeEvent cE) throws ChangeVetoException {
    }

    public void postChange(ChangeEvent cE) {
        this.alphaIndexes = this.buildIndexList(this.Alpha);
        this.revIndexes = new ArrayList(this.alphaIndexes);
        Collections.reverse(this.revIndexes);
    }

    public int indexForSymbol(Symbol s) throws IllegalSymbolException {
        List factors = ((BasisSymbol)s).getSymbols();
        if (factors.size() != this.getAlphabet().getAlphabets().size()) {
            this.getAlphabet().validate(s);
        }
        int index = 0;
        Iterator indexIt = this.alphaIndexes.iterator();
        Iterator symbolIt = factors.iterator();
        try {
            while (symbolIt.hasNext()) {
                Symbol currentSymbol = (Symbol)symbolIt.next();
                AlphabetIndex currentAlphaInd = (AlphabetIndex)indexIt.next();
                FiniteAlphabet currentAlphabet = currentAlphaInd.getAlphabet();
                index = index * currentAlphabet.size() + currentAlphaInd.indexForSymbol(currentSymbol);
            }
        }
        catch (IllegalSymbolException ise) {
            this.getAlphabet().validate(s);
        }
        if (symbolIt.hasNext()) {
            this.getAlphabet().validate(s);
            throw new BioError("Assertion failure: Ran out of indexers for symbols");
        }
        return index;
    }

    public Symbol symbolForIndex(int index) throws IndexOutOfBoundsException {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        try {
            for (AlphabetIndex curAlpIndex : this.revIndexes) {
                int curAlpSize = curAlpIndex.getAlphabet().size();
                int curSymIndValue = index % curAlpSize;
                index /= curAlpSize;
                symbols.add(0, curAlpIndex.symbolForIndex(curSymIndValue));
            }
            return this.Alpha.getSymbol(symbols);
        }
        catch (IllegalSymbolException isE) {
            throw new BioError(isE);
        }
        catch (IndexOutOfBoundsException ioobE) {
            throw ioobE;
        }
    }
}

