/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojavax.Namespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.RichSeqIOListener;

public interface RichSequenceFormat
extends SequenceFormat {
    public boolean canRead(File var1) throws IOException;

    public SymbolTokenization guessSymbolTokenization(File var1) throws IOException;

    public boolean canRead(BufferedInputStream var1) throws IOException;

    public SymbolTokenization guessSymbolTokenization(BufferedInputStream var1) throws IOException;

    public void setPrintStream(PrintStream var1);

    public PrintStream getPrintStream();

    public void beginWriting() throws IOException;

    public void finishWriting() throws IOException;

    public boolean readRichSequence(BufferedReader var1, SymbolTokenization var2, RichSeqIOListener var3, Namespace var4) throws BioException, IllegalSymbolException, IOException;

    public void writeSequence(Sequence var1, Namespace var2) throws IOException;

    public int getLineWidth();

    public void setLineWidth(int var1);

    public void setElideSymbols(boolean var1);

    public boolean getElideSymbols();

    public void setElideFeatures(boolean var1);

    public boolean getElideFeatures();

    public void setElideReferences(boolean var1);

    public boolean getElideReferences();

    public void setElideComments(boolean var1);

    public boolean getElideComments();

    public static abstract class HeaderlessFormat
    extends BasicFormat {
        public void beginWriting() throws IOException {
        }

        public void finishWriting() throws IOException {
        }
    }

    public static abstract class BasicFormat
    implements RichSequenceFormat {
        private int lineWidth = 80;
        private boolean elideSymbols = false;
        private boolean elideFeatures = false;
        private boolean elideComments = false;
        private boolean elideReferences = false;
        private PrintStream os;

        public boolean canRead(File file) throws IOException {
            return false;
        }

        public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
            return RichSequence.IOTools.getDNAParser();
        }

        public int getLineWidth() {
            return this.lineWidth;
        }

        public void setLineWidth(int width) {
            if (width < 1) {
                throw new IllegalArgumentException("Width cannot be less than 1");
            }
            this.lineWidth = width;
        }

        public boolean getElideSymbols() {
            return this.elideSymbols;
        }

        public void setElideSymbols(boolean elideSymbols) {
            this.elideSymbols = elideSymbols;
        }

        public boolean getElideFeatures() {
            return this.elideFeatures;
        }

        public void setElideFeatures(boolean elideFeatures) {
            this.elideFeatures = elideFeatures;
        }

        public boolean getElideReferences() {
            return this.elideReferences;
        }

        public void setElideReferences(boolean elideReferences) {
            this.elideReferences = elideReferences;
        }

        public boolean getElideComments() {
            return this.elideComments;
        }

        public void setElideComments(boolean elideComments) {
            this.elideComments = elideComments;
        }

        public void setPrintStream(PrintStream os) {
            if (os == null) {
                throw new IllegalArgumentException("Print stream cannot be null");
            }
            this.os = os;
        }

        public PrintStream getPrintStream() {
            return this.os;
        }
    }
}

