/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPWrapper;
import org.rosuda.REngine.REngineCallbacks;
import org.rosuda.REngine.REngineException;

public abstract class REngine {
    protected static REngine lastEngine = null;

    public static REngine engineForClass(String klass) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> cl = Class.forName(klass);
        if (cl == null) {
            throw new ClassNotFoundException("can't find engine class " + klass);
        }
        Method m = cl.getMethod("createEngine", null);
        Object o = m.invoke(null, null);
        lastEngine = (REngine)o;
        return lastEngine;
    }

    public static REngine engineForClass(String klass, String[] args, REngineCallbacks callbacks, boolean runREPL) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> cl = Class.forName(klass);
        if (cl == null) {
            throw new ClassNotFoundException("can't find engine class " + klass);
        }
        Method m = cl.getMethod("createEngine", String[].class, REngineCallbacks.class, Boolean.TYPE);
        Object o = m.invoke(null, args, callbacks, new Boolean(runREPL));
        lastEngine = (REngine)o;
        return lastEngine;
    }

    public static REngine getLastEngine() {
        return lastEngine;
    }

    public abstract REXP parse(String var1, boolean var2) throws REngineException;

    public abstract REXP eval(REXP var1, REXP var2, boolean var3) throws REngineException, REXPMismatchException;

    public abstract void assign(String var1, REXP var2, REXP var3) throws REngineException, REXPMismatchException;

    public abstract REXP get(String var1, REXP var2, boolean var3) throws REngineException, REXPMismatchException;

    public abstract REXP resolveReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract REXP createReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract void finalizeReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract REXP getParentEnvironment(REXP var1, boolean var2) throws REngineException, REXPMismatchException;

    public abstract REXP newEnvironment(REXP var1, boolean var2) throws REngineException, REXPMismatchException;

    public REXP parseAndEval(String text, REXP where, boolean resolve) throws REngineException, REXPMismatchException {
        REXP p = this.parse(text, false);
        return this.eval(p, where, resolve);
    }

    public REXP parseAndEval(String cmd) throws REngineException, REXPMismatchException {
        return this.parseAndEval(cmd, null, true);
    }

    public boolean close() {
        return false;
    }

    public boolean supportsReferences() {
        return false;
    }

    public boolean supportsEnvironments() {
        return false;
    }

    public boolean supportsREPL() {
        return false;
    }

    public boolean supportsLocking() {
        return false;
    }

    public void assign(String symbol, double[] d) throws REngineException {
        try {
            this.assign(symbol, new REXPDouble(d), null);
        }
        catch (REXPMismatchException e) {
            throw new REngineException(this, "REXPMismatchException in assign(,double[]): " + e);
        }
    }

    public void assign(String symbol, int[] d) throws REngineException {
        try {
            this.assign(symbol, new REXPInteger(d), null);
        }
        catch (REXPMismatchException e) {
            throw new REngineException(this, "REXPMismatchException in assign(,int[]): " + e);
        }
    }

    public void assign(String symbol, String[] d) throws REngineException {
        try {
            this.assign(symbol, new REXPString(d), null);
        }
        catch (REXPMismatchException e) {
            throw new REngineException(this, "REXPMismatchException in assign(,String[]): " + e);
        }
    }

    public void assign(String symbol, byte[] d) throws REngineException {
        try {
            this.assign(symbol, new REXPRaw(d), null);
        }
        catch (REXPMismatchException e) {
            throw new REngineException(this, "REXPMismatchException in assign(,byte[]): " + e);
        }
    }

    public void assign(String symbol, String d) throws REngineException {
        try {
            this.assign(symbol, new REXPString(d), null);
        }
        catch (REXPMismatchException e) {
            throw new REngineException(this, "REXPMismatchException in assign(,String[]): " + e);
        }
    }

    public void assign(String symbol, REXP value) throws REngineException, REXPMismatchException {
        this.assign(symbol, value, null);
    }

    public synchronized int tryLock() {
        return 0;
    }

    public synchronized int lock() {
        return 0;
    }

    public synchronized void unlock(int lockValue) {
    }

    public String toString() {
        return String.valueOf(super.toString()) + (lastEngine == this ? "{last}" : "");
    }

    public REXP wrap(Object o) {
        return REXPWrapper.wrap(o);
    }
}

