/*
 * Decompiled with CFR 0.152.
 */
package projects.crispr;

import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractVariableLengthDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.differentiable.IndependentProductDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.UniformDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.UniformHomogeneousDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import projects.crispr.BinomialPositionPrior;
import projects.crispr.CRISPRDiffSM;
import projects.crispr.ConditionalHomMM;
import projects.crispr.ConditionalIMM;
import projects.crispr.LogisticPositionPrior2;
import projects.crispr.LogisticPositionPrior3;
import projects.crispr.MatchModel;
import projects.crispr.PositionPrior;
import projects.crispr.UniformPositionPrior;
import projects.dimont.Interpolation;
import projects.talen.LimitedSortedList;

public class CRISPRerMain {
    public static void main(String[] args) throws IllegalArgumentException, Exception {
        int j;
        StringBuffer sb;
        Sequence ts;
        boolean nuclPref = Boolean.parseBoolean(args[0]);
        PosPrior pp = PosPrior.valueOf(args[1]);
        int bgOrder = Integer.parseInt(args[2]);
        boolean depMatch = Boolean.parseBoolean(args[3]);
        boolean depPrev = Boolean.parseBoolean(args[4]);
        int startSeed = Integer.parseInt(args[5]);
        double minPosValue = Double.parseDouble(args[6]);
        Double desc = "null".equals(args[7]) ? null : Double.valueOf(Double.parseDouble(args[7]));
        double ess = Double.parseDouble(args[8]);
        LearningPrinciple lp = LearningPrinciple.valueOf(args[9]);
        boolean modelPAM = Boolean.parseBoolean(args[10]);
        String outPrefix = args[11];
        int test = Integer.parseInt(args[12]);
        int off = 13;
        System.out.println("nuclPref: " + nuclPref + "\npp: " + (Object)((Object)pp) + "\nbgOrder: " + bgOrder + "\ndepMatch: " + depMatch + "\ndepPrev: " + depPrev + "\nstartSeed: " + startSeed + "\n" + "minPosValue: " + minPosValue + "\ndesc: " + desc + "\ness: " + ess + "\nlp: " + (Object)((Object)lp) + "\nmodelPAM: " + modelPAM + "\ntest: " + test);
        AbstractDifferentiableStatisticalModel cr = null;
        if (pp == PosPrior.PWM) {
            cr = new ConditionalIMM(20, ess);
        } else {
            PositionPrior posPrior = null;
            if (pp == PosPrior.NONE) {
                posPrior = new UniformPositionPrior(1.0);
            } else if (pp == PosPrior.LOGISTIC) {
                posPrior = minPosValue == 0.0 ? new LogisticPositionPrior2(desc, startSeed < 0 ? null : Double.valueOf((double)startSeed - 0.5)) : new LogisticPositionPrior3(desc, startSeed < 0 ? null : Double.valueOf((double)startSeed - 0.5), minPosValue < 0.0 ? null : Double.valueOf(minPosValue));
            } else if (pp == PosPrior.BINOMIAL) {
                posPrior = new BinomialPositionPrior(20);
            }
            HomogeneousDiffSM bgModel = null;
            bgModel = bgOrder == -1 ? new UniformHomogeneousDiffSM((AlphabetContainer)DNAAlphabetContainer.SINGLETON, ess / 2.0) : new HomogeneousMMDiffSM(DNAAlphabetContainer.SINGLETON, bgOrder, ess / 2.0, 20);
            AbstractVariableLengthDiffSM condModel = null;
            condModel = nuclPref ? new ConditionalHomMM(DNAAlphabetContainer.SINGLETON, depPrev ? 1 : 0, depMatch, 20, ess / 2.0) : new MatchModel(ess / 2.0);
            cr = new CRISPRDiffSM(DNAAlphabetContainer.SINGLETON, bgModel, condModel, posPrior, ess);
        }
        AbstractDifferentiableSequenceScore pwm = null;
        pwm = modelPAM ? DifferentiableStatisticalModelFactory.createPWM(DNAAlphabetContainer.SINGLETON, 3, ess) : new UniformDiffSM(DNAAlphabetContainer.SINGLETON, 3, ess);
        IndependentProductDiffSM ipsf = new IndependentProductDiffSM(1.0, true, new DifferentiableStatisticalModel[]{cr, pwm}, new int[]{20, 3});
        UniformHomogeneousDiffSM bg = new UniformHomogeneousDiffSM((AlphabetContainer)DNAAlphabetContainer.SINGLETON, ess);
        GenDisMixClassifierParameterSet params = new GenDisMixClassifierParameterSet(DNAAlphabetContainer.SINGLETON, 23, 18, 1.0E-6, 1.0E-6, 1.0E-4, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 4);
        GenDisMixClassifier cl = new GenDisMixClassifier(params, (LogPrior)new CompositeLogPrior(), lp, ipsf, bg);
        DataSet[] ds = new DataSet[args.length - off];
        double[][] intens = new double[ds.length][];
        double[][] weights = new double[ds.length][];
        double[][] bgWeights = new double[ds.length][];
        int i = off;
        while (i < args.length) {
            int j2;
            ds[i - off] = new DNADataSet(args[i], '>', new ReferenceSequenceAnnotationParser("seq", DNAAlphabetContainer.SINGLETON, ":", ";"));
            if (!modelPAM) {
                LinkedList<Sequence> list = new LinkedList<Sequence>();
                j2 = 0;
                while (j2 < ds[i - off].getNumberOfElements()) {
                    if (ds[i - off].getElementAt(j2).toString().endsWith("GG")) {
                        list.add(ds[i - off].getElementAt(j2));
                    }
                    ++j2;
                }
                ds[i - off] = new DataSet("", list);
            }
            double[] weight = new double[ds[i - off].getNumberOfElements()];
            intens[i - off] = new double[weight.length];
            j2 = 0;
            while (j2 < ds[i - off].getNumberOfElements()) {
                weight[j2] = Double.parseDouble(ds[i - off].getElementAt(j2).getSequenceAnnotationByType("weight", 0).getIdentifier());
                intens[i - off][j2] = Math.log(weight[j2] + 1.0E-6);
                ++j2;
            }
            j2 = 0;
            while (j2 < weight.length) {
                weight[j2] = 1.0 / (1.0 + Math.exp(-1.0 * (Math.log(weight[j2]) - Math.log(0.25))));
                ++j2;
            }
            weights[i - off] = weight;
            bgWeights[i - off] = Interpolation.getBgWeight(weight);
            ++i;
        }
        double avgNum = 0.0;
        int i2 = 0;
        while (i2 < ds.length) {
            avgNum += (double)ds[i2].getNumberOfElements();
            ++i2;
        }
        avgNum /= (double)ds.length;
        i2 = 0;
        while (i2 < weights.length) {
            int j3 = 0;
            while (j3 < weights[i2].length) {
                double[] dArray = weights[i2];
                int n = j3;
                dArray[n] = dArray[n] * (avgNum / (double)weights[i2].length);
                double[] dArray2 = bgWeights[i2];
                int n2 = j3++;
                dArray2[n2] = dArray2[n2] * (avgNum / (double)weights[i2].length);
            }
            ++i2;
        }
        boolean[] in = new boolean[ds.length];
        Arrays.fill(in, true);
        in[test] = false;
        Pair<DataSet, double[]> trainSet = DataSet.union(ds, weights, in);
        double[] fgTrainWeights = trainSet.getSecondElement();
        double[] bgTrainWeights = DataSet.union(ds, bgWeights, in).getSecondElement();
        double[] trainIntens = DataSet.union(ds, intens, in).getSecondElement();
        double[] testIntens = intens[test];
        double[] fgTestWeights = weights[test];
        double[] bgTestWeights = bgWeights[test];
        cl.train(new DataSet[]{trainSet.getFirstElement(), trainSet.getFirstElement()}, new double[][]{fgTrainWeights, bgTrainWeights});
        double[] trainSc = cl.getScores(trainSet.getFirstElement());
        double[] testSc = cl.getScores(ds[test]);
        System.out.println(cl);
        PrintWriter wr = new PrintWriter(String.valueOf(outPrefix) + "_corr.txt");
        wr.println(ToolBox.pearsonCorrelation(trainIntens, trainSc));
        wr.println(ToolBox.pearsonCorrelation(testIntens, testSc));
        wr.close();
        FileManager.writeFile(String.valueOf(outPrefix) + "_cl.xml", (CharSequence)cl.toXML());
        LimitedSortedList<Integer> list = new LimitedSortedList<Integer>(10);
        LimitedSortedList<Integer> list2 = new LimitedSortedList<Integer>(10);
        int i3 = 0;
        while (i3 < fgTestWeights.length) {
            double w = fgTestWeights[i3] / (fgTestWeights[i3] + bgTestWeights[i3]);
            double s = 1.0 / (1.0 + Math.exp(-testSc[i3]));
            list.insert(w - s, i3);
            list2.insert(s - w, i3);
            ++i3;
        }
        wr = new PrintWriter(String.valueOf(outPrefix) + "_extremes.txt");
        i3 = 0;
        while (i3 < list.getLength()) {
            ComparableElement el = list.getElementAt(i3);
            ts = ds[test].getElementAt((Integer)el.getElement());
            Sequence grna = ((ReferenceSequenceAnnotation)ts.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
            wr.println(grna);
            sb = new StringBuffer();
            j = 0;
            while (j < grna.getLength()) {
                if (grna.discreteVal(j) == ts.discreteVal(j)) {
                    sb.append("|");
                } else {
                    sb.append("x");
                }
                ++j;
            }
            wr.println(sb.toString());
            wr.println(ts + "\t" + el.getWeight() + "\n" + fgTestWeights[(Integer)el.getElement()] + "\t" + bgTestWeights[(Integer)el.getElement()] + "\t" + (Math.exp(testIntens[(Integer)el.getElement()]) - 1.0E-6) + "\n" + testSc[(Integer)el.getElement()] + "\t" + 1.0 / (1.0 + Math.exp(-testSc[(Integer)el.getElement()])));
            ++i3;
        }
        wr.println();
        i3 = 0;
        while (i3 < list2.getLength()) {
            ComparableElement el = list2.getElementAt(i3);
            ts = ds[test].getElementAt((Integer)el.getElement());
            Sequence grna = ((ReferenceSequenceAnnotation)ts.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
            wr.println(grna);
            sb = new StringBuffer();
            j = 0;
            while (j < grna.getLength()) {
                if (grna.discreteVal(j) == ts.discreteVal(j)) {
                    sb.append("|");
                } else {
                    sb.append("x");
                }
                ++j;
            }
            wr.println(sb.toString());
            wr.println(ts + "\t" + el.getWeight() + "\n" + fgTestWeights[(Integer)el.getElement()] + "\t" + bgTestWeights[(Integer)el.getElement()] + "\t" + (Math.exp(testIntens[(Integer)el.getElement()]) - 1.0E-6) + "\n" + testSc[(Integer)el.getElement()] + "\t" + 1.0 / (1.0 + Math.exp(-testSc[(Integer)el.getElement()])));
            ++i3;
        }
        wr.close();
        System.out.println("train correlation: " + ToolBox.pearsonCorrelation(trainIntens, trainSc));
        System.out.println("test correlation: " + ToolBox.pearsonCorrelation(testIntens, testSc));
        wr = new PrintWriter(String.valueOf(outPrefix) + "_scores.txt");
        i3 = 0;
        while (i3 < testSc.length) {
            wr.println(String.valueOf(Math.exp(testIntens[i3])) + "\t" + testSc[i3]);
            ++i3;
        }
        wr.close();
    }

    private static enum PosPrior {
        NONE,
        LOGISTIC,
        BINOMIAL,
        PWM;

    }
}

